/*
 * Decompiled with CFR 0.152.
 */
package org.simexid.keycloak.service;

import com.google.gson.Gson;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.simexid.keycloak.enums.KeycloakEnum;
import org.simexid.keycloak.exception.AttributesException;
import org.simexid.keycloak.exception.AuthorizationException;
import org.simexid.keycloak.exception.GenericException;
import org.simexid.keycloak.exception.MultipleRolesFoundException;
import org.simexid.keycloak.exception.MultipleUsersFoundException;
import org.simexid.keycloak.exception.RoleNotFoundException;
import org.simexid.keycloak.exception.UserNotFoundException;
import org.simexid.keycloak.model.KeycloakTokenResponse;
import org.simexid.keycloak.model.SSORoles;
import org.simexid.keycloak.model.SSOUser;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class KeycloakUtil {
    @Value(value="${simexid.security.keycloak.token-url}")
    private String tokenUrl;
    @Value(value="${simexid.security.keycloak.user-url}")
    private String userUrl;
    @Value(value="${simexid.security.keycloak.admin-url}")
    private String adminUrl;
    @Value(value="${simexid.security.keycloak.client-id}")
    private String clientId;
    @Value(value="${simexid.security.keycloak.client-uuid}")
    private String clientUiid;
    @Value(value="${simexid.security.keycloak.client-secret}")
    private String clientSecret;
    @Value(value="${simexid.security.keycloak.grant-type}")
    private String grantType;
    private String token = "";
    private long expiration;
    private HttpHeaders headers = new HttpHeaders();
    private MultiValueMap<String, String> map = new LinkedMultiValueMap();

    private void handleInputForKeycloakAuth() {
        this.headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        if (this.map.isEmpty()) {
            this.map.add((Object)"client_id", (Object)this.clientId);
            this.map.add((Object)"client_secret", (Object)this.clientSecret);
            this.map.add((Object)"grant_type", (Object)this.grantType);
        }
    }

    public boolean authorized() throws AuthorizationException {
        long now = new Date().getTime();
        if (!this.token.isEmpty() && now < this.expiration) {
            return true;
        }
        try {
            RestTemplate rest = new RestTemplate();
            this.handleInputForKeycloakAuth();
            HttpEntity request = new HttpEntity(this.map, (MultiValueMap)this.headers);
            ResponseEntity response = rest.postForEntity(this.tokenUrl, (Object)request, KeycloakTokenResponse.class, new Object[0]);
            KeycloakTokenResponse body = (KeycloakTokenResponse)response.getBody();
            if (response.getStatusCode().is2xxSuccessful() && body != null && !body.getAccessToken().isBlank() && body.getExp() > 0L) {
                this.token = body.getAccessToken();
                this.expiration = new Date().getTime() + body.getExp() * 1000L;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new AuthorizationException();
        }
    }

    public SSOUser getUserInfo(String sub) throws GenericException, AuthorizationException {
        if (!this.authorized()) {
            return null;
        }
        try {
            RestTemplate rest = new RestTemplate();
            this.headers.setContentType(MediaType.APPLICATION_JSON);
            this.headers.setBearerAuth(this.token);
            HttpEntity request = new HttpEntity(null, (MultiValueMap)this.headers);
            ResponseEntity response = rest.exchange(this.userUrl + "/" + sub, HttpMethod.GET, request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                return (SSOUser)new Gson().fromJson((String)response.getBody(), SSOUser.class);
            }
            if (response.getStatusCode().isSameCodeAs((HttpStatusCode)HttpStatus.valueOf((int)404))) {
                return null;
            }
            throw new GenericException();
        }
        catch (Exception e) {
            throw new GenericException();
        }
    }

    public boolean addUserAttributes(String sub, List<HashMap<String, List<String>>> attributes) throws AuthorizationException, GenericException, AttributesException {
        SSOUser user = this.getUserInfo(sub);
        for (HashMap<String, List<String>> attribute : attributes) {
            for (Map.Entry<String, List<String>> entry : attribute.entrySet()) {
                user.getAttributes().put(entry.getKey(), entry.getValue());
            }
        }
        String payload = "{\"email\":\"" + user.getEmail() + "\",\"attributes\":" + new Gson().toJson(user.getAttributes()) + "}}";
        return this.callForAddAttributes(sub, payload);
    }

    public boolean deleteUserAttributes(String sub, List<String> attributes) throws AuthorizationException, GenericException, AttributesException {
        SSOUser user = this.getUserInfo(sub);
        for (String attribute : attributes) {
            user.getAttributes().remove(attribute);
        }
        String payload = "{\"email\":\"" + user.getEmail() + "\",\"attributes\":" + new Gson().toJson(user.getAttributes()) + "}}";
        return this.callForAddAttributes(sub, payload);
    }

    public boolean callForAddAttributes(String sub, String payload) throws AuthorizationException, AttributesException {
        if (!this.authorized()) {
            return false;
        }
        try {
            RestTemplate rest = new RestTemplate();
            this.headers.setContentType(MediaType.APPLICATION_JSON);
            this.headers.setBearerAuth(this.token);
            HttpEntity request = new HttpEntity((Object)payload, (MultiValueMap)this.headers);
            ResponseEntity response = rest.exchange(this.userUrl + "/" + sub, HttpMethod.PUT, request, String.class, new Object[0]);
            return response.getStatusCode().is2xxSuccessful();
        }
        catch (Exception e) {
            throw new AttributesException();
        }
    }

    public boolean addRoleToUser(KeycloakEnum.SearchUserType searchUserType, String searchText, String role, KeycloakEnum.Type type, String clientUUID) throws MultipleUsersFoundException, MultipleRolesFoundException, AuthorizationException, GenericException {
        List<SSOUser> users;
        if (clientUUID == null || clientUUID.isBlank()) {
            clientUUID = this.clientUiid;
        }
        if ((users = this.searchUser(searchUserType, searchText)).size() > 1) {
            throw new MultipleUsersFoundException();
        }
        List<SSORoles> roles = this.searchRoles(role, type, clientUUID);
        if (roles.size() > 1) {
            throw new MultipleRolesFoundException();
        }
        List<SSORoles> userRole = this.retrieveUserRole(users.get(0).getId(), type, clientUUID);
        userRole.add(roles.get(0));
        String payload = userRole.toString();
        return this.callForAddRole(users.get(0).getId(), payload, type, clientUUID);
    }

    public boolean deleteRoleToUser(KeycloakEnum.SearchUserType searchUserType, String searchText, String role, KeycloakEnum.Type type, String clientUUID) throws MultipleUsersFoundException, MultipleRolesFoundException, AuthorizationException, GenericException {
        List<SSOUser> users;
        if (clientUUID == null || clientUUID.isBlank()) {
            clientUUID = this.clientUiid;
        }
        if ((users = this.searchUser(searchUserType, searchText)).size() > 1) {
            throw new MultipleUsersFoundException();
        }
        List<SSORoles> roles = this.searchRoles(role, type, clientUUID);
        if (roles.size() > 1) {
            throw new MultipleRolesFoundException();
        }
        List<SSORoles> userRole = this.retrieveUserRole(users.get(0).getId(), type, clientUUID);
        userRole.remove(roles.get(0));
        String payload = userRole.toString();
        return this.callForAddRole(users.get(0).getId(), payload, type, clientUUID);
    }

    public boolean callForAddRole(String sub, String payload, KeycloakEnum.Type type, String clientUUID) throws AuthorizationException, GenericException {
        if (!this.authorized()) {
            return false;
        }
        try {
            Object path;
            switch (type) {
                case REALM: {
                    path = "/role-mappings/realm";
                    break;
                }
                case CLIENT: {
                    path = "/role-mappings/clients/" + clientUUID;
                    break;
                }
                default: {
                    return false;
                }
            }
            RestTemplate rest = new RestTemplate();
            this.headers.setContentType(MediaType.APPLICATION_JSON);
            this.headers.setBearerAuth(this.token);
            HttpEntity request = new HttpEntity((Object)payload, (MultiValueMap)this.headers);
            ResponseEntity response = rest.exchange(this.userUrl + "/" + sub + (String)path, HttpMethod.POST, request, String.class, new Object[0]);
            return response.getStatusCode().is2xxSuccessful();
        }
        catch (Exception e) {
            throw new GenericException();
        }
    }

    public List<SSOUser> searchUser(KeycloakEnum.SearchUserType searchUserType, String searchText) throws AuthorizationException, GenericException {
        if (!this.authorized()) {
            return null;
        }
        try {
            RestTemplate rest = new RestTemplate();
            this.headers.setContentType(MediaType.APPLICATION_JSON);
            this.headers.setBearerAuth(this.token);
            HttpEntity request = new HttpEntity(null, (MultiValueMap)this.headers);
            ResponseEntity response = rest.exchange(this.userUrl + "?" + searchUserType.getText() + "=" + searchText, HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<List<SSOUser>>(){}, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                if (Objects.requireNonNull((List)response.getBody()).isEmpty()) {
                    throw new UserNotFoundException();
                }
                return Objects.requireNonNull((List)response.getBody());
            }
            throw new GenericException();
        }
        catch (Exception e) {
            throw new GenericException(e);
        }
    }

    public List<SSORoles> searchRoles(String name, KeycloakEnum.Type type, String clientUUID) throws AuthorizationException, GenericException {
        if (!this.authorized()) {
            return null;
        }
        try {
            Object path;
            switch (type) {
                case REALM: {
                    path = "/roles";
                    break;
                }
                case CLIENT: {
                    path = "/clients/" + clientUUID + "/roles";
                    break;
                }
                default: {
                    return null;
                }
            }
            RestTemplate rest = new RestTemplate();
            this.headers.setContentType(MediaType.APPLICATION_JSON);
            this.headers.setBearerAuth(this.token);
            HttpEntity request = new HttpEntity(null, (MultiValueMap)this.headers);
            ResponseEntity response = rest.exchange(this.adminUrl + (String)path + "?search=" + name, HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<List<SSORoles>>(){}, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                if (Objects.requireNonNull((List)response.getBody()).isEmpty()) {
                    throw new RoleNotFoundException();
                }
                return Objects.requireNonNull((List)response.getBody());
            }
            throw new GenericException();
        }
        catch (Exception e) {
            throw new GenericException(e);
        }
    }

    public List<SSORoles> retrieveUserRole(String sub, KeycloakEnum.Type type, String clientUIID) throws AuthorizationException, GenericException {
        if (!this.authorized()) {
            return null;
        }
        try {
            Object urlAppend;
            switch (type) {
                case REALM: {
                    urlAppend = "/role-mappings/realm";
                    break;
                }
                case CLIENT: {
                    urlAppend = "/role-mappings/clients/" + clientUIID;
                    break;
                }
                default: {
                    return null;
                }
            }
            RestTemplate rest = new RestTemplate();
            this.headers.setContentType(MediaType.APPLICATION_JSON);
            this.headers.setBearerAuth(this.token);
            HttpEntity request = new HttpEntity(null, (MultiValueMap)this.headers);
            ResponseEntity response = rest.exchange(this.userUrl + "/" + sub + (String)urlAppend, HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<List<SSORoles>>(){}, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                if (Objects.requireNonNull((List)response.getBody()).isEmpty()) {
                    throw new RoleNotFoundException();
                }
                return (List)response.getBody();
            }
            throw new GenericException();
        }
        catch (Exception e) {
            throw new GenericException(e);
        }
    }
}

