/*
 * Decompiled with CFR 0.152.
 */
package com.pressassociation.pr.ast.visitor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.pressassociation.pr.ast.AstNode;
import com.pressassociation.pr.ast.Field;
import com.pressassociation.pr.ast.Fields;
import com.pressassociation.pr.ast.Name;
import com.pressassociation.pr.ast.Node;
import com.pressassociation.pr.ast.Path;
import com.pressassociation.pr.ast.SubSelection;
import com.pressassociation.pr.ast.Wildcard;
import com.pressassociation.pr.ast.Word;
import com.pressassociation.pr.ast.visitor.TransformingVisitor;
import java.util.Deque;

public class CopyVisitor
extends TransformingVisitor<AstNode> {
    private final Deque<AstNode> stack = Lists.newLinkedList();

    @Override
    public void visitFields(Fields fields) {
        super.visitFields(fields);
        AstNode next = this.stack.removeLast();
        Field field = (Field)this.stack.removeLast();
        this.stack.addLast(this.createFieldsCopy(field, next));
    }

    @Override
    public void visitPath(Path path) {
        super.visitPath(path);
        Field suffix = (Field)this.stack.removeLast();
        Node prefix = (Node)this.stack.removeLast();
        this.stack.addLast(this.createPathCopy(prefix, suffix));
    }

    @Override
    public void visitSubSelection(SubSelection subSelection) {
        super.visitSubSelection(subSelection);
        AstNode fields = this.stack.removeLast();
        Name name = (Name)this.stack.removeLast();
        this.stack.addLast(this.createSubSelectionCopy(name, fields));
    }

    @Override
    public void visitWildcard(Wildcard wildcard) {
        this.stack.addLast(wildcard);
    }

    @Override
    public void visitWord(Word word) {
        this.stack.addLast(this.createWordCopy(word.getStringValue()));
    }

    @Override
    public AstNode getResult() {
        Preconditions.checkState((!this.stack.isEmpty() ? 1 : 0) != 0, (Object)"Cannot get the result when the visitor hasn't been used yet");
        return this.stack.getLast();
    }

    protected Fields createFieldsCopy(Field field, AstNode next) {
        return new Fields(field, next);
    }

    protected Path createPathCopy(Node prefix, Field suffix) {
        return new Path(prefix, suffix);
    }

    protected SubSelection createSubSelectionCopy(Name name, AstNode fields) {
        return new SubSelection(name, fields);
    }

    protected Word createWordCopy(String stringValue) {
        return new Word(stringValue);
    }
}

