/*
 * Decompiled with CFR 0.152.
 */
package com.pressassociation.pr.ast.visitor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.pressassociation.pr.ast.AstNode;
import com.pressassociation.pr.ast.Field;
import com.pressassociation.pr.ast.Fields;
import com.pressassociation.pr.ast.Node;
import com.pressassociation.pr.ast.Path;
import com.pressassociation.pr.ast.SubSelection;
import com.pressassociation.pr.ast.Wildcard;
import com.pressassociation.pr.ast.Word;
import com.pressassociation.pr.ast.visitor.FindFieldsVisitor;
import com.pressassociation.pr.ast.visitor.PathPostfixingVisitor;
import com.pressassociation.pr.ast.visitor.PathPrefixingVisitor;
import com.pressassociation.pr.ast.visitor.TransformingVisitor;
import java.util.Deque;

public class ExpandingVisitor
extends TransformingVisitor<AstNode> {
    private final Deque<AstNode> stack = Lists.newLinkedList();

    @Override
    public void visitFields(Fields fields) {
        super.visitFields(fields);
        AstNode top = this.stack.removeLast();
        AstNode bottom = this.stack.removeLast();
        this.stack.addLast(new Fields((Field)bottom, top));
    }

    @Override
    public void visitPath(Path path) {
        super.visitPath(path);
        AstNode top = this.stack.removeLast();
        AstNode bottom = this.stack.removeLast();
        if (bottom instanceof Fields) {
            if (top instanceof Fields) {
                AstNode result = this.crossJoinFields((Fields)top, (Fields)bottom);
                this.stack.add(result);
            } else {
                AstNode left = (AstNode)new PathPostfixingVisitor((Field)top).applyTo(bottom);
                this.stack.addLast(left);
            }
        } else {
            assert (bottom instanceof Node) : "Bottom should be an instance of node, found: " + bottom;
            this.stack.addLast((AstNode)new PathPrefixingVisitor((Node)bottom).applyTo(top));
        }
    }

    @Override
    public void visitSubSelection(SubSelection subSelection) {
        AstNode expandedFields = (AstNode)new ExpandingVisitor().applyTo(subSelection.getFields());
        AstNode expandedSelection = (AstNode)new PathPrefixingVisitor(subSelection.getName()).applyTo(expandedFields);
        this.stack.addLast(expandedSelection);
    }

    @Override
    public void visitWildcard(Wildcard wildcard) {
        this.stack.addLast(wildcard);
    }

    @Override
    public void visitWord(Word word) {
        this.stack.addLast(word);
    }

    @Override
    public AstNode getResult() {
        Preconditions.checkState((!this.stack.isEmpty() ? 1 : 0) != 0, (Object)"Cannot get the result when the visitor hasn't been used");
        return this.stack.peek();
    }

    private AstNode crossJoinFields(Fields first, Fields second) {
        Iterable firstFields = (Iterable)new FindFieldsVisitor().applyTo(first);
        Iterable secondFields = (Iterable)new FindFieldsVisitor().applyTo(second);
        AstNode result = null;
        for (Field secondField : secondFields) {
            for (Field firstField : firstFields) {
                if (result == null) {
                    result = (AstNode)new PathPostfixingVisitor(firstField).applyTo(secondField);
                    continue;
                }
                Field left = (Field)new PathPostfixingVisitor(firstField).applyTo(secondField);
                result = new Fields(left, result);
            }
        }
        return result;
    }
}

