/*
 * Decompiled with CFR 0.152.
 */
package com.pressassociation.pr.ast.visitor;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pressassociation.pr.ast.Field;
import com.pressassociation.pr.ast.Fields;
import com.pressassociation.pr.ast.Path;
import com.pressassociation.pr.ast.SubSelection;
import com.pressassociation.pr.ast.Wildcard;
import com.pressassociation.pr.ast.Word;
import com.pressassociation.pr.ast.visitor.TransformingVisitor;
import java.util.List;

public class FindFieldsVisitor
extends TransformingVisitor<Iterable<Field>> {
    private final List<Fields> result = Lists.newArrayList();
    private Field last;

    @Override
    public void visitFields(Fields fields) {
        this.result.add(fields);
        super.visitFields(fields);
    }

    @Override
    public Iterable<Field> getResult() {
        return this.getFields();
    }

    @Override
    public void visitPath(Path path) {
        this.last = (Field)MoreObjects.firstNonNull((Object)this.last, (Object)path);
    }

    @Override
    public void visitSubSelection(SubSelection subSelection) {
        this.last = (Field)MoreObjects.firstNonNull((Object)this.last, (Object)subSelection);
    }

    @Override
    public void visitWildcard(Wildcard wildcard) {
        this.last = (Field)MoreObjects.firstNonNull((Object)this.last, (Object)wildcard);
    }

    @Override
    public void visitWord(Word word) {
        this.last = (Field)MoreObjects.firstNonNull((Object)this.last, (Object)word);
    }

    private Iterable<Field> getFields() {
        if (this.result.isEmpty()) {
            Preconditions.checkState((this.last != null ? 1 : 0) != 0, (Object)"Cannot get the result if the visitor hasn't been used");
            return ImmutableList.of((Object)this.last);
        }
        List allButLast = Lists.transform(this.result, (Function)new Function<Fields, Field>(){

            public Field apply(Fields input) {
                return input.getField();
            }
        });
        return Iterables.concat((Iterable)ImmutableList.of((Object)this.getEnd()), (Iterable)Lists.reverse((List)allButLast));
    }

    private Field getEnd() {
        return (Field)((Fields)Iterables.getLast(this.result)).getNext();
    }
}

