/*
 * Decompiled with CFR 0.152.
 */
package com.pressassociation.pr.ast.visitor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.pressassociation.pr.ast.Fields;
import com.pressassociation.pr.ast.Path;
import com.pressassociation.pr.ast.SubSelection;
import com.pressassociation.pr.ast.Wildcard;
import com.pressassociation.pr.ast.Word;
import com.pressassociation.pr.ast.visitor.TransformingVisitor;
import java.util.Deque;

public class MatchesParentVisitor
extends TransformingVisitor<Boolean> {
    private final ImmutableList<String> pathParts;
    private final Deque<Integer> pathIndexStack = Queues.newArrayDeque((Iterable)ImmutableList.of((Object)0));
    private final Deque<Boolean> matchStack = Queues.newArrayDeque((Iterable)ImmutableList.of((Object)true));
    private boolean matched = false;

    public MatchesParentVisitor(Iterable<String> pathParts) {
        this.pathParts = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(pathParts)));
    }

    @Override
    public void visitFields(Fields fields) {
        this.pushPathIndex();
        super.visitFields(fields);
    }

    @Override
    protected boolean beforeFieldsNext(Fields fields) {
        if (this.matched || this.fieldStillMatches()) {
            return false;
        }
        this.resetPathIndex();
        this.resetFieldMatchStatus();
        return true;
    }

    @Override
    protected boolean beforePathField(Path path) {
        return !this.matched && this.fieldStillMatches();
    }

    @Override
    protected boolean beforeSubSelectionFields(SubSelection subSelection) {
        if (this.matched || !this.fieldStillMatches()) {
            return false;
        }
        this.matchStack.addLast(true);
        return true;
    }

    @Override
    public void visitWildcard(Wildcard wildcard) {
        this.matched = true;
    }

    @Override
    public void visitWord(Word word) {
        int index;
        String pathPart;
        String wordString = word.getStringValue();
        if (wordString.equals(pathPart = (String)this.pathParts.get(index = this.getAndIncrementPathIndex()))) {
            if (this.pathExhausted()) {
                this.matched = true;
            }
        } else {
            this.fieldNoLongerMatches();
        }
    }

    @Override
    public Boolean getResult() {
        return this.matched || this.pathFullyMatched();
    }

    private boolean pathFullyMatched() {
        return this.fieldStillMatches() && this.pathExhausted();
    }

    private boolean pathExhausted() {
        return this.getPathIndex() == this.pathParts.size();
    }

    private int getAndIncrementPathIndex() {
        int index = this.pathIndexStack.removeLast();
        this.pathIndexStack.addLast(index + 1);
        return index;
    }

    private int getPathIndex() {
        return this.pathIndexStack.peekLast();
    }

    private void pushPathIndex() {
        if (this.pathIndexStack.isEmpty()) {
            this.pathIndexStack.addLast(0);
        } else {
            this.pathIndexStack.addLast(this.pathIndexStack.peekLast());
        }
    }

    private void resetPathIndex() {
        this.pathIndexStack.removeLast();
        Preconditions.checkState((!this.pathIndexStack.isEmpty() ? 1 : 0) != 0);
    }

    private boolean fieldStillMatches() {
        return this.matchStack.getLast();
    }

    private void fieldNoLongerMatches() {
        this.matchStack.removeLast();
        this.matchStack.addLast(false);
    }

    private void resetFieldMatchStatus() {
        this.matchStack.removeLast();
        this.matchStack.addLast(true);
    }
}

