/*
 * Decompiled with CFR 0.152.
 */
package com.pressassociation.pr.ast.visitor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.pressassociation.pr.ast.Fields;
import com.pressassociation.pr.ast.Path;
import com.pressassociation.pr.ast.SubSelection;
import com.pressassociation.pr.ast.Wildcard;
import com.pressassociation.pr.ast.Word;
import com.pressassociation.pr.ast.visitor.TransformingVisitor;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;

public class MatchesPathVisitor
extends TransformingVisitor<Boolean> {
    private boolean wasWildcard = false;
    private final ImmutableList<String> pathParts;
    private final Deque<Integer> pathIndexStack = new ArrayDeque<Integer>((Collection<Integer>)ImmutableList.of((Object)0));
    private final Deque<Boolean> matchesStack = new ArrayDeque<Boolean>((Collection<Boolean>)ImmutableList.of((Object)false));

    public MatchesPathVisitor(Iterable<String> pathParts) {
        this.pathParts = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(pathParts)));
    }

    @Override
    protected boolean beforeFieldsNext(Fields fields) {
        if (this.matches()) {
            return false;
        }
        this.pathIndexStack.removeLast();
        this.pathIndexStack.add((Integer)MoreObjects.firstNonNull((Object)this.pathIndexStack.peekLast(), (Object)0));
        return true;
    }

    @Override
    protected boolean beforePathField(Path path) {
        return this.matches();
    }

    @Override
    protected boolean beforeSubSelectionFields(SubSelection subSelection) {
        boolean matches = this.matches();
        if (matches) {
            this.pathIndexStack.addLast(this.pathIndexStack.peekLast());
            this.matchesStack.addLast(matches);
            return true;
        }
        return false;
    }

    @Override
    protected void afterSubSelectionFields(SubSelection subSelection) {
        int index = this.pathIndexStack.removeLast();
        this.pathIndexStack.removeLast();
        this.pathIndexStack.addLast(index);
        this.setMatches(this.matchesStack.removeLast());
    }

    @Override
    public void visitWildcard(Wildcard wildcard) {
        this.setMatches(true);
        this.wasWildcard = true;
        this.getAndIncrementPathIndex();
    }

    @Override
    public void visitWord(Word word) {
        String wordString = word.getStringValue();
        int index = this.getAndIncrementPathIndex();
        if (this.wasWildcard) {
            boolean found = false;
            while (index < this.pathParts.size()) {
                if (wordString.equals(this.pathParts.get(index))) {
                    found = true;
                    break;
                }
                index = this.getAndIncrementPathIndex();
            }
            this.setMatches(found);
        } else {
            this.setMatches(index < this.pathParts.size() && ((String)this.pathParts.get(index)).equals(wordString));
        }
    }

    @Override
    public Boolean getResult() {
        return this.matches();
    }

    private int getAndIncrementPathIndex() {
        int index = this.pathIndexStack.removeLast();
        this.pathIndexStack.addLast(index + 1);
        return index;
    }

    private boolean matches() {
        return this.matchesStack.peekLast();
    }

    private void setMatches(boolean matches) {
        this.matchesStack.removeLast();
        this.matchesStack.addLast(matches);
    }
}

