/*
 * Decompiled with CFR 0.152.
 */
package com.pressassociation.pr.ast.visitor;

import com.google.common.base.Preconditions;
import com.pressassociation.pr.ast.AstNode;
import com.pressassociation.pr.ast.Field;
import com.pressassociation.pr.ast.Fields;
import com.pressassociation.pr.ast.Node;
import com.pressassociation.pr.ast.Path;
import com.pressassociation.pr.ast.SubSelection;
import com.pressassociation.pr.ast.Wildcard;
import com.pressassociation.pr.ast.Word;
import com.pressassociation.pr.ast.visitor.TransformingVisitor;
import com.pressassociation.pr.parser.Parser;

public class PathPostfixingVisitor
extends TransformingVisitor<AstNode> {
    private final Field postfix;
    private AstNode result;

    public PathPostfixingVisitor(Field postfix) {
        this.postfix = postfix;
    }

    @Override
    public void visitFields(Fields fields) {
        Field field = (Field)this.appendPostfix(fields.getField());
        AstNode next = (AstNode)new PathPostfixingVisitor(this.postfix).applyTo(fields.getNext());
        this.result = new Fields(field, next);
    }

    @Override
    public void visitPath(Path path) {
        this.result = this.appendPostfix(path);
    }

    @Override
    public void visitSubSelection(SubSelection subSelection) {
        this.result = this.appendPostfix(subSelection);
    }

    @Override
    public void visitWildcard(Wildcard wildcard) {
        this.result = this.appendPostfix(wildcard);
    }

    @Override
    public void visitWord(Word word) {
        this.result = this.appendPostfix(word);
    }

    @Override
    public AstNode getResult() {
        Preconditions.checkState((this.result != null ? 1 : 0) != 0, (Object)"Cannot get the result without first using the visitor");
        return this.result;
    }

    private Path appendPostfix(Node wildcard) {
        return new Path(wildcard, this.postfix);
    }

    private AstNode appendPostfix(AstNode node) {
        return new Parser().parse(node + "/" + this.postfix);
    }
}

