/*
 * Decompiled with CFR 0.152.
 */
package com.pressassociation.pr.ast.visitor;

import com.google.common.base.Preconditions;
import com.pressassociation.pr.ast.AstNode;
import com.pressassociation.pr.ast.Fields;
import com.pressassociation.pr.ast.Node;
import com.pressassociation.pr.ast.Path;
import com.pressassociation.pr.ast.SubSelection;
import com.pressassociation.pr.ast.Wildcard;
import com.pressassociation.pr.ast.Word;
import com.pressassociation.pr.ast.visitor.TransformingVisitor;

public class PathPrefixingVisitor
extends TransformingVisitor<AstNode> {
    private final Node prefix;
    private AstNode result;

    public PathPrefixingVisitor(Node prefix) {
        this.prefix = prefix;
    }

    @Override
    public void visitFields(Fields fields) {
        if (this.result == null) {
            this.result = new Fields(new Path(this.prefix, fields.getField()), (AstNode)new PathPrefixingVisitor(this.prefix).applyTo(fields.getNext()));
        } else {
            super.visitFields(fields);
        }
    }

    @Override
    public void visitPath(Path path) {
        if (this.result == null) {
            this.result = new Path(this.prefix, path);
        } else {
            super.visitPath(path);
        }
    }

    @Override
    public void visitSubSelection(SubSelection subSelection) {
        if (this.result == null) {
            this.result = new Path(this.prefix, subSelection);
        } else {
            super.visitSubSelection(subSelection);
        }
    }

    @Override
    public void visitWildcard(Wildcard wildcard) {
        if (this.result == null) {
            this.result = new Path(this.prefix, wildcard);
        } else {
            super.visitWildcard(wildcard);
        }
    }

    @Override
    public void visitWord(Word word) {
        if (this.result == null) {
            this.result = new Path(this.prefix, word);
        } else {
            super.visitWord(word);
        }
    }

    @Override
    public AstNode getResult() {
        Preconditions.checkState((this.result != null ? 1 : 0) != 0, (Object)"Cannot get the result if this visitor hasn't been used.");
        return this.result;
    }
}

