/*
 * Decompiled with CFR 0.152.
 */
package com.pressassociation.pr.match;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.pressassociation.pr.ast.AstNode;
import com.pressassociation.pr.ast.Word;
import com.pressassociation.pr.ast.visitor.CopyVisitor;
import com.pressassociation.pr.match.AllMatcher;
import com.pressassociation.pr.match.AstMatcher;
import com.pressassociation.pr.match.Leaf;
import com.pressassociation.pr.parser.Parser;
import javax.annotation.Nullable;

public abstract class Matcher
implements Predicate<Leaf> {
    public static Matcher all() {
        return AllMatcher.INSTANCE;
    }

    public static Matcher of(CharSequence fields) {
        if ("*".equals(fields)) {
            return Matcher.all();
        }
        return new AstMatcher(new Parser().parse((CharSequence)Preconditions.checkNotNull((Object)fields)));
    }

    Matcher() {
    }

    public boolean matchesAll() {
        return "*".equals(this.patternString());
    }

    public abstract boolean matches(Leaf var1);

    public boolean matches(CharSequence path) {
        return this.matches(Leaf.fromPath(path));
    }

    public abstract boolean matchesParent(Leaf var1);

    public boolean matchesParent(CharSequence path) {
        return this.matchesParent(Leaf.fromPath(path));
    }

    public Matcher transform(final Function<? super String, String> nameTransformer) {
        Preconditions.checkNotNull(nameTransformer);
        if (this.matchesAll()) {
            return this;
        }
        AstNode ast = this.getAstNode();
        AstNode transformed = (AstNode)new CopyVisitor(){

            @Override
            protected Word createWordCopy(String stringValue) {
                return super.createWordCopy((String)nameTransformer.apply((Object)stringValue));
            }
        }.applyTo(ast);
        return new AstMatcher(transformed);
    }

    @Deprecated
    public boolean apply(@Nullable Leaf input) {
        return input != null && this.matches(input);
    }

    public String toString() {
        if (this.matchesAll()) {
            return "Matcher.all()";
        }
        return "Matcher.of(" + this.patternString() + ')';
    }

    protected abstract String patternString();

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Matcher)) {
            return false;
        }
        Matcher other = (Matcher)obj;
        return other.patternString().equals(this.patternString());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Matcher.class, this.patternString()});
    }

    protected AstNode getAstNode() {
        return new Parser().parse(this.patternString());
    }
}

