/*
 * Decompiled with CFR 0.152.
 */
package com.pressassociation.pr.parser;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.pressassociation.pr.ast.AstNode;
import com.pressassociation.pr.ast.Field;
import com.pressassociation.pr.ast.Fields;
import com.pressassociation.pr.ast.Name;
import com.pressassociation.pr.ast.Node;
import com.pressassociation.pr.ast.Path;
import com.pressassociation.pr.ast.SubSelection;
import com.pressassociation.pr.ast.Wildcard;
import com.pressassociation.pr.ast.Word;

public class Parser {
    private static final CharMatcher WORD_CHAR_MATCHER = CharMatcher.whitespace().negate().and(CharMatcher.noneOf((CharSequence)",/()*"));

    public AstNode parse(CharSequence input) {
        return this.parse(new Input((CharSequence)Preconditions.checkNotNull((Object)input)));
    }

    private AstNode parse(Input input) {
        AstNode result = this.parseFields(input);
        if (!input.isEof()) {
            throw new IllegalArgumentException("Unexpected characters '" + input.getRemaining() + '\'');
        }
        return result;
    }

    private AstNode parseFields(Input input) {
        Field field = this.parseField(input);
        if (input.consumeIf(',')) {
            AstNode fields = this.parseFields(input);
            return new Fields(field, fields);
        }
        return field;
    }

    private Field parseField(Input input) {
        Node node = this.parseNode(input);
        if (input.consumeIf('/')) {
            Field field = this.parseField(input);
            return new Path(node, field);
        }
        return node;
    }

    private Node parseNode(Input input) {
        Name name = this.parseName(input);
        if (input.consumeIf('(')) {
            AstNode fields = this.parseFields(input);
            input.consume(')');
            return new SubSelection(name, fields);
        }
        return name;
    }

    private Name parseName(Input input) {
        return input.consumeIf('*') ? Wildcard.getSharedInstance() : new Word(input.consume(WORD_CHAR_MATCHER));
    }

    private static final class Input {
        private final CharSequence chars;
        private int offset = 0;

        private Input(CharSequence chars) {
            this.chars = chars;
        }

        public boolean isEof() {
            return this.offset == this.chars.length();
        }

        public boolean consumeIf(char character) {
            if (!this.isEof() && this.chars.charAt(this.offset) == character) {
                ++this.offset;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String consume(CharMatcher matcher) {
            int lastIndex;
            for (lastIndex = this.offset; lastIndex < this.chars.length() && matcher.matches(this.chars.charAt(lastIndex)); ++lastIndex) {
            }
            if (lastIndex == this.offset) {
                throw new IllegalArgumentException("Was expecting at least one of " + matcher);
            }
            try {
                String string = this.chars.subSequence(this.offset, lastIndex).toString();
                return string;
            }
            finally {
                this.offset = lastIndex;
            }
        }

        public void consume(char character) {
            if (this.isEof()) {
                throw new IllegalArgumentException("We reached the end of the file, expecting '" + character + '\'');
            }
            char value = this.chars.charAt(this.offset);
            if (value != character) {
                throw new IllegalArgumentException("Expecting '" + character + "' at offset " + this.offset);
            }
            ++this.offset;
        }

        public String getRemaining() {
            return this.chars.subSequence(this.offset, this.chars.length()).toString();
        }
    }
}

