/*
 * Decompiled with CFR 0.152.
 */
package org.simple4j.wsfeeler.core;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.simple4j.wsfeeler.model.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigLoader {
    private static Logger logger = LoggerFactory.getLogger(ConfigLoader.class);

    public static Map<String, Object> loadVariables(InputStream variablesStream, Map<String, Object> globalVariables2, String prefix) throws IOException, EvalError {
        logger.info("Inside loadVariables: {}, {}", globalVariables2, (Object)prefix);
        if (prefix == null) {
            prefix = "";
        }
        Properties loadedVariables = new Properties();
        loadedVariables.load(variablesStream);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (globalVariables2 != null) {
            ret.putAll(globalVariables2);
        }
        Interpreter bsh = new Interpreter();
        if (globalVariables2 != null) {
            for (Map.Entry<String, Object> entry : globalVariables2.entrySet()) {
                bsh.set(entry.getKey(), entry.getValue());
            }
        }
        ArrayList<Object> sortedKeys = new ArrayList<Object>(loadedVariables.keySet());
        Collections.sort(sortedKeys);
        for (String string : sortedKeys) {
            Object eval;
            logger.debug("processing key:" + string);
            try {
                eval = bsh.eval(loadedVariables.getProperty(string));
            }
            catch (EvalError e) {
                if (e.getMessage().contains("number too big for integer type")) {
                    eval = bsh.eval("\"" + loadedVariables.getProperty(string) + "\"");
                }
                throw e;
            }
            logger.debug("Beanshell evaluated value:" + String.valueOf(eval));
            if (eval != null) {
                ret.put(prefix + string, eval);
                bsh.set(prefix + string, eval);
                logger.debug("set evaluated:" + string + ":" + String.valueOf(eval));
                continue;
            }
            ret.put(prefix + string, loadedVariables.getProperty(string));
            bsh.set(prefix + string, (Object)loadedVariables.getProperty(string));
            logger.debug("set unevaluated:" + string + ":" + loadedVariables.getProperty(string));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> loadVariables(File testStepFile, TestCase testCase) throws IOException {
        logger.info("Inside loadVariables: {}, {}", (Object)testStepFile, (Object)testCase);
        try (FileInputStream variablesStream = null;){
            variablesStream = new FileInputStream(testStepFile);
            Properties loadedVariables = new Properties();
            loadedVariables.load(variablesStream);
            logger.info("loadedVariables:{}", (Object)loadedVariables);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ArrayList<Object> sortedKeys = new ArrayList<Object>(loadedVariables.keySet());
            Collections.sort(sortedKeys);
            for (String string : sortedKeys) {
                logger.info("processing key:" + string);
                Object eval = testCase.getProperty(loadedVariables.getProperty(string));
                logger.info("Dereferenced test case property value:" + String.valueOf(eval));
                if (eval == null) {
                    eval = loadedVariables.getProperty(string);
                }
                ret.put(string, eval);
            }
            HashMap<String, Object> hashMap = ret;
            return hashMap;
        }
    }
}

