/*
 * Decompiled with CFR 0.152.
 */
package org.simple4j.wsfeeler.core;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.simple4j.wsfeeler.model.TestCase;
import org.simple4j.wsfeeler.model.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCaseExecutor {
    private static Logger logger = LoggerFactory.getLogger(TestCaseExecutor.class);
    private ExecutorService testCasesExecutorService = null;
    private TestCase parent = null;

    public TestCaseExecutor(TestCase parent) {
        this.parent = parent;
    }

    private ExecutorService getTestCasesExecutorService(int threadPoolSize) {
        if (this.testCasesExecutorService == null) {
            this.testCasesExecutorService = Executors.newFixedThreadPool(threadPoolSize);
        }
        return this.testCasesExecutorService;
    }

    public List<TestCase> execute(File parentTestCasesDir, TestSuite testSuite) {
        logger.info("Entering execute {}", (Object)parentTestCasesDir);
        if (!parentTestCasesDir.exists() || !parentTestCasesDir.isDirectory()) {
            throw new RuntimeException("Path does not exist or is not a directory:" + String.valueOf(parentTestCasesDir));
        }
        try {
            int i;
            File[] testCaseDirs = parentTestCasesDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && pathname.exists();
                }
            });
            ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(testCaseDirs.length);
            ArrayList<TestCase> testCases = new ArrayList<TestCase>(testCaseDirs.length);
            for (i = 0; i < testCaseDirs.length; ++i) {
                logger.info("Submitting :" + String.valueOf(testCaseDirs[i]));
                if (!testCaseDirs[i].isDirectory()) continue;
                TestCase tc = new TestCase(testCaseDirs[i], testSuite, this.parent);
                Future<Boolean> future = this.getTestCasesExecutorService(testSuite.getTestCaseExecutorThreadPoolSize()).submit(tc);
                testCases.add(tc);
                futures.add(future);
            }
            for (i = 0; i < testCaseDirs.length; ++i) {
                logger.info("waiting :" + String.valueOf(testCaseDirs[i]));
                ((Future)futures.get(i)).get();
            }
            ArrayList<TestCase> arrayList = testCases;
            return arrayList;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            logger.info("Exiting execute {}", (Object)parentTestCasesDir);
        }
    }
}

