/*
 * Decompiled with CFR 0.152.
 */
package org.simple4j.wsfeeler.model;

import bsh.EvalError;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.simple4j.wsfeeler.core.ConfigLoader;
import org.simple4j.wsfeeler.core.TestCaseExecutor;
import org.simple4j.wsfeeler.model.TestStep;
import org.simple4j.wsfeeler.model.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCase
implements Callable<Boolean> {
    private static Logger logger = LoggerFactory.getLogger(TestCase.class);
    public String name = null;
    public File testCaseDirectory = null;
    public TestCase parent = null;
    public TestSuite testSuite = null;
    public Map<String, Object> testCaseVariables = null;
    public Map<String, TestStep> executedTestSteps = new HashMap<String, TestStep>();
    private TestCaseExecutor testCaseExecutor = new TestCaseExecutor(this);
    private Boolean success = null;
    private List<TestCase> subTestCases = null;

    public Boolean getSuccess() {
        return this.success;
    }

    public TestCase(File testCaseDirectory, TestSuite testSuite, TestCase parent) {
        this.testSuite = testSuite;
        this.name = testCaseDirectory.getAbsolutePath().substring(this.testSuite.getTestSuiteDirectory().getAbsolutePath().length());
        this.testCaseDirectory = testCaseDirectory;
        this.parent = parent;
    }

    public boolean execute() throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, InterruptedException, ExecutionException {
        logger.info("Inside execute:{}", (Object)this.name);
        if (!this.testSuite.canExecute(this.name)) {
            return this.success;
        }
        this.initVariables();
        this.loadCustomVariables();
        this.executeTestSteps();
        if (this.success.booleanValue()) {
            this.subTestCases = this.testCaseExecutor.execute(this.testCaseDirectory, this.testSuite);
            for (int i = 0; i < this.subTestCases.size(); ++i) {
                if (this.subTestCases.get((int)i).success.booleanValue()) continue;
                this.success = false;
                return this.success;
            }
        }
        return this.success;
    }

    private void executeTestSteps() throws FileNotFoundException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        File[] testStepFiles = this.testCaseDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.isDirectory() && pathname.exists()) {
                    return pathname.getName().endsWith("input.properties");
                }
                return false;
            }
        });
        List<File> sortTestStepFiles = this.sortFiles(testStepFiles);
        logger.info("found teststeps:{}", sortTestStepFiles);
        for (int i = 0; i < sortTestStepFiles.size(); ++i) {
            File testStepFile = sortTestStepFiles.get(i);
            logger.info("Processing file:" + String.valueOf(testStepFile));
            this.success = this.executeTestStep(testStepFile);
            if (this.success.booleanValue()) continue;
            this.testSuite.addFailedTestCases(this);
            return;
        }
    }

    private boolean executeTestStep(File testStepFile) throws FileNotFoundException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        Map<String, Object> testStepInputVariables = ConfigLoader.loadVariables(testStepFile, this);
        logger.info("Teststep input variables:{}", testStepInputVariables);
        String typeOfStep = (String)testStepInputVariables.get("TypeOfStep");
        if (typeOfStep == null || typeOfStep.trim().length() == 0) {
            logger.error("TypeOfStep missing in file:" + String.valueOf(testStepFile));
            return false;
        }
        TestStep step = TestStep.getInstance(typeOfStep, testStepInputVariables, testStepFile, this, this.testSuite);
        this.executedTestSteps.put(step.shortName, step);
        boolean ret = step.execute();
        return ret;
    }

    private List<File> sortFiles(File[] testcaseDirs) {
        List<File> testcaseDirsList = null;
        if (testcaseDirs != null) {
            testcaseDirsList = Arrays.asList(testcaseDirs);
            Comparator<File> c = new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            };
            Collections.sort(testcaseDirsList, c);
        }
        return testcaseDirsList;
    }

    private void initVariables() {
        if (this.testCaseVariables == null) {
            this.testCaseVariables = new ConcurrentHashMap<String, Object>();
            Map<String, Object> testSuiteVariables = this.testSuite.getTestSuiteVariables();
            for (Map.Entry<String, Object> entry : testSuiteVariables.entrySet()) {
                this.testCaseVariables.put(entry.getKey(), entry.getValue());
            }
            this.testCaseVariables.put("TESTCASE/STARTTIME", "" + System.currentTimeMillis());
            this.testCaseVariables.put("TESTCASE/UUID", UUID.randomUUID().toString());
            this.testCaseVariables.put("TESTCASE/RAND5", "" + Math.round(Math.random() * 99999.0));
            this.testCaseVariables.put("TESTCASE/RAND10", "" + Math.round(Math.random() * 9.999999999E9));
        }
    }

    private void loadCustomVariables() {
        InputStream variablesStream = null;
        try {
            File tcVariablesFile = new File(this.testCaseDirectory, "tcvariables.properties");
            if (tcVariablesFile.exists()) {
                variablesStream = new FileInputStream(tcVariablesFile);
                this.testCaseVariables = ConfigLoader.loadVariables(variablesStream, this.testCaseVariables, "TESTCASE/");
            }
        }
        catch (EvalError e) {
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (variablesStream != null) {
                try {
                    variablesStream.close();
                }
                catch (IOException e) {
                    logger.warn("Error while closing cutom variable stream for case:{}", (Object)this.name, (Object)e);
                }
            }
        }
    }

    @Override
    public Boolean call() throws Exception {
        this.execute();
        if (this.success == null) {
            logger.info("SKIPPING: Testcase {}", (Object)this.name);
        }
        if (!this.success.booleanValue()) {
            logger.info("FAILURE: Testcase {}", (Object)this.name);
        }
        return this.success;
    }

    public Object getProperty(String key) {
        logger.info("Entering getProperty {} {}", (Object)this.testCaseDirectory, (Object)key);
        if (key.startsWith("../")) {
            logger.info("Starts with ../");
            if (this.parent != null) {
                return this.parent.getProperty(key.substring(3));
            }
            throw new RuntimeException("Looking up parent property:" + key + ", missing parent test case.");
        }
        if (key.startsWith("TESTSUITE/")) {
            logger.info("Starts with TESTSUITE/");
            key = key.substring(10);
            return this.testSuite.getTestSuiteVariableValue(key);
        }
        if (key.startsWith("./")) {
            logger.info("Starts with ./");
            key = key.substring(2);
        }
        if (key.startsWith("TESTCASE/")) {
            logger.info("Starts with TESTCASE/");
            return this.testCaseVariables.get(key);
        }
        if (key.indexOf("/") > 1) {
            logger.info("Contains /");
            String stepName = key.substring(0, key.indexOf("/"));
            logger.info("stepName {}", (Object)stepName);
            if (stepName == null || stepName.trim().length() < 1) {
                return null;
            }
            key = key.substring(key.indexOf("/") + 1);
            logger.info("key {}", (Object)key);
            if (key == null || key.trim().length() < 1) {
                return null;
            }
            TestStep testStep = this.executedTestSteps.get(stepName);
            logger.info("testStep {}", (Object)testStep);
            if (testStep == null) {
                return null;
            }
            return testStep.getProperty(key);
        }
        return this.testCaseVariables.get(key);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString()).append(" [name=").append(this.name).append(", testCaseDirectory=").append(this.testCaseDirectory).append(", testCaseVariables=").append(this.testCaseVariables).append(", executedTestSteps=").append(this.executedTestSteps).append(", success=").append(this.success).append(", subTestCases=").append(this.subTestCases).append("]");
        return builder.toString();
    }

    public void generateReport(int level) {
        StringBuilder indentation = this.testSuite.getIndentation(level);
        if (this.success == null) {
            logger.info("{}SKIPPED {}", (Object)indentation, (Object)this.name);
        } else if (this.success.booleanValue()) {
            logger.info("{}PASSED  {}", (Object)indentation, (Object)this.name);
        } else {
            logger.info("{}FAiLED  {}", (Object)indentation, (Object)this.name);
        }
        for (Map.Entry<String, TestStep> entry : this.executedTestSteps.entrySet()) {
            entry.getValue().generateReport(level + 1);
        }
        if (this.subTestCases != null) {
            for (TestCase testCase : this.subTestCases) {
                testCase.generateReport(level + 1);
            }
        }
    }
}

