/*
 * Decompiled with CFR 0.152.
 */
package org.simple4j.wsfeeler.model;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.simple4j.wsclient.caller.Caller;
import org.simple4j.wsclient.caller.CallerFactory;
import org.simple4j.wsclient.exception.SystemException;
import org.simple4j.wsclient.util.CollectionsPathRetreiver;
import org.simple4j.wsfeeler.core.ConfigLoader;
import org.simple4j.wsfeeler.model.TestCase;
import org.simple4j.wsfeeler.model.TestStep;
import org.simple4j.wsfeeler.model.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class WSTestStep
extends TestStep {
    private static Logger logger = LoggerFactory.getLogger(WSTestStep.class);

    public WSTestStep(Map<String, Object> testStepInputVariables, File testStepInputFile, TestCase parent, TestSuite testSuite) {
        super(testStepInputVariables, testStepInputFile, parent, testSuite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        logger.info("Entering execute:{}", (Object)this.name);
        try {
            Caller caller = null;
            Object callerBeanIdObj = this.testStepVariables.get("callerBeanId");
            if (callerBeanIdObj != null) {
                String callerBeanId = (String)callerBeanIdObj;
                caller = this.getCaller(callerBeanId);
            } else {
                Object callerFactoryBeanIdObj = this.testStepVariables.get("callerFactoryBeanId");
                if (callerFactoryBeanIdObj != null) {
                    String callerFactoryBeanId = (String)callerFactoryBeanIdObj;
                    caller = this.getCallerFactory(callerFactoryBeanId).getCaller();
                } else {
                    throw new SystemException("callerBeanId-callerFactoryBeanId-missing", "Both callerBeanId and callerFactoryBeanId is missing in the file:" + String.valueOf(this.testStepInputFile));
                }
            }
            logger.info("Calling service");
            Map response = caller.call((Object)this.testStepVariables);
            logger.info("response from service call:" + String.valueOf(response));
            Interpreter bsh = new Interpreter();
            logger.info("Setting step variables");
            for (Map.Entry entry : this.testStepVariables.entrySet()) {
                try {
                    logger.debug("Setting {} : {}", entry.getKey(), entry.getValue());
                    bsh.set((String)entry.getKey(), entry.getValue());
                }
                catch (EvalError e) {
                    logger.error("Error while setting variable for BeanShell step: {} key: {} vaue: {}", new Object[]{this.name, entry.getKey(), entry.getValue(), e});
                }
            }
            logger.info("Setting step response variables");
            for (Map.Entry entry : response.entrySet()) {
                this.testStepVariables.put((String)entry.getKey(), entry.getValue());
                try {
                    logger.debug("Setting {} : {}", entry.getKey(), entry.getValue());
                    bsh.set((String)entry.getKey(), entry.getValue());
                }
                catch (EvalError e) {
                    logger.error("Error while setting output variable for BeanShell step: {} key: {} vaue: {}", new Object[]{this.name, entry.getKey(), entry.getValue(), e});
                }
            }
            File outputPropertiesFile = new File(this.testStepInputFile.getParentFile(), this.testStepInputFile.getName().replace("input.properties", "output.properties"));
            String assertionExpression = null;
            Map<String, Object> testStepOutputVariables = null;
            if (outputPropertiesFile.exists()) {
                testStepOutputVariables = ConfigLoader.loadVariables(outputPropertiesFile, this.parent);
                logger.info("loaded properties:{}", testStepOutputVariables);
                if (testStepOutputVariables.containsKey("ASSERT")) {
                    assertionExpression = String.valueOf(testStepOutputVariables.get("ASSERT"));
                    testStepOutputVariables.remove("ASSERT");
                }
            }
            if (testStepOutputVariables != null) {
                for (Map.Entry entry : testStepOutputVariables.entrySet()) {
                    List nestedProperty;
                    CollectionsPathRetreiver cpr = new CollectionsPathRetreiver();
                    List value = nestedProperty = cpr.getNestedProperty(response, String.valueOf(entry.getValue()));
                    if (nestedProperty.size() == 0) continue;
                    if (nestedProperty.size() == 1) {
                        value = nestedProperty.get(0);
                    }
                    try {
                        logger.info("setting key to intrepreter: {} value: {}", entry.getKey(), (Object)value);
                        bsh.set((String)entry.getKey(), (Object)String.valueOf(value));
                    }
                    catch (EvalError e) {
                        logger.error("Error while setting variable for BeanShell step: {} key: {} vaue: {}", new Object[]{this.name, entry.getKey(), value, e});
                        this.setSuccess(false);
                        boolean bl = false;
                        logger.info("Exiting execute:{}", (Object)this.name);
                        return bl;
                    }
                    this.testStepVariables.put((String)entry.getKey(), String.valueOf(value));
                }
            }
            if (assertionExpression != null) {
                Object stepResult;
                try {
                    stepResult = bsh.eval(assertionExpression);
                }
                catch (EvalError e) {
                    logger.error("Error while evaluating ASSERT: {} in step: {}", new Object[]{this.name, assertionExpression, e});
                    this.setSuccess(false);
                    boolean bl = false;
                    logger.info("Exiting execute:{}", (Object)this.name);
                    return bl;
                }
                if (stepResult instanceof Boolean) {
                    if (!((Boolean)stepResult).booleanValue()) {
                        logger.info("FAILURE: Teststep " + this.name + " for assertion " + assertionExpression);
                        logger.info("Test step variables are " + String.valueOf(testStepOutputVariables));
                        this.setSuccess(false);
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    logger.info("FAILURE: Assertion expression " + assertionExpression + " return non-boolean value " + String.valueOf(stepResult) + " of type " + String.valueOf(stepResult.getClass()));
                    this.setSuccess(false);
                    boolean bl = false;
                    return bl;
                }
            }
            this.setSuccess(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error("Error while executing step {}", (Object)this.name, (Object)e);
            this.setSuccess(false);
            boolean bl = false;
            return bl;
        }
        finally {
            logger.info("Exiting execute:{}", (Object)this.name);
        }
    }

    private Caller getCaller(String callerBeanId) {
        ApplicationContext ac = this.testSuite.getMainApplicationContext();
        return (Caller)ac.getBean(callerBeanId, Caller.class);
    }

    private CallerFactory getCallerFactory(String callerFactoryBeanId) {
        ApplicationContext ac = this.testSuite.getMainApplicationContext();
        return (CallerFactory)ac.getBean(callerFactoryBeanId, CallerFactory.class);
    }
}

