/*
 * Decompiled with CFR 0.152.
 */
package org.simple4j.wsfeeler.pojoashttp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.ConvertUtils;
import org.simple4j.wsfeeler.pojoashttp.MethodParameterJSON;
import org.simple4j.wsfeeler.pojoashttp.RequestJSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import spark.Spark;

public class HTTPExposer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).serializationInclusion(JsonInclude.Include.NON_NULL)).build();
    private ApplicationContext context;
    private int listenerPortNumber = -1;
    private int listenerThreadMax = 100;
    private int listenerThreadMin = 1;
    private int listenerIdleTimeoutMillis = 60000;
    private String urlBase = "/pojoashttp";

    public HTTPExposer(ApplicationContext context) {
        this.context = context;
    }

    public void expose() {
        if (this.listenerPortNumber > 0) {
            Spark.port((int)this.listenerPortNumber);
            Spark.threadPool((int)this.listenerThreadMax, (int)this.listenerThreadMin, (int)this.listenerIdleTimeoutMillis);
        }
        Spark.post((String)(this.getUrlBase() + "/request.json"), (request, response) -> {
            String body = request.body();
            RequestJSON requestJSON = null;
            try {
                requestJSON = (RequestJSON)this.OBJECT_MAPPER.readValue(body, RequestJSON.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing request body <" + body + ">", e);
            }
            LOGGER.info("parsed JSON");
            Object bean = this.context.getBean(requestJSON.getBeanId());
            LOGGER.info("got bean from Spring {}", bean);
            Class[] parameterTypes = null;
            Object[] parameterValues = null;
            MethodParameterJSON[] methodParameters = requestJSON.getMethodParameters();
            LOGGER.info("got method parameter");
            if (methodParameters != null && methodParameters.length > 0) {
                LOGGER.info("method parameter not null");
                parameterTypes = new Class[methodParameters.length];
                parameterValues = new Object[methodParameters.length];
                for (int i = 0; i < methodParameters.length; ++i) {
                    LOGGER.info("creating instance for param:{}", (Object)methodParameters[i].getClassName());
                    LOGGER.info(":{}", (Object)methodParameters[i].getValue());
                    LOGGER.info(":{}", (Object[])methodParameters[i].getValues());
                    if (methodParameters[i].getClassName().endsWith(".TYPE")) {
                        Class<?> primitiveType = Class.forName(methodParameters[i].getClassName().replaceFirst("(\\.TYPE)$", ""));
                        parameterTypes[i] = (Class)primitiveType.getField("TYPE").get(null);
                    } else {
                        parameterTypes[i] = Class.forName(methodParameters[i].getClassName());
                    }
                    LOGGER.info("loaded param type {}", (Object)parameterTypes[i]);
                    if (methodParameters[i].getValue() != null) {
                        if (parameterTypes[i].equals(methodParameters[i].getValue().getClass())) {
                            LOGGER.info("parametertypes same as value type");
                            parameterValues[i] = methodParameters[i].getValue();
                            continue;
                        }
                        LOGGER.info("converting parametertype");
                        parameterValues[i] = ConvertUtils.convert((String)methodParameters[i].getValue(), (Class)parameterTypes[i]);
                        LOGGER.info("converting parametertype");
                        continue;
                    }
                    if (methodParameters[i].getValues() != null) {
                        parameterValues[i] = ConvertUtils.convert((String[])methodParameters[i].getValues(), (Class)parameterTypes[i]);
                        parameterTypes[i] = parameterValues[i].getClass();
                        continue;
                    }
                    String parameterStringJSON = this.OBJECT_MAPPER.writeValueAsString((Object)methodParameters[i].getValueJSON());
                    parameterValues[i] = this.OBJECT_MAPPER.readValue(parameterStringJSON, parameterTypes[i]);
                }
            }
            LOGGER.info("getting method instance");
            Method method = bean.getClass().getMethod(requestJSON.getMethodName(), parameterTypes);
            LOGGER.info("got it:{}", (Object)method);
            Object responseObj = method.invoke(bean, parameterValues);
            LOGGER.info("invoked it:{}", responseObj);
            String ret = this.OBJECT_MAPPER.writeValueAsString(responseObj);
            return "{\"returnValue\":" + ret + "}";
        });
    }

    public int getListenerPortNumber() {
        return this.listenerPortNumber;
    }

    public void setListenerPortNumber(int listenerPortNumber) {
        this.listenerPortNumber = listenerPortNumber;
    }

    public int getListenerThreadMax() {
        return this.listenerThreadMax;
    }

    public void setListenerThreadMax(int listenerThreadMax) {
        this.listenerThreadMax = listenerThreadMax;
    }

    public int getListenerThreadMin() {
        return this.listenerThreadMin;
    }

    public void setListenerThreadMin(int listenerThreadMin) {
        this.listenerThreadMin = listenerThreadMin;
    }

    public int getListenerIdleTimeoutMillis() {
        return this.listenerIdleTimeoutMillis;
    }

    public void setListenerIdleTimeoutMillis(int listenerIdleTimeoutMillis) {
        this.listenerIdleTimeoutMillis = listenerIdleTimeoutMillis;
    }

    public String getUrlBase() {
        return this.urlBase;
    }

    public void setUrlBase(String urlBase) {
        this.urlBase = urlBase;
    }
}

