/*
 * Decompiled with CFR 0.152.
 */
package org.simple4j.wsfeeler.core;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.simple4j.wsfeeler.model.TestCase;
import org.simple4j.wsfeeler.model.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCaseExecutor {
    private static Logger logger = LoggerFactory.getLogger(TestCaseExecutor.class);
    private ExecutorService testCasesExecutorService = null;
    private TestCase parent = null;

    public TestCaseExecutor(TestCase parent) {
        this.parent = parent;
    }

    private ExecutorService getTestCasesExecutorService(int threadPoolSize) {
        if (this.testCasesExecutorService == null) {
            this.testCasesExecutorService = Executors.newFixedThreadPool(threadPoolSize);
        }
        return this.testCasesExecutorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TestCase> execute(File parentTestCasesDir, TestSuite testSuite) {
        logger.info("Entering execute {}", (Object)parentTestCasesDir);
        if (!parentTestCasesDir.exists() || !parentTestCasesDir.isDirectory()) {
            throw new RuntimeException("Path does not exist or is not a directory:" + String.valueOf(parentTestCasesDir));
        }
        try {
            File[] testCaseDirs = parentTestCasesDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && pathname.exists();
                }
            });
            List<File> testCaseDirsList = Arrays.asList(testCaseDirs);
            List<TestCase> list = this.execute(testCaseDirsList, testSuite);
            return list;
        }
        finally {
            logger.info("Exiting execute {}", (Object)parentTestCasesDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TestCase> execute(List<File> testCaseDirectories, TestSuite testSuite) {
        logger.info("Entering execute {}", testCaseDirectories);
        try {
            int i;
            ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(testCaseDirectories.size());
            ArrayList<TestCase> testCases = new ArrayList<TestCase>(testCaseDirectories.size());
            for (i = 0; i < testCaseDirectories.size(); ++i) {
                logger.info("Submitting :" + String.valueOf(testCaseDirectories.get(i)));
                if (!testCaseDirectories.get(i).isDirectory()) continue;
                TestCase tc = new TestCase(testCaseDirectories.get(i), testSuite, this.parent);
                Future<Boolean> future = this.getTestCasesExecutorService(testSuite.getTestCaseExecutorThreadPoolSize()).submit(tc);
                testCases.add(tc);
                futures.add(future);
            }
            for (i = 0; i < testCaseDirectories.size(); ++i) {
                logger.info("waiting :" + String.valueOf(testCaseDirectories.get(i)));
                try {
                    ((Future)futures.get(i)).get();
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            ArrayList<TestCase> arrayList = testCases;
            return arrayList;
        }
        finally {
            logger.info("Exiting execute {}", testCaseDirectories);
        }
    }
}

