/*
 * Decompiled with CFR 0.152.
 */
package org.simple4j.wsfeeler.model;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.File;
import java.util.Map;
import org.simple4j.wsfeeler.model.TestCase;
import org.simple4j.wsfeeler.model.TestStep;
import org.simple4j.wsfeeler.model.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanShellStep
extends TestStep {
    private static Logger logger = LoggerFactory.getLogger(BeanShellStep.class);

    public BeanShellStep(Map<String, Object> testStepInputVariables, File testStepInputFile, TestCase parent, TestSuite testSuite) {
        super(testStepInputVariables, testStepInputFile, parent, testSuite);
    }

    @Override
    public boolean execute() {
        block11: {
            logger.info("Entering execute:{}", (Object)this.name);
            try {
                Object assertionExpressionnObj = this.testStepVariables.get("ASSERT");
                if (assertionExpressionnObj == null) break block11;
                String assertionExpression = (String)assertionExpressionnObj;
                Interpreter bsh = new Interpreter();
                bsh.setOut(System.out);
                bsh.setErr(System.err);
                bsh.set("testApplicationContext", (Object)this.testSuite.getTestApplicationContext());
                logger.info("Setting step variables");
                for (Map.Entry entry : this.testStepVariables.entrySet()) {
                    try {
                        logger.debug("Setting {} : {}", entry.getKey(), entry.getValue());
                        bsh.set((String)entry.getKey(), entry.getValue());
                    }
                    catch (EvalError e) {
                        logger.error("Error while setting variable for BeanShell step: {} key: {} vaue: {}", new Object[]{this.name, entry.getKey(), entry.getValue(), e});
                    }
                }
                Object result = bsh.eval(assertionExpression);
                logger.info("result={}", result);
                if (result instanceof Boolean) {
                    if (!((Boolean)result).booleanValue()) {
                        logger.info("FAILURE: Teststep " + this.name + " for assertion " + assertionExpression);
                        this.setSuccess(false);
                        boolean bl = false;
                        return bl;
                    }
                    break block11;
                }
                logger.info("FAILURE: Assertion expression " + assertionExpression + " return non-boolean value " + String.valueOf(result) + " of type " + String.valueOf(result.getClass()));
                this.setSuccess(false);
                boolean bl = false;
                return bl;
            }
            catch (EvalError e) {
                throw new RuntimeException(e);
            }
            finally {
                logger.info("Exiting execute:{}", (Object)this.name);
            }
        }
        this.setSuccess(true);
        return true;
    }
}

