/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.dkimsupport;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.markenwerk.utils.mail.dkim.Canonicalization;
import net.markenwerk.utils.mail.dkim.DkimMessage;
import net.markenwerk.utils.mail.dkim.DkimSigner;
import net.markenwerk.utils.mail.dkim.SigningAlgorithm;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.internal.dkimsupport.DKIMSigningException;
import org.simplejavamail.internal.modules.DKIMModule;
import org.simplejavamail.internal.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DKIMSigner
implements DKIMModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(DKIMSigner.class);

    public MimeMessage signMessageWithDKIM(MimeMessage messageToSign, Email signingDetails) {
        LOGGER.debug("signing MimeMessage with DKIM...");
        try {
            String dkimSelector = (String)Preconditions.checkNonEmptyArgument((Object)signingDetails.getDkimSelector(), (String)"dkimSelector");
            DkimSigner dkimSigner = signingDetails.getDkimPrivateKeyFile() != null ? new DkimSigner(signingDetails.getDkimSigningDomain(), dkimSelector, signingDetails.getDkimPrivateKeyFile()) : new DkimSigner(signingDetails.getDkimSigningDomain(), dkimSelector, signingDetails.getDkimPrivateKeyInputStream());
            dkimSigner.setIdentity(((Recipient)Preconditions.checkNonEmptyArgument((Object)signingDetails.getFromRecipient(), (String)"fromRecipient")).getAddress());
            dkimSigner.setHeaderCanonicalization(Canonicalization.RELAXED);
            dkimSigner.setBodyCanonicalization(Canonicalization.RELAXED);
            dkimSigner.setSigningAlgorithm(SigningAlgorithm.SHA256_WITH_RSA);
            dkimSigner.setLengthParam(true);
            dkimSigner.setZParam(false);
            return new DkimMessage(messageToSign, dkimSigner);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException | MessagingException e) {
            throw new DKIMSigningException("Error signing MimeMessage with DKIM", (Exception)e);
        }
    }
}

