/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.smtpconnectionpool;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import org.bbottema.genericobjectpool.Allocator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransportAllocator
extends Allocator<Transport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportAllocator.class);
    @NotNull
    private final Session session;

    TransportAllocator(@NotNull Session session) {
        if (session == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/smtpconnectionpool/TransportAllocator.<init> must not be null");
        }
        this.session = session;
    }

    @NotNull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="generated code by se.eris Maven plugin")
    public Transport allocate() {
        Transport transport;
        LOGGER.trace("opening transport connection...");
        try {
            Transport transport2 = this.session.getTransport();
            transport2.connect();
            transport = transport2;
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("unable to get transport from session:\n\t" + this.session, e);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Error when trying to open connection to the server, session:\n\t" + this.session, e);
        }
        if (transport == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/smtpconnectionpool/TransportAllocator.allocate must not return null");
        }
        return transport;
    }

    public void deallocate(Transport transport) {
        if (transport == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/smtpconnectionpool/TransportAllocator.deallocate must not be null");
        }
        LOGGER.trace("closing transport...");
        try {
            transport.close();
        }
        catch (MessagingException e) {
            throw new RuntimeException("error closing transport connection", e);
        }
    }
}

