/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.smtpconnectionpool;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.mail.MessagingException;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import org.bbottema.genericobjectpool.Allocator;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.smtpconnectionpool.TransportHandlingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransportAllocator
extends Allocator<Transport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportAllocator.class);
    @NotNull
    private final Session session;

    TransportAllocator(@NotNull Session session) {
        this.session = session;
    }

    @NotNull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="generated code by se.eris Maven plugin")
    public Transport allocate() {
        LOGGER.trace("opening transport connection...");
        try {
            Transport transport = this.session.getTransport();
            transport.connect();
            return transport;
        }
        catch (NoSuchProviderException e) {
            throw new TransportHandlingException("unable to get transport from session:\n\t" + this.session.getProperties(), e);
        }
        catch (MessagingException e) {
            throw new TransportHandlingException("Error when trying to open connection to the server, session:\n\t" + this.session.getProperties(), e);
        }
    }

    public void deallocate(Transport transport) {
        LOGGER.trace("closing transport...");
        try {
            transport.close();
        }
        catch (MessagingException e) {
            throw new TransportHandlingException("error closing transport connection", e);
        }
    }
}

