/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.dtokenize.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sindaryn.dtokenize.model.Token;

/*
 * Exception performing whole class analysis ignored.
 */
public class Detokenizer {
    private boolean isInBetweenDoubleQuotes = false;
    private List<Token> expectedTokens = new ArrayList();

    private Detokenizer() {
    }

    public Map<String, String> parse(String tokenStream) {
        HashMap<String, String> mappedResults = new HashMap<String, String>();
        Stack squareBrackets = new Stack();
        char[] chars = tokenStream.toCharArray();
        StringBuilder currentTokenValue = new StringBuilder();
        int tokenIndex = 0;
        for (int lineIndex = 0; lineIndex < chars.length; ++lineIndex) {
            this.handleAnyBracketsOrQuotes(chars, lineIndex, squareBrackets);
            if (this.isEndOfToken(chars, lineIndex, currentTokenValue, tokenIndex, squareBrackets)) {
                this.assignTokenValueIfNonStatic(tokenIndex, currentTokenValue, mappedResults);
                ++tokenIndex;
                currentTokenValue = new StringBuilder();
            }
            if (!this.isMeaningfulCharacter(chars, lineIndex, squareBrackets)) continue;
            currentTokenValue.append(chars[lineIndex]);
        }
        return mappedResults;
    }

    private boolean isMeaningfulCharacter(char[] chars, int lineIndex, Stack<Character> squareBrackets) {
        return chars[lineIndex] != ' ' || this.isInBetweenBracketsOrQuotes(squareBrackets);
    }

    private void handleAnyBracketsOrQuotes(char[] chars, int lineIndex, Stack<Character> squareBrackets) {
        char c = chars[lineIndex];
        if (c == '[') {
            squareBrackets.push(Character.valueOf('['));
        } else if (c == '\"') {
            this.isInBetweenDoubleQuotes = !this.isInBetweenDoubleQuotes;
        } else if (c == ']' && !squareBrackets.empty()) {
            squareBrackets.pop();
        }
    }

    private boolean isInBetweenBracketsOrQuotes(Stack<Character> brackets) {
        return !brackets.empty() || this.isInBetweenDoubleQuotes;
    }

    private boolean isEndOfToken(char[] chars, int lineIndex, StringBuilder currentTokenValue, int tokenIndex, Stack<Character> squareBrackets) {
        boolean currentTokenValueInProgress;
        boolean bl = currentTokenValueInProgress = !currentTokenValue.toString().equals("");
        if (lineIndex + 1 == chars.length) {
            return true;
        }
        if (chars[lineIndex] == ' ' && !this.isInBetweenBracketsOrQuotes(squareBrackets)) {
            return currentTokenValueInProgress;
        }
        if (this.isClosingBracketOrDoubleQuote(chars[lineIndex], squareBrackets)) {
            return true;
        }
        return this.matchesStaticExpression(tokenIndex, currentTokenValue);
    }

    private boolean isClosingBracketOrDoubleQuote(char c, Stack<Character> squareBrackets) {
        return c == ']' && squareBrackets.empty() || String.valueOf(c).equals("\"") && !this.isInBetweenDoubleQuotes;
    }

    private void assignTokenValueIfNonStatic(int tokenIndex, StringBuilder currentTokenValue, Map<String, String> resultsMap) {
        String value = currentTokenValue.toString();
        Token expectedToken = (Token)this.expectedTokens.get(tokenIndex);
        if (!expectedToken.getIsStaticExpression().booleanValue()) {
            expectedToken.setMappedValue(resultsMap, value);
        }
    }

    private boolean matchesStaticExpression(int tokenIndex, StringBuilder value) {
        return ((Token)this.expectedTokens.get(tokenIndex)).getIsStaticExpression() != false && ((Token)this.expectedTokens.get(tokenIndex)).getExpression().equals(value.toString());
    }

    private static Token parseRawToken(String currentTokenTemplate) {
        Token token = new Token();
        token.setIsStaticExpression(Boolean.valueOf(Detokenizer.determineTokenType((String)currentTokenTemplate)));
        currentTokenTemplate = currentTokenTemplate.substring(1);
        token.setExpression(currentTokenTemplate);
        return token;
    }

    public static Detokenizer of(String template) {
        Detokenizer instance = new Detokenizer();
        char[] charArray = template.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c != '$' && c != '^') continue;
            instance.expectedTokens.add(Detokenizer.parseRawToken((String)template.substring(i, Detokenizer.endOfToken((int)i, (String)template))));
        }
        return instance;
    }

    private static int endOfToken(int i, String logFormat) {
        Pattern p = Pattern.compile("[\\s+$^]");
        Matcher m = p.matcher(logFormat.substring(i + 1));
        if (m.find()) {
            return i + m.start() + 1;
        }
        return logFormat.length();
    }

    private static boolean determineTokenType(String s) {
        if (s.startsWith("$")) {
            return false;
        }
        if (s.startsWith("^")) {
            return true;
        }
        throw new IllegalArgumentException("Invalid log-file format: " + s);
    }
}

