/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.mockeri.generator;

import com.maximeroussy.invitrode.WordGenerator;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.RandomStringUtils;
import org.sindaryn.mockeri.StaticUtils;
import org.sindaryn.mockeri.meta.CollectionInstantiator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class TestDataGenerator {
    private List<String> firstNames = new ArrayList<String>();
    private List<String> lastNames = new ArrayList<String>();
    private List<String> companies = new ArrayList<String>();
    private List<String> addresses = new ArrayList<String>();
    private List<String> cities = new ArrayList<String>();
    private List<String> stateOrProvinces = new ArrayList<String>();
    private List<String> countries = new ArrayList<String>();
    private List<String> zipCodes = new ArrayList<String>();
    private List<String> phone1s = new ArrayList<String>();
    private List<String> phone2s = new ArrayList<String>();
    private List<String> emails = new ArrayList<String>();
    private List<String> websites = new ArrayList<String>();
    private List<String> paymentTypes = new ArrayList<String>(Arrays.asList("Credit card", "Cash", "ACH"));
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private CollectionInstantiator collectionInstantiator;

    public LocalDate pastDate() {
        LocalDate start = LocalDate.of(1970, Month.JANUARY, 1);
        long days = ChronoUnit.DAYS.between(start, LocalDate.now());
        return start.plusDays(new Random().nextInt((int)days + 1));
    }

    public LocalDate futureDate() {
        LocalDate start = LocalDate.now();
        long days = ChronoUnit.DAYS.between(start, LocalDateTime.from(LocalDate.of(2026, Month.JANUARY, 1)));
        return start.plusDays(new Random().nextInt((int)days + 1));
    }

    public String dummyParagraph() {
        StringBuilder dummyParagraph = new StringBuilder();
        WordGenerator wordGenerator = new WordGenerator();
        for (int i = 0; i < ThreadLocalRandom.current().nextInt(20, 30); ++i) {
            int lengthOfWord = ThreadLocalRandom.current().nextInt(3, 10);
            dummyParagraph.append(wordGenerator.newWord(lengthOfWord).toLowerCase()).append(" ");
        }
        return dummyParagraph.toString();
    }

    public String dummySentence() {
        StringBuilder dummySentence = new StringBuilder();
        WordGenerator wordGenerator = new WordGenerator();
        for (int i = 0; i < ThreadLocalRandom.current().nextInt(7, 20); ++i) {
            int lengthOfWord = ThreadLocalRandom.current().nextInt(3, 10);
            dummySentence.append(wordGenerator.newWord(lengthOfWord).toLowerCase()).append(" ");
        }
        return dummySentence.toString();
    }

    public String password() {
        return StaticUtils.randomString(16);
    }

    public Double aDouble(double min, double max) {
        return min + (max - min) * new Random().nextDouble();
    }

    public boolean aBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    private void parseStaticData() {
        BufferedReader br = null;
        String line = "";
        try {
            br = StaticUtils.getBufferedReaderFor("testDataSource.csv", this.resourceLoader);
            br.readLine();
            while ((line = br.readLine()) != null) {
                String[] currentLineData = line.split(",");
                this.removeDoubleQuotes(currentLineData);
                this.firstNames.add(currentLineData[0]);
                this.lastNames.add(currentLineData[1]);
                this.addresses.add(currentLineData[3]);
                this.cities.add(currentLineData[4]);
                this.stateOrProvinces.add(currentLineData[6]);
                this.zipCodes.add(currentLineData[7]);
                this.phone1s.add(currentLineData[8]);
                this.phone2s.add(currentLineData[9]);
                this.emails.add(currentLineData[10]);
                String websiteUrl = currentLineData[11];
                if (websiteUrl.contains("@")) continue;
                this.websites.add(websiteUrl);
            }
            br = StaticUtils.getBufferedReaderFor("countries.txt", this.resourceLoader);
            line = "";
            while ((line = br.readLine()) != null) {
                this.countries.add(line);
            }
            br = StaticUtils.getBufferedReaderFor("companyNames.txt", this.resourceLoader);
            line = "";
            while ((line = br.readLine()) != null) {
                this.companies.add(line);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        int i = 9;
    }

    private void removeDoubleQuotes(String[] currentLineData) {
        for (int i = 0; i < currentLineData.length; ++i) {
            currentLineData[i] = currentLineData[i].replaceAll("\"", "");
        }
    }

    public static <T> T randomFrom(List<T> aList) {
        return aList.get(ThreadLocalRandom.current().nextInt(aList.size()));
    }

    public static <T> Collection<T> randomCollectionFrom(List<T> aList) {
        int resultSetSize = ThreadLocalRandom.current().nextInt(aList.size());
        HashSet<T> resultSet = new HashSet<T>();
        for (int i = 0; i < resultSetSize; ++i) {
            T toAdd = TestDataGenerator.randomFrom(aList);
            if (resultSet.contains(toAdd)) continue;
            resultSet.add(toAdd);
        }
        return resultSet;
    }

    public Integer anInteger(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max);
    }

    public Long aLong(long min, long max) {
        return ThreadLocalRandom.current().nextLong(min, max);
    }

    public LocalDateTime aLocalDateTime() {
        LocalDateTime now = LocalDateTime.now();
        int year = 31536000;
        int numYears = ThreadLocalRandom.current().nextInt(-10, 15);
        return now.plusSeconds((long)numYears * (long)year);
    }

    private LocalDate aLocalDate(LocalDate start, LocalDate end) {
        long days = ChronoUnit.DAYS.between(start, end);
        return start.plusDays(ThreadLocalRandom.current().nextInt((int)days + 1));
    }

    public LocalDate aLocalDate() {
        return this.aLocalDate(LocalDate.now().minusYears(20L), LocalDate.now().plusYears(20L));
    }

    public LocalDate aFutureLocalDate() {
        return this.aLocalDate(LocalDate.now(), LocalDate.now().plusYears(20L));
    }

    public LocalDate aPastLocalDate() {
        return this.aLocalDate(LocalDate.now(), LocalDate.now().minusYears(20L));
    }

    public String generateSecurePassword() {
        String upperCaseLetters = RandomStringUtils.random((int)2, (int)65, (int)90, (boolean)true, (boolean)true);
        String lowerCaseLetters = RandomStringUtils.random((int)2, (int)97, (int)122, (boolean)true, (boolean)true);
        String numbers = RandomStringUtils.randomNumeric((int)2);
        String specialChar = RandomStringUtils.random((int)2, (int)33, (int)47, (boolean)false, (boolean)false);
        String totalChars = RandomStringUtils.randomAlphanumeric((int)2);
        String combinedChars = upperCaseLetters.concat(lowerCaseLetters).concat(numbers).concat(specialChar).concat(totalChars);
        List pwdChars = combinedChars.chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toList());
        Collections.shuffle(pwdChars);
        return pwdChars.stream().collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
    }

    public double aDouble() {
        return new Random().nextDouble();
    }

    public Collection<String> collectionOfStrings(Class<?> collectionType) {
        Collection collection = this.collectionInstantiator.instantiateCollection(collectionType, String.class);
        for (int i = 0; i < 20; ++i) {
            collection.add(this.dummySentence());
        }
        return collection;
    }

    public Collection<Double> collectionOfDoubles(Class<?> collectionType) {
        Collection collection = this.collectionInstantiator.instantiateCollection(collectionType, Double.class);
        for (int i = 0; i < 20; ++i) {
            collection.add(this.aDouble());
        }
        return collection;
    }

    public Collection<Long> collectionOfLongs(Class<?> collectionType) {
        Collection collection = this.collectionInstantiator.instantiateCollection(collectionType, Long.class);
        for (int i = 0; i < 20; ++i) {
            collection.add(ThreadLocalRandom.current().nextLong());
        }
        return collection;
    }

    public Collection<Integer> collectionOfIntegers(Class<?> collectionType) {
        Collection collection = this.collectionInstantiator.instantiateCollection(collectionType, Integer.class);
        for (int i = 0; i < 20; ++i) {
            collection.add(ThreadLocalRandom.current().nextInt());
        }
        return collection;
    }

    public Collection<Boolean> collectionOfBooleans(Class<?> collectionType) {
        Collection collection = this.collectionInstantiator.instantiateCollection(collectionType, Boolean.class);
        for (int i = 0; i < 20; ++i) {
            collection.add(ThreadLocalRandom.current().nextBoolean());
        }
        return collection;
    }

    public Collection<LocalDateTime> collectionOfLocalDateTimes(Class<?> collectionType) {
        Collection collection = this.collectionInstantiator.instantiateCollection(collectionType, LocalDateTime.class);
        for (int i = 0; i < 20; ++i) {
            collection.add(this.aLocalDateTime());
        }
        return collection;
    }

    public Collection<LocalDate> collectionOfLocalDates(Class<?> collectionType) {
        Collection collection = this.collectionInstantiator.instantiateCollection(collectionType, LocalDate.class);
        for (int i = 0; i < 20; ++i) {
            collection.add(this.aLocalDate());
        }
        return collection;
    }

    public Collection<String> collectionOfUrls(Class<?> collectionType) {
        Collection collection = this.collectionInstantiator.instantiateCollection(collectionType, String.class);
        for (int i = 0; i < 20; ++i) {
            collection.add(TestDataGenerator.randomFrom(this.websites));
        }
        return collection;
    }

    public List<String> getFirstNames() {
        return this.firstNames;
    }

    public List<String> getLastNames() {
        return this.lastNames;
    }

    public List<String> getCompanies() {
        return this.companies;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public List<String> getCities() {
        return this.cities;
    }

    public List<String> getStateOrProvinces() {
        return this.stateOrProvinces;
    }

    public List<String> getCountries() {
        return this.countries;
    }

    public List<String> getZipCodes() {
        return this.zipCodes;
    }

    public List<String> getPhone1s() {
        return this.phone1s;
    }

    public List<String> getPhone2s() {
        return this.phone2s;
    }

    public List<String> getEmails() {
        return this.emails;
    }

    public List<String> getWebsites() {
        return this.websites;
    }

    public List<String> getPaymentTypes() {
        return this.paymentTypes;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public CollectionInstantiator getCollectionInstantiator() {
        return this.collectionInstantiator;
    }
}

