/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.testifi;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.tools.Diagnostic;
import org.sindaryn.apifi.annotations.GraphQLApiEntity;
import org.sindaryn.datafi.reflection.CachedEntityType;
import org.sindaryn.datafi.reflection.ReflectionCache;
import org.sindaryn.datafi.service.BaseDataManager;
import org.sindaryn.mockeri.generator.EntityMocker;
import org.sindaryn.mockeri.generator.TestDataGenerator;

public abstract class StaticUtils {
    private static Map<String, Field> fieldNamesCache = new HashMap<String, Field>();

    public static String pluralPascalCaseName(Element entity) {
        return org.sindaryn.datafi.StaticUtils.toPlural((String)org.sindaryn.datafi.StaticUtils.toPascalCase((String)entity.getSimpleName().toString()));
    }

    public static String pluralCamelCaseName(Class<?> clazz) {
        return org.sindaryn.datafi.StaticUtils.toPlural((String)org.sindaryn.datafi.StaticUtils.toPascalCase((String)clazz.getSimpleName()));
    }

    public static <T> T randomInstance(Class<?> clazz, BaseDataManager<T> dataManager) {
        return (T)TestDataGenerator.randomFrom((List)dataManager.findAll(clazz));
    }

    public static void setField(Object entity, Object value, String fieldName) {
        try {
            fieldName = org.sindaryn.datafi.StaticUtils.toCamelCase((String)fieldName);
            for (Field field : ReflectionCache.getClassFields(entity.getClass())) {
                field.setAccessible(true);
                if (!field.getName().equals(fieldName)) continue;
                try {
                    field.setAccessible(true);
                    field.set(entity, value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                return;
            }
            throw new RuntimeException("cannot find field '" + fieldName + "' in " + entity.getClass().getSimpleName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setCollectionField(Object entity, Collection value, String fieldName, EntityMocker entityMocker) {
        Class<?> collectableType = value.iterator().next().getClass();
        Class<? extends Collection> collectionType = StaticUtils.collectionType(entity.getClass(), fieldName, collectableType);
        Collection collectionOfCorrectType = entityMocker.getCollectionInstantiator().instantiateCollection(collectionType, collectableType);
        collectionOfCorrectType.addAll(value);
        StaticUtils.setField(entity, collectionOfCorrectType, fieldName);
    }

    public static Class<? extends Collection> collectionType(Class<?> hasTsClazz, String fieldName, Class<?> tClazz) {
        Field field = null;
        String key = hasTsClazz.getSimpleName() + "_" + fieldName;
        if (fieldNamesCache.get(key) != null) {
            field = fieldNamesCache.get(key);
        } else {
            for (Field aField : ReflectionCache.getClassFields(hasTsClazz)) {
                if (!aField.getName().equals(fieldName)) continue;
                field = aField;
                break;
            }
            if (field == null) {
                throw new RuntimeException("field by name of " + fieldName + " not found in entity " + hasTsClazz.getSimpleName());
            }
        }
        fieldNamesCache.put(key, field);
        return field.getType();
    }

    public static <T> int totalCount(Class<?> clazz, BaseDataManager<T> dataManager) {
        return Math.toIntExact(dataManager.count(clazz));
    }

    public static int randomCount(Class<?> clazz, BaseDataManager dataManager) {
        return ThreadLocalRandom.current().nextInt(1, StaticUtils.totalCount(clazz, dataManager));
    }

    public static <T> List<T> firstRandomN(Class<?> clazz, BaseDataManager<T> dataManager) {
        return dataManager.findAll(clazz).stream().limit(StaticUtils.randomCount(clazz, dataManager)).collect(Collectors.toList());
    }

    public static <T, HasTs> Collection<T> firstRandomEmbeddedN(HasTs owner, String fieldName, ReflectionCache reflectionCache) {
        Collection collection = (Collection)((CachedEntityType)reflectionCache.getEntitiesCache().get(owner.getClass().getSimpleName())).invokeGetter(owner, fieldName);
        long limit = ThreadLocalRandom.current().nextLong(1L, collection.size());
        return collection.stream().limit(limit).collect(Collectors.toList());
    }

    public static <T> List<T> persistCollectionOf(Class<?> tClazz, EntityMocker entityMocker) {
        ArrayList<Object> toAdd = new ArrayList<Object>();
        int amount = ThreadLocalRandom.current().nextInt(5, 10);
        for (int i = 0; i < amount; ++i) {
            toAdd.add(entityMocker.instantiateEntity(tClazz));
        }
        return toAdd;
    }

    public static <T> List<T> transientlyInstantiateCollectionOf(Class<?> tClazz, EntityMocker entityMocker) {
        ArrayList<Object> toAdd = new ArrayList<Object>();
        int amount = ThreadLocalRandom.current().nextInt(5, 10);
        for (int i = 0; i < amount; ++i) {
            toAdd.add(entityMocker.instantiateTransientEntity(tClazz));
        }
        return toAdd;
    }

    public static Set<? extends TypeElement> getGraphQLApiEntities(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        HashSet<? extends Element> entities = new HashSet<Element>();
        for (TypeElement typeElement : annotations) {
            if (!typeElement.getQualifiedName().toString().equals(GraphQLApiEntity.class.getCanonicalName())) continue;
            entities.addAll(roundEnvironment.getElementsAnnotatedWith(typeElement));
        }
        return Sets.newHashSet(entities);
    }

    public static String collectionTypeString(VariableElement embedded) {
        String typeNameString = embedded.asType().toString();
        typeNameString = typeNameString.replaceAll("^.+<", "");
        typeNameString = typeNameString.replaceAll(">", "");
        int lastDot = typeNameString.lastIndexOf(46);
        String packageName = typeNameString.substring(0, lastDot);
        String simpleClassName = typeNameString.substring(lastDot + 1);
        return simpleClassName;
    }

    public static void checkForUniquenessConstraints(TypeElement entity, String resolverName, String[] args, ProcessingEnvironment processingEnvironment) {
        ArrayList<String> uniqueArgTypes = new ArrayList<String>();
        Map<String, VariableElement> fieldsMap = StaticUtils.getFieldsOfTypeElement(entity);
        for (String arg : args) {
            VariableElement correspondingField = fieldsMap.get(arg);
            Column columnAnnotation = correspondingField.getAnnotation(Column.class);
            Id idAnnotation = correspondingField.getAnnotation(Id.class);
            EmbeddedId embeddedIdAnnotation = correspondingField.getAnnotation(EmbeddedId.class);
            if ((columnAnnotation == null || !columnAnnotation.unique()) && idAnnotation == null && embeddedIdAnnotation == null) continue;
            uniqueArgTypes.add(arg);
        }
        if (!uniqueArgTypes.isEmpty()) {
            processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error generating test for custom resolver \"" + resolverName + "\": The arguments " + ((Object)uniqueArgTypes).toString() + " are bound by uniqueness constraints, whereas the return type is java.util.List");
        }
    }

    public static Map<String, VariableElement> getFieldsOfTypeElement(TypeElement entity) {
        return entity.getEnclosedElements().stream().filter(element -> element.getKind().isField()).collect(Collectors.toMap(field -> field.getSimpleName().toString(), field -> field));
    }

    public static String entityMocker() {
        return "entityMocker";
    }

    public static <T> List<Object> fieldValues(String fieldName, List<T> collection, CachedEntityType entityType) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (T item : collection) {
            result.add(entityType.invokeGetter(item, fieldName));
        }
        return result;
    }

    public static <T> Map<Object, T> firstRandomNIdMap(Class<?> clazz, BaseDataManager<T> dataManager, ReflectionCache reflectionCache) {
        return StaticUtils.firstRandomN(clazz, dataManager).stream().collect(Collectors.toMap(instance -> org.sindaryn.datafi.StaticUtils.getId((Object)instance, (ReflectionCache)reflectionCache), instance -> instance));
    }
}

