/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.testifi.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.transaction.Transactional;
import lombok.NonNull;
import org.junit.runner.RunWith;
import org.sindaryn.apifi.annotations.GraphQLApiEntity;
import org.sindaryn.apifi.generator.EntitiesInfoCache;
import org.sindaryn.apifi.generator.FieldSpecs;
import org.sindaryn.datafi.annotations.GetAllBy;
import org.sindaryn.datafi.annotations.GetBy;
import org.sindaryn.datafi.annotations.GetByUnique;
import org.sindaryn.datafi.annotations.WithResolver;
import org.sindaryn.mockeri.generator.EntityMocker;
import org.sindaryn.testifi.StaticUtils;
import org.sindaryn.testifi.service.TestMethodSpecs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

public class GraphQLApiTestFactory {
    @NonNull
    private ProcessingEnvironment processingEnvironment;
    @NonNull
    private EntitiesInfoCache entitiesInfoCache;
    private FieldSpecs fieldSpecs;
    private TestMethodSpecs testMethodSpecs;
    private Map<TypeName, FieldSpec> additionalDataManagers;

    protected void generateGraphQLServiceTest(TypeElement entity) {
        this.fieldSpecs = new FieldSpecs(this.processingEnvironment, this.entitiesInfoCache);
        this.testMethodSpecs = new TestMethodSpecs(this.processingEnvironment);
        this.additionalDataManagers = new HashMap<TypeName, FieldSpec>();
        String className = entity.getQualifiedName().toString();
        int lastDot = className.lastIndexOf(46);
        String packageName = className.substring(0, lastDot);
        String simpleClassName = className.substring(lastDot + 1);
        String serviceName = simpleClassName + "GraphQLServiceTest";
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)serviceName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(RunWith.class).addMember("value", "$T.class", new Object[]{SpringRunner.class}).build()).addAnnotation(SpringBootTest.class).addAnnotation(Transactional.class);
        GraphQLApiEntity apiEntityAnnotation = entity.getAnnotation(GraphQLApiEntity.class);
        if (apiEntityAnnotation.exposeDirectly()) {
            builder.addMethod(this.testMethodSpecs.generateGetAllEndpointTest(entity)).addMethod(this.testMethodSpecs.generateGetByIdEndpointTest(entity)).addMethod(this.testMethodSpecs.generateGetCollectionByIdEndpointTest(entity));
            if (!apiEntityAnnotation.readOnly()) {
                builder.addMethod(this.testMethodSpecs.generateAddEndpointTest(entity)).addMethod(this.testMethodSpecs.generateUpdateEndpointTest(entity)).addMethod(this.testMethodSpecs.generateDeleteEndpointTest(entity)).addMethod(this.testMethodSpecs.generateAddCollectionEndpointTest(entity)).addMethod(this.testMethodSpecs.generateUpdateCollectionEndpointTest(entity)).addMethod(this.testMethodSpecs.generateDeleteCollectionEndpointTest(entity));
                if (org.sindaryn.apifi.StaticUtils.isArchivable((TypeElement)entity, (ProcessingEnvironment)this.processingEnvironment)) {
                    builder.addMethod(this.testMethodSpecs.generateArchiveEndpointTest(entity)).addMethod(this.testMethodSpecs.generateDeArchiveEndpointTest(entity)).addMethod(this.testMethodSpecs.generateArchiveCollectionEndpointTest(entity)).addMethod(this.testMethodSpecs.generateDeArchiveCollectionEndpointTest(entity));
                }
            }
        }
        builder.addField(this.fieldSpecs.metaOps(apiEntityAnnotation, entity)).addField(this.fieldSpecs.reflectionCache()).addField(this.fieldSpecs.dataManager(entity)).addField(FieldSpec.builder(EntityMocker.class, (String)StaticUtils.entityMocker(), (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Autowired.class).build());
        for (VariableElement field : org.sindaryn.apifi.StaticUtils.getFields((TypeElement)entity)) {
            if (!this.isForeignKeyOrKeys(field)) continue;
            this.addEmbeddedFieldResolvers(entity, field, builder);
        }
        this.addGetByAndGetAllByResolverTests(entity, builder);
        this.addCustomResolverTests(entity, builder);
        org.sindaryn.datafi.StaticUtils.writeToJavaFile((String)simpleClassName, (String)packageName, (TypeSpec.Builder)builder, (ProcessingEnvironment)this.processingEnvironment, (String)"GraphQL Api Test Class");
    }

    private void addCustomResolverTests(TypeElement entity, TypeSpec.Builder builder) {
        WithResolver[] resolvers = (WithResolver[])entity.getAnnotationsByType(WithResolver.class);
        if (resolvers == null || resolvers.length <= 0) {
            return;
        }
        for (WithResolver resolver : resolvers) {
            builder.addMethod(this.testMethodSpecs.generateCustomResolverEndpointTest(entity, resolver));
        }
    }

    private void addGetByAndGetAllByResolverTests(TypeElement entity, TypeSpec.Builder builder) {
        for (VariableElement field : org.sindaryn.apifi.StaticUtils.getFields((TypeElement)entity)) {
            if (field.getAnnotation(GetAllBy.class) != null) {
                builder.addMethod(this.testMethodSpecs.generateGetAllByEndpointTest(entity, field));
            }
            if (field.getAnnotation(GetBy.class) != null) {
                builder.addMethod(this.testMethodSpecs.generateGetByEndpointTest(entity, field));
                continue;
            }
            if (field.getAnnotation(GetByUnique.class) == null) continue;
            builder.addMethod(this.testMethodSpecs.generateGetByUniqueEndpointTest(entity, field));
        }
    }

    private boolean isForeignKeyOrKeys(VariableElement field) {
        return field.getAnnotation(OneToMany.class) != null || field.getAnnotation(ManyToOne.class) != null || field.getAnnotation(OneToOne.class) != null || field.getAnnotation(ManyToMany.class) != null;
    }

    private void addEmbeddedFieldResolvers(TypeElement entity, VariableElement field, TypeSpec.Builder builder) {
        if (field.getAnnotation(OneToMany.class) != null || field.getAnnotation(ManyToMany.class) != null) {
            builder.addMethod(this.testMethodSpecs.generateGetAsEmbeddedEntityCollectionTest(field, entity));
            if (this.additionalDataManagers.get(ClassName.get((TypeMirror)field.asType())) == null) {
                List<? extends TypeMirror> typeArgs = ((DeclaredType)field.asType()).getTypeArguments();
                this.addDataManager(field, builder, typeArgs);
            }
            if (this.entitiesInfoCache.isStrongEntity(field)) {
                builder.addMethod(this.testMethodSpecs.generateAttachExistingToEmbeddedCollectionTest(field, entity));
            } else {
                builder.addMethod(this.testMethodSpecs.generateAddNewToEmbeddedCollectionTest(field, entity));
            }
            builder.addMethod(this.testMethodSpecs.generateUpdateEmbeddedCollectionTest(field, entity));
            builder.addMethod(this.testMethodSpecs.generateRemoveFromEmbeddedCollectionTest(field, entity));
            builder.addField(this.fieldSpecs.embeddedCollectionMetaOps(field));
        } else {
            if (this.additionalDataManagers.get(ClassName.get((TypeMirror)field.asType())) == null) {
                this.addDataManager(field, builder, Collections.singletonList(field.asType()));
            }
            builder.addMethod(this.testMethodSpecs.generateGetAsEmbeddedEntityTest(field, entity));
        }
    }

    private void addDataManager(VariableElement field, TypeSpec.Builder builder, List<? extends TypeMirror> typeArgs) {
        FieldSpec additionalDataManager = this.fieldSpecs.dataManager(typeArgs.iterator().next(), field.getSimpleName().toString());
        builder.addField(additionalDataManager);
        this.additionalDataManagers.put(ClassName.get((TypeMirror)field.asType()), additionalDataManager);
    }

    public GraphQLApiTestFactory(@NonNull ProcessingEnvironment processingEnvironment, @NonNull EntitiesInfoCache entitiesInfoCache) {
        if (processingEnvironment == null) {
            throw new NullPointerException("processingEnvironment is marked non-null but is null");
        }
        if (entitiesInfoCache == null) {
            throw new NullPointerException("entitiesInfoCache is marked non-null but is null");
        }
        this.processingEnvironment = processingEnvironment;
        this.entitiesInfoCache = entitiesInfoCache;
    }
}

