/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.testifi.service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.persistence.Column;
import lombok.NonNull;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.sindaryn.datafi.annotations.NonCascadeUpdatable;
import org.sindaryn.datafi.annotations.NonCascadeUpdatables;
import org.sindaryn.datafi.reflection.ReflectionCache;

public class EquivalencyMatcher
extends TypeSafeMatcher<Object> {
    @NonNull
    private Object actual;

    protected boolean matchesSafely(Object expected) {
        try {
            if (expected == null && this.actual == null) {
                return true;
            }
            if (expected == null ^ this.actual == null) {
                return false;
            }
            if (Iterable.class.isAssignableFrom(expected.getClass())) {
                List<Object> expectedAsList = this.toSortedList(expected);
                List<Object> actualAsList = this.toSortedList(this.actual);
                if (expectedAsList.size() != actualAsList.size()) {
                    return false;
                }
                for (int i = 0; i < expectedAsList.size(); ++i) {
                    boolean embeddedCollectionsAreEquivalent = new EquivalencyMatcher(actualAsList.get(i)).matchesSafely(expectedAsList.get(i));
                    if (embeddedCollectionsAreEquivalent) continue;
                    return false;
                }
            } else if (expected.getClass().isPrimitive()) {
                if (!expected.equals(this.actual)) {
                    return false;
                }
            } else {
                for (Field field : ReflectionCache.getClassFields(expected.getClass())) {
                    field.setAccessible(true);
                    if (!this.isUpdatableField(field)) continue;
                    if (field.get(expected) == null && field.get(this.actual) == null) {
                        return true;
                    }
                    if (field.get(expected) == null ^ field.get(this.actual) == null) {
                        return false;
                    }
                    if (field.get(expected).equals(field.get(this.actual))) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private List<Object> toSortedList(Object collection) {
        ArrayList<Object> asList = new ArrayList<Object>((Collection)collection);
        asList.sort(Comparator.comparing(Object::toString));
        return asList;
    }

    private boolean isUpdatableField(Field field) {
        Class<?> parent = field.getDeclaringClass();
        return !(field.isAnnotationPresent(Column.class) && !field.getAnnotation(Column.class).updatable() || field.isAnnotationPresent(NonCascadeUpdatable.class) || parent.getClass().isAnnotationPresent(NonCascadeUpdatables.class) && Arrays.asList(parent.getClass().getAnnotation(NonCascadeUpdatables.class).value()).contains(field.getName()));
    }

    public void describeTo(Description description) {
    }

    public static Matcher<Object> isEqualTo(Object actual) {
        return new EquivalencyMatcher(actual);
    }

    public EquivalencyMatcher(@NonNull Object actual) {
        if (actual == null) {
            throw new NullPointerException("actual is marked non-null but is null");
        }
        this.actual = actual;
    }
}

