/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.testifi.service;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.sindaryn.apifi.service.ApiLogic;
import org.sindaryn.apifi.service.ApiMetaOperations;
import org.sindaryn.apifi.service.EmbeddedCollectionMetaOperations;
import org.sindaryn.datafi.persistence.Archivable;
import org.sindaryn.datafi.reflection.CachedEntityType;
import org.sindaryn.datafi.reflection.ReflectionCache;
import org.sindaryn.datafi.service.ArchivableDataManager;
import org.sindaryn.datafi.service.BaseDataManager;
import org.sindaryn.mockeri.generator.EntityMocker;
import org.sindaryn.mockeri.generator.TestDataGenerator;
import org.sindaryn.testifi.StaticUtils;
import org.sindaryn.testifi.service.EquivalencyMatcher;

public interface TestLogic {
    public static <T, E extends ApiMetaOperations<T>> void getAllTest(Class<?> clazz, BaseDataManager<T> dataManager, E metaOps) {
        int offset = 0;
        int limit = StaticUtils.totalCount(clazz, dataManager);
        List allTs = dataManager.findAll(clazz);
        List allApiFetchedTs = ApiLogic.getAll(clazz, dataManager, metaOps, (int)limit, (int)offset);
        Assert.assertThat((String)("result of api call to 'getAll" + StaticUtils.pluralCamelCaseName(clazz) + "()'  equals original entries in database"), (Object)allTs, EquivalencyMatcher.isEqualTo(allApiFetchedTs));
    }

    public static <T, E extends ApiMetaOperations<T>> void getByIdTest(Class<?> clazz, BaseDataManager<T> dataManager, E metaOps, ReflectionCache reflectionCache) {
        Object toGetById = TestDataGenerator.randomFrom((List)dataManager.findAll(clazz));
        Object id = org.sindaryn.datafi.StaticUtils.getId((Object)toGetById, (ReflectionCache)reflectionCache);
        Object fetchedById = ApiLogic.getById(clazz, dataManager, metaOps, (Object)id);
        Assert.assertThat((String)(clazz.getSimpleName() + " successfully fetched by id"), (Object)toGetById, EquivalencyMatcher.isEqualTo(fetchedById));
    }

    public static <T, E extends ApiMetaOperations<T>> void getByUniqueTest(Class<?> clazz, BaseDataManager<T> dataManager, E metaOps, String fieldName, ReflectionCache reflectionCache) {
        Object toGet = TestDataGenerator.randomFrom((List)dataManager.findAll(clazz));
        Object uniqueValue = ((CachedEntityType)reflectionCache.getEntitiesCache().get(clazz.getSimpleName())).invokeGetter(toGet, fieldName);
        Object fetched = ApiLogic.getByUnique(clazz, dataManager, metaOps, (String)fieldName, (Object)uniqueValue);
        Assert.assertThat((String)("Successfully fetched a " + org.sindaryn.datafi.StaticUtils.toPascalCase((String)clazz.getSimpleName()) + " by the unique value of " + fieldName + " = " + uniqueValue.toString()), (Object)toGet, EquivalencyMatcher.isEqualTo(fetched));
    }

    public static <T, E extends ApiMetaOperations<T>> void getByTest(Class<?> clazz, BaseDataManager<T> dataManager, E metaOps, String fieldName, ReflectionCache reflectionCache) {
        Object toGet = TestDataGenerator.randomFrom((List)dataManager.findAll(clazz));
        CachedEntityType entityType = (CachedEntityType)reflectionCache.getEntitiesCache().get(clazz.getSimpleName());
        Object value = entityType.invokeGetter(toGet, fieldName);
        List fetched = ApiLogic.getBy(clazz, dataManager, metaOps, (String)fieldName, (Object)value);
        for (Object instance : fetched) {
            Assert.assertThat((String)("successfully fetched instance of " + clazz.getSimpleName() + " by value of " + fieldName + " = " + value.toString()), (Object)entityType.invokeGetter(instance, fieldName), EquivalencyMatcher.isEqualTo(value));
        }
    }

    public static <T, E extends ApiMetaOperations<T>> void getAllByTest(Class<?> clazz, BaseDataManager<T> dataManager, E metaOps, String fieldName, ReflectionCache reflectionCache) {
        Map<Object, T> toGet = StaticUtils.firstRandomNIdMap(clazz, dataManager, reflectionCache);
        CachedEntityType entityType = (CachedEntityType)reflectionCache.getEntitiesCache().get(clazz.getSimpleName());
        List<Object> valuesList = StaticUtils.fieldValues(fieldName, Arrays.asList(toGet.values().toArray()), entityType);
        List fetched = ApiLogic.getAllBy(clazz, dataManager, metaOps, (String)fieldName, valuesList);
        Assert.assertTrue((fetched.size() >= toGet.size() ? 1 : 0) != 0);
        for (Object fetchedInstance : fetched) {
            T toGetInstance = toGet.get(org.sindaryn.datafi.StaticUtils.getId(fetchedInstance, (ReflectionCache)reflectionCache));
            if (toGetInstance == null) continue;
            Assert.assertThat(fetchedInstance, EquivalencyMatcher.isEqualTo(toGetInstance));
        }
    }

    public static <T, E extends ApiMetaOperations<T>> void selectByTest(Class<?> clazz, BaseDataManager<T> dataManager, E metaOps, String resolverName, Collection<String> fieldNames, EntityMocker entityMocker, ReflectionCache reflectionCache) {
        Map<Object, T> toSelect = StaticUtils.firstRandomNIdMap(clazz, dataManager, reflectionCache);
        CachedEntityType entityType = (CachedEntityType)reflectionCache.getEntitiesCache().get(clazz.getSimpleName());
        HashMap<String, Object> args = new HashMap<String, Object>();
        for (String string : fieldNames) {
            args.put(string, entityMocker.mockFieldValue(clazz, string));
        }
        Collection fields = ReflectionCache.getClassFields(clazz);
        for (Field field : fields) {
            if (!fieldNames.contains(field.getName())) continue;
            for (Map.Entry<Object, T> instanceEntry : toSelect.entrySet()) {
                entityType.invokeSetter(instanceEntry.getValue(), field.getName(), args.get(field.getName()));
            }
        }
        List list = ApiLogic.selectBy(clazz, dataManager, metaOps, (String)resolverName, new ArrayList(args.values()));
        Assert.assertTrue((list.size() >= toSelect.size() ? 1 : 0) != 0);
        for (Object selectedInstance : list) {
            T toSelectInstance = toSelect.get(org.sindaryn.datafi.StaticUtils.getId(selectedInstance, (ReflectionCache)reflectionCache));
            if (toSelectInstance == null) continue;
            Assert.assertThat(selectedInstance, EquivalencyMatcher.isEqualTo(toSelectInstance));
        }
    }

    public static <T, E extends ApiMetaOperations<T>> void addTest(Class<?> clazz, BaseDataManager<T> dataManager, EntityMocker entityMocker, E metaOps) {
        Object toAdd = entityMocker.instantiateEntity(clazz);
        Object added = ApiLogic.add(dataManager, (Object)toAdd, metaOps);
        Assert.assertThat((String)(clazz.getSimpleName() + " successfully added"), (Object)toAdd, EquivalencyMatcher.isEqualTo(added));
    }

    public static <T, E extends ApiMetaOperations<T>> void updateTest(Class<?> clazz, BaseDataManager<T> dataManager, EntityMocker entityMocker, ReflectionCache reflectionCache, E metaOps) {
        T original = StaticUtils.randomInstance(clazz, dataManager);
        Object updated = entityMocker.mockUpdate(original);
        StaticUtils.setField(updated, org.sindaryn.datafi.StaticUtils.getId(original, (ReflectionCache)reflectionCache), "id");
        Object updatedOriginal = ApiLogic.update(dataManager, (Object)updated, (ReflectionCache)reflectionCache, metaOps);
        Assert.assertThat((String)("successfully updated " + clazz.getSimpleName()), (Object)updated, EquivalencyMatcher.isEqualTo(updatedOriginal));
    }

    public static <T extends Archivable, E extends ApiMetaOperations<T>> void archiveTest(Class<?> clazz, ArchivableDataManager<T> dataManager, ReflectionCache reflectionCache, E metaOps) {
        Archivable instance = (Archivable)StaticUtils.randomInstance(clazz, dataManager);
        String simpleName = clazz.getSimpleName();
        Assert.assertFalse((String)("Default state of " + simpleName + " is non archived"), (boolean)instance.getIsArchived());
        Archivable archivedInstance = ApiLogic.archive(dataManager, (Archivable)instance, (ReflectionCache)reflectionCache, metaOps);
        Assert.assertTrue((String)("Instance of " + simpleName + " successfully archived"), (boolean)archivedInstance.getIsArchived());
    }

    public static <T extends Archivable, E extends ApiMetaOperations<T>> void archiveCollectionTest(Class<?> clazz, ArchivableDataManager<T> dataManager, E metaOps) {
        List<Archivable> instances = StaticUtils.firstRandomN(clazz, dataManager);
        int amountToArchive = instances.size();
        String simpleName = clazz.getSimpleName();
        boolean defaultStateIsNonArchived = true;
        for (Archivable instance : instances) {
            if (!instance.getIsArchived().booleanValue()) continue;
            defaultStateIsNonArchived = false;
            break;
        }
        Assert.assertTrue((String)("Default state of " + simpleName + " is non archived"), (boolean)defaultStateIsNonArchived);
        List archivedInstances = ApiLogic.archiveCollection(dataManager, instances, metaOps);
        boolean successfullyArchivedAllInstances = true;
        for (Archivable instance : archivedInstances) {
            if (instance.getIsArchived().booleanValue()) continue;
            successfullyArchivedAllInstances = false;
            break;
        }
        Assert.assertTrue((String)("Successfully archived " + amountToArchive + " instances of " + simpleName), (boolean)successfullyArchivedAllInstances);
    }

    public static <T extends Archivable, E extends ApiMetaOperations<T>> void deArchiveTest(Class<?> clazz, ArchivableDataManager<T> dataManager, ReflectionCache reflectionCache, E metaOps) {
        Archivable instance = (Archivable)StaticUtils.randomInstance(clazz, dataManager);
        String simpleName = clazz.getSimpleName();
        Assert.assertFalse((String)("Default state of " + simpleName + " is non archived"), (boolean)instance.getIsArchived());
        Archivable archivedInstance = dataManager.archive(instance);
        Archivable deArchivedInstance = ApiLogic.deArchive(dataManager, (Archivable)archivedInstance, (ReflectionCache)reflectionCache, metaOps);
        Assert.assertFalse((String)("Instance of " + simpleName + " successfully de archived"), (boolean)deArchivedInstance.getIsArchived());
    }

    public static <T extends Archivable, E extends ApiMetaOperations<T>> void deArchiveCollectionTest(Class<?> clazz, ArchivableDataManager<T> dataManager, E metaOps) {
        List<Archivable> instances = StaticUtils.firstRandomN(clazz, dataManager);
        int amountToArchive = instances.size();
        String simpleName = clazz.getSimpleName();
        boolean defaultStateIsNonArchived = true;
        for (Archivable instance : instances) {
            if (!instance.getIsArchived().booleanValue()) continue;
            defaultStateIsNonArchived = false;
            break;
        }
        Assert.assertTrue((String)("Default state of " + simpleName + " is non archived"), (boolean)defaultStateIsNonArchived);
        List archivedInstances = dataManager.archiveCollection(instances);
        List deArchivedInstances = ApiLogic.deArchiveCollection(dataManager, (List)archivedInstances, metaOps);
        boolean successfullyDeArchivedAllInstances = true;
        for (Archivable instance : deArchivedInstances) {
            if (!instance.getIsArchived().booleanValue()) continue;
            successfullyDeArchivedAllInstances = false;
            break;
        }
        Assert.assertTrue((String)("Successfully de archived " + amountToArchive + " instances of " + simpleName), (boolean)successfullyDeArchivedAllInstances);
    }

    public static <T, E extends ApiMetaOperations<T>> void deleteTest(Class<?> clazz, BaseDataManager<T> dataManager, ReflectionCache reflectionCache, EntityMocker entityMocker, E metaOps) {
        T toDelete = StaticUtils.randomInstance(clazz, dataManager);
        Object deleted = ApiLogic.delete(dataManager, (ReflectionCache)reflectionCache, toDelete, metaOps);
        Optional shouldNotBePresent = dataManager.findById(clazz, org.sindaryn.datafi.StaticUtils.getId((Object)deleted, (ReflectionCache)reflectionCache));
        Assert.assertFalse((String)(clazz.getSimpleName() + " successfully deleted"), (boolean)shouldNotBePresent.isPresent());
        entityMocker.instantiateEntity(clazz);
    }

    public static <T> void getCollectionByIdTest(Class<?> clazz, BaseDataManager<T> dataManager) {
        List present = dataManager.findAll(clazz);
        List ids = dataManager.idList((Iterable)present);
        List fetched = ApiLogic.getCollectionById(clazz, dataManager, (List)ids);
        Assert.assertThat((String)("successfully fetched " + present.size() + " " + org.sindaryn.datafi.StaticUtils.toPlural((String)clazz.getSimpleName()) + " by id"), (Object)present, EquivalencyMatcher.isEqualTo(fetched));
    }

    public static <T, E extends ApiMetaOperations<T>> void addCollectionTest(Class<?> clazz, BaseDataManager<T> dataManager, EntityMocker entityMocker, E metaOps) {
        int amountToAdd = ThreadLocalRandom.current().nextInt(5, 10);
        ArrayList<Object> toAdd = new ArrayList<Object>();
        for (int i = 0; i < amountToAdd; ++i) {
            toAdd.add(entityMocker.instantiateTransientEntity(clazz));
        }
        List added = ApiLogic.addCollection(dataManager, toAdd, metaOps);
        Assert.assertThat((String)("successfully added " + amountToAdd + " " + org.sindaryn.datafi.StaticUtils.toPlural((String)clazz.getSimpleName())), toAdd, EquivalencyMatcher.isEqualTo(added));
    }

    public static <T, E extends ApiMetaOperations<T>> void updateCollectionTest(Class<?> clazz, BaseDataManager<T> dataManager, EntityMocker entityMocker, E metaOps) {
        List<Object> updated = StaticUtils.firstRandomN(clazz, dataManager);
        int amountToUpdate = updated.size();
        updated.forEach(arg_0 -> ((EntityMocker)entityMocker).mockUpdate(arg_0));
        List updatedViaApi = ApiLogic.updateCollection(dataManager, updated, metaOps);
        Assert.assertThat((String)("successfully updated " + amountToUpdate + " " + org.sindaryn.datafi.StaticUtils.toPlural((String)clazz.getSimpleName())), updated, EquivalencyMatcher.isEqualTo(updatedViaApi));
    }

    public static <T, E extends ApiMetaOperations<T>> void deleteCollectionTest(Class<?> clazz, BaseDataManager<T> dataManager, EntityMocker entityMocker, E metaOps) {
        List<T> toDelete = StaticUtils.firstRandomN(clazz, dataManager);
        int amountToDelete = toDelete.size();
        ApiLogic.deleteCollection(dataManager, toDelete, metaOps);
        List ids = dataManager.idList(toDelete);
        List shouldBeEmpty = dataManager.findAllById(clazz, (Iterable)ids);
        Assert.assertTrue((String)(amountToDelete + " " + org.sindaryn.datafi.StaticUtils.toPlural((String)clazz.getSimpleName()) + " successfully deleted"), (boolean)shouldBeEmpty.isEmpty());
        for (int i = 0; i < amountToDelete; ++i) {
            entityMocker.instantiateEntity(clazz);
        }
    }

    public static <T, HasT> void getAsEmbeddedEntityTest(Class<?> tClazz, Class<?> hasTClazz, BaseDataManager<T> tDataManager, BaseDataManager<HasT> hasTDataManager, String fieldName, EntityMocker entityMocker, ReflectionCache reflectioncache) {
        List owners = StaticUtils.firstRandomN(hasTClazz, hasTDataManager);
        ArrayList<Object> embeddedEntities = new ArrayList<Object>();
        for (HasT owner : owners) {
            Object embeddedEntity = entityMocker.instantiateEntity(tClazz);
            StaticUtils.setField(owner, embeddedEntity, fieldName);
            embeddedEntities.add(embeddedEntity);
        }
        owners = hasTDataManager.saveAll(owners);
        List fetchedAsEmbedded = ApiLogic.getAsEmbeddedEntity(tClazz, tDataManager, (List)owners, (String)fieldName, (ReflectionCache)reflectioncache);
        Assert.assertThat((String)("successfully fetched " + fetchedAsEmbedded.size() + " " + org.sindaryn.datafi.StaticUtils.toPlural((String)fieldName) + " embedded within " + owners.size() + " " + org.sindaryn.datafi.StaticUtils.toPlural((String)hasTClazz.getSimpleName())), embeddedEntities, EquivalencyMatcher.isEqualTo(fetchedAsEmbedded));
    }

    public static <T, HasTs> void getAsEmbeddedEntityCollectionTest(Class<?> tClazz, Class<?> hasTsClazz, BaseDataManager<T> tDataManager, BaseDataManager<HasTs> hasTsDataManager, String fieldName, EntityMocker entityMocker, ReflectionCache reflectioncache) {
        List owners = StaticUtils.firstRandomN(hasTsClazz, hasTsDataManager);
        ArrayList embeddedEntityCollections = new ArrayList();
        for (HasTs owner : owners) {
            List embeddedEntityCollection = StaticUtils.persistCollectionOf(tClazz, entityMocker);
            StaticUtils.setCollectionField(owner, embeddedEntityCollection, fieldName, entityMocker);
            embeddedEntityCollections.add(embeddedEntityCollection);
        }
        owners = hasTsDataManager.saveAll(owners);
        List fetchedAsEmbedded = ApiLogic.getAsEmbeddedCollection(tClazz, tDataManager, (List)owners, (String)fieldName, (ReflectionCache)reflectioncache);
        Assert.assertThat((String)("Successfully fetched " + embeddedEntityCollections.size() + " collections of " + org.sindaryn.datafi.StaticUtils.toPlural((String)tClazz.getSimpleName()) + " from " + owners.size() + " " + org.sindaryn.datafi.StaticUtils.toPlural((String)hasTsClazz.getSimpleName())), embeddedEntityCollections, EquivalencyMatcher.isEqualTo(fetchedAsEmbedded));
    }

    public static <T, HasTs, E extends EmbeddedCollectionMetaOperations<T, HasTs>> void addNewToEmbeddedCollectionTest(Class<?> tClazz, Class<?> hasTsClazz, BaseDataManager<T> tDataManager, BaseDataManager<HasTs> hasTsDataManager, String fieldName, EntityMocker entityMocker, ReflectionCache reflectioncache, E metaOps) {
        Object toAddTo = entityMocker.instantiateEntity(hasTsClazz);
        List toAdd = StaticUtils.transientlyInstantiateCollectionOf(tClazz, entityMocker);
        List added = ApiLogic.addNewToEmbeddedCollection(hasTsDataManager, tDataManager, (Object)toAddTo, (String)fieldName, toAdd, metaOps, (ReflectionCache)reflectioncache);
        Assert.assertThat((String)("successfully added " + added.size() + " " + org.sindaryn.datafi.StaticUtils.toPlural((String)tClazz.getSimpleName()) + " to " + hasTsClazz.getSimpleName()), toAdd, EquivalencyMatcher.isEqualTo(added));
    }

    public static <T, HasTs, E extends EmbeddedCollectionMetaOperations<T, HasTs>> void attachExistingToEmbeddedCollectionTest(Class<?> tClazz, Class<?> hasTsClazz, BaseDataManager<T> tDataManager, BaseDataManager<HasTs> hasTsDataManager, String fieldName, EntityMocker entityMocker, ReflectionCache reflectioncache, E metaOps) {
        Object toAttachTo = entityMocker.instantiateEntity(hasTsClazz);
        List toAttach = StaticUtils.persistCollectionOf(tClazz, entityMocker);
        List attached = ApiLogic.attachExistingToEmbeddedCollection(hasTsDataManager, tDataManager, (Object)toAttachTo, (String)fieldName, toAttach, metaOps, (ReflectionCache)reflectioncache);
        Assert.assertThat((String)("successfully attached " + attached.size() + " pre-existing " + org.sindaryn.datafi.StaticUtils.toPlural((String)tClazz.getSimpleName()) + " to " + hasTsClazz.getSimpleName()), toAttach, EquivalencyMatcher.isEqualTo(attached));
    }

    public static <T, HasTs, E extends EmbeddedCollectionMetaOperations<T, HasTs>> void updateEmbeddedCollectionTest(Class<?> tClazz, Class<?> hasTsClazz, BaseDataManager<T> tDataManager, BaseDataManager<HasTs> hasTsDataManager, String fieldName, EntityMocker entityMocker, ReflectionCache reflectioncache, E metaOps) {
        Object owner = entityMocker.instantiateEntity(hasTsClazz);
        List originalEmbeddedCollection = StaticUtils.persistCollectionOf(tClazz, entityMocker);
        StaticUtils.setCollectionField(owner, originalEmbeddedCollection, fieldName, entityMocker);
        owner = hasTsDataManager.saveAndFlush(owner);
        ArrayList updatedEmbeddedCollection = Lists.newArrayList(originalEmbeddedCollection);
        updatedEmbeddedCollection.forEach(arg_0 -> ((EntityMocker)entityMocker).mockUpdate(arg_0));
        List fetchedEmbeddedCollection = ApiLogic.updateEmbeddedCollection(hasTsDataManager, tDataManager, (Object)owner, (Iterable)updatedEmbeddedCollection, metaOps, (ReflectionCache)reflectioncache);
        Assert.assertThat((String)("successfully updated " + fetchedEmbeddedCollection.size() + " " + fieldName + " in " + hasTsClazz.getSimpleName()), (Object)updatedEmbeddedCollection, EquivalencyMatcher.isEqualTo(fetchedEmbeddedCollection));
    }

    public static <T, HasTs, E extends EmbeddedCollectionMetaOperations<T, HasTs>> void removeFromEmbeddedCollectionTest(Class<?> tClazz, Class<?> hasTsClazz, BaseDataManager<T> tDataManager, BaseDataManager<HasTs> hasTsDataManager, String fieldName, EntityMocker entityMocker, ReflectionCache reflectioncache, E metaOps) {
        Object owner = entityMocker.instantiateEntity(hasTsClazz);
        List originalEmbeddedCollection = StaticUtils.persistCollectionOf(tClazz, entityMocker);
        StaticUtils.setCollectionField(owner, originalEmbeddedCollection, fieldName, entityMocker);
        tDataManager.saveAll(originalEmbeddedCollection);
        owner = hasTsDataManager.saveAndFlush(owner);
        Collection toRemoveFromCollection = StaticUtils.firstRandomEmbeddedN(owner, fieldName, reflectioncache);
        List removedFromEmbeddedCollection = ApiLogic.removeFromEmbeddedCollection(hasTsDataManager, tDataManager, (Object)owner, (String)fieldName, new ArrayList(toRemoveFromCollection), metaOps, (ReflectionCache)reflectioncache);
        int expectedCollectionSize = originalEmbeddedCollection.size() - toRemoveFromCollection.size();
        int actualCollectionSize = ((Collection)((CachedEntityType)reflectioncache.getEntitiesCache().get(owner.getClass().getSimpleName())).invokeGetter(owner, fieldName)).size();
        Assert.assertEquals((String)("successfully removed " + removedFromEmbeddedCollection.size() + " " + fieldName + " from " + hasTsClazz.getSimpleName()), (long)expectedCollectionSize, (long)actualCollectionSize);
    }
}

