/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.testifi.service;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import lombok.NonNull;
import org.junit.Test;
import org.sindaryn.datafi.annotations.WithResolver;
import org.sindaryn.testifi.StaticUtils;
import org.sindaryn.testifi.service.TestLogic;

public class TestMethodSpecs {
    @NonNull
    private ProcessingEnvironment processingEnvironment;
    private static final Class<?> testLogic = TestLogic.class;

    public MethodSpec generateGetAllEndpointTest(TypeElement entity) {
        String testName = "all" + StaticUtils.pluralPascalCaseName(entity) + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.getAllTest($T.class, $L, $L)", new Object[]{testLogic, ClassName.get((TypeElement)entity), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)entity), org.sindaryn.apifi.StaticUtils.metaOpsName((TypeElement)entity)}).returns(Void.TYPE).build();
    }

    public MethodSpec generateGetByIdEndpointTest(TypeElement entity) {
        String testName = "get" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)entity) + "ByIdTest";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.getByIdTest($T.class, $L, $L, $L)", new Object[]{testLogic, ClassName.get((TypeElement)entity), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)entity), org.sindaryn.apifi.StaticUtils.metaOpsName((TypeElement)entity), "reflectionCache"}).returns(Void.TYPE).build();
    }

    public MethodSpec generateGetByUniqueEndpointTest(TypeElement entity, VariableElement field) {
        String resolverName = "get" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)entity) + "ByUnique" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)field);
        String testName = resolverName + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.getByUniqueTest($T.class, $L, $L, $S, $L)", new Object[]{testLogic, ClassName.get((TypeElement)entity), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)entity), org.sindaryn.apifi.StaticUtils.metaOpsName((TypeElement)entity), field.getSimpleName(), "reflectionCache"}).returns(Void.TYPE).build();
    }

    public MethodSpec generateGetByEndpointTest(TypeElement entity, VariableElement field) {
        String resolverName = "get" + org.sindaryn.datafi.StaticUtils.toPlural((String)org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)entity)) + "By" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)field);
        String testName = resolverName + "Test";
        StaticUtils.checkForUniquenessConstraints(entity, resolverName, field.getSimpleName().toString().split(" "), this.processingEnvironment);
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.getByTest($T.class, $L, $L, $S, $L)", new Object[]{testLogic, ClassName.get((TypeElement)entity), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)entity), org.sindaryn.apifi.StaticUtils.metaOpsName((TypeElement)entity), field.getSimpleName(), "reflectionCache"}).returns(Void.TYPE).build();
    }

    public MethodSpec generateGetAllByEndpointTest(TypeElement entity, VariableElement field) {
        String resolverName = "getAll" + org.sindaryn.datafi.StaticUtils.toPlural((String)org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)entity)) + "By" + org.sindaryn.datafi.StaticUtils.toPlural((String)org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)field));
        String testName = resolverName + "Test";
        StaticUtils.checkForUniquenessConstraints(entity, resolverName, field.getSimpleName().toString().split(" "), this.processingEnvironment);
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.getAllByTest($T.class, $L, $L, $S, $L)", new Object[]{testLogic, ClassName.get((TypeElement)entity), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)entity), org.sindaryn.apifi.StaticUtils.metaOpsName((TypeElement)entity), field.getSimpleName(), "reflectionCache"}).returns(Void.TYPE).build();
    }

    public MethodSpec generateCustomResolverEndpointTest(TypeElement entity, WithResolver withResolver) {
        String resolverName = withResolver.name();
        String testName = resolverName + "Test";
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)testName);
        StaticUtils.checkForUniquenessConstraints(entity, withResolver.name(), withResolver.args(), this.processingEnvironment);
        this.argFieldNames(withResolver, builder);
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.selectByTest($T.class, $L, $L, $S, args, $L, $L)", new Object[]{testLogic, ClassName.get((TypeElement)entity), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)entity), org.sindaryn.apifi.StaticUtils.metaOpsName((TypeElement)entity), resolverName, StaticUtils.entityMocker(), "reflectionCache"}).returns(Void.TYPE);
        return builder.build();
    }

    private void argFieldNames(WithResolver withResolver, MethodSpec.Builder builder) {
        String args = "\"" + String.join((CharSequence)"\",\"", withResolver.args()) + "\"";
        ParameterizedTypeName listOfStrings = ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class});
        CodeBlock.Builder block = CodeBlock.builder().add("$T args = $T.asList($L)", new Object[]{listOfStrings, Arrays.class, args});
        builder.addStatement(block.build());
    }

    public MethodSpec generateArchiveEndpointTest(TypeElement entity) {
        String testName = "archive" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)entity) + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.archiveTest($T.class, $L, $L, $L)", new Object[]{testLogic, ClassName.get((TypeElement)entity), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)entity), "reflectionCache", org.sindaryn.apifi.StaticUtils.metaOpsName((TypeElement)entity)}).returns(Void.TYPE).build();
    }

    public MethodSpec generateArchiveCollectionEndpointTest(TypeElement entity) {
        String testName = "archive" + org.sindaryn.datafi.StaticUtils.toPlural((String)org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)entity)) + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.archiveCollectionTest($T.class, $L, $L)", new Object[]{testLogic, ClassName.get((TypeElement)entity), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)entity), org.sindaryn.apifi.StaticUtils.metaOpsName((TypeElement)entity)}).returns(Void.TYPE).build();
    }

    public MethodSpec generateDeArchiveCollectionEndpointTest(TypeElement entity) {
        String testName = "deArchive" + org.sindaryn.datafi.StaticUtils.toPlural((String)org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)entity)) + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.deArchiveCollectionTest($T.class, $L, $L)", new Object[]{testLogic, ClassName.get((TypeElement)entity), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)entity), org.sindaryn.apifi.StaticUtils.metaOpsName((TypeElement)entity)}).returns(Void.TYPE).build();
    }

    public MethodSpec generateDeArchiveEndpointTest(TypeElement entity) {
        String testName = "deArchive" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)entity) + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.deArchiveTest($T.class, $L, $L, $L)", new Object[]{testLogic, ClassName.get((TypeElement)entity), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)entity), "reflectionCache", org.sindaryn.apifi.StaticUtils.metaOpsName((TypeElement)entity)}).returns(Void.TYPE).build();
    }

    public MethodSpec generateAddEndpointTest(TypeElement entity) {
        String testName = "add" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)entity) + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.addTest($T.class, $L, $L, $L)", new Object[]{testLogic, ClassName.get((TypeElement)entity), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)entity), StaticUtils.entityMocker(), org.sindaryn.apifi.StaticUtils.metaOpsName((TypeElement)entity)}).returns(Void.TYPE).build();
    }

    public MethodSpec generateUpdateEndpointTest(TypeElement entity) {
        String testName = "update" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)entity) + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.updateTest($T.class, $L, $L, $L, $L)", new Object[]{testLogic, ClassName.get((TypeElement)entity), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)entity), StaticUtils.entityMocker(), "reflectionCache", org.sindaryn.apifi.StaticUtils.metaOpsName((TypeElement)entity)}).returns(Void.TYPE).build();
    }

    public MethodSpec generateDeleteEndpointTest(TypeElement entity) {
        String testName = "delete" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)entity) + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.deleteTest($T.class, $L, $L, $L, $L)", new Object[]{testLogic, ClassName.get((TypeElement)entity), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)entity), "reflectionCache", StaticUtils.entityMocker(), org.sindaryn.apifi.StaticUtils.metaOpsName((TypeElement)entity)}).returns(Void.TYPE).build();
    }

    public MethodSpec generateGetCollectionByIdEndpointTest(TypeElement entity) {
        String testName = "get" + org.sindaryn.datafi.StaticUtils.toPlural((String)org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)entity)) + "ByIdTest";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.getCollectionByIdTest($T.class, $L)", new Object[]{testLogic, ClassName.get((TypeElement)entity), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)entity)}).returns(Void.TYPE).build();
    }

    public MethodSpec generateAddCollectionEndpointTest(TypeElement entity) {
        String testName = "add" + org.sindaryn.datafi.StaticUtils.toPlural((String)org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)entity)) + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.addCollectionTest($T.class, $L, $L, $L)", new Object[]{testLogic, ClassName.get((TypeElement)entity), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)entity), StaticUtils.entityMocker(), org.sindaryn.apifi.StaticUtils.metaOpsName((TypeElement)entity)}).returns(Void.TYPE).build();
    }

    public MethodSpec generateUpdateCollectionEndpointTest(TypeElement entity) {
        String testName = "update" + org.sindaryn.datafi.StaticUtils.toPlural((String)org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)entity)) + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.updateCollectionTest($T.class, $L, $L, $L)", new Object[]{testLogic, ClassName.get((TypeElement)entity), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)entity), StaticUtils.entityMocker(), org.sindaryn.apifi.StaticUtils.metaOpsName((TypeElement)entity)}).returns(Void.TYPE).build();
    }

    public MethodSpec generateDeleteCollectionEndpointTest(TypeElement entity) {
        String testName = "delete" + org.sindaryn.datafi.StaticUtils.toPlural((String)org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)entity)) + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.deleteCollectionTest($T.class, $L, $L, $L)", new Object[]{testLogic, ClassName.get((TypeElement)entity), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)entity), StaticUtils.entityMocker(), org.sindaryn.apifi.StaticUtils.metaOpsName((TypeElement)entity)}).returns(Void.TYPE).build();
    }

    public MethodSpec generateGetAsEmbeddedEntityTest(VariableElement embedded, TypeElement owner) {
        String testName = "get" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)embedded) + "From" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)owner) + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.getAsEmbeddedEntityTest($T.class, $T.class, $L, $L, $S, $L, $L)", new Object[]{testLogic, ClassName.get((TypeMirror)embedded.asType()), ClassName.get((TypeElement)owner), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)embedded), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)owner), embedded.getSimpleName(), StaticUtils.entityMocker(), "reflectionCache"}).returns(Void.TYPE).build();
    }

    public MethodSpec generateGetAsEmbeddedEntityCollectionTest(VariableElement embedded, TypeElement owner) {
        String testName = "get" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)embedded) + "From" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)owner) + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.getAsEmbeddedEntityCollectionTest($T.class, $T.class, $L, $L, $S, $L, $L)", new Object[]{testLogic, org.sindaryn.apifi.StaticUtils.collectionTypeName((VariableElement)embedded), ClassName.get((TypeElement)owner), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)embedded), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)owner), embedded.getSimpleName(), StaticUtils.entityMocker(), "reflectionCache"}).returns(Void.TYPE).build();
    }

    public MethodSpec generateAttachExistingToEmbeddedCollectionTest(VariableElement embedded, TypeElement owner) {
        String testName = "attachExisting" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)embedded) + "To" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)owner) + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.attachExistingToEmbeddedCollectionTest($T.class, $T.class, $L, $L, $S, $L, $L, $L)", new Object[]{testLogic, org.sindaryn.apifi.StaticUtils.collectionTypeName((VariableElement)embedded), ClassName.get((TypeElement)owner), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)embedded), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)owner), embedded.getSimpleName(), StaticUtils.entityMocker(), "reflectionCache", org.sindaryn.apifi.StaticUtils.embeddedCollectionMetaOpsName((VariableElement)embedded)}).returns(Void.TYPE).build();
    }

    public MethodSpec generateRemoveFromEmbeddedCollectionTest(VariableElement embedded, TypeElement owner) {
        String testName = "remove" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)embedded) + "From" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)owner) + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.removeFromEmbeddedCollectionTest($T.class, $T.class, $L, $L, $S, $L, $L, $L)", new Object[]{testLogic, org.sindaryn.apifi.StaticUtils.collectionTypeName((VariableElement)embedded), ClassName.get((TypeElement)owner), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)embedded), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)owner), embedded.getSimpleName(), StaticUtils.entityMocker(), "reflectionCache", org.sindaryn.apifi.StaticUtils.embeddedCollectionMetaOpsName((VariableElement)embedded)}).returns(Void.TYPE).build();
    }

    public MethodSpec generateAddNewToEmbeddedCollectionTest(VariableElement embedded, TypeElement owner) {
        String testName = "addNew" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)embedded) + "To" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)owner) + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.addNewToEmbeddedCollectionTest($T.class, $T.class, $L, $L, $S, $L, $L, $L)", new Object[]{testLogic, org.sindaryn.apifi.StaticUtils.collectionTypeName((VariableElement)embedded), ClassName.get((TypeElement)owner), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)embedded), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)owner), embedded.getSimpleName(), StaticUtils.entityMocker(), "reflectionCache", org.sindaryn.apifi.StaticUtils.embeddedCollectionMetaOpsName((VariableElement)embedded)}).returns(Void.TYPE).build();
    }

    public MethodSpec generateUpdateEmbeddedCollectionTest(VariableElement embedded, TypeElement owner) {
        String testName = "update" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)embedded) + "In" + org.sindaryn.apifi.StaticUtils.pascalCaseNameOf((Element)owner) + "Test";
        return MethodSpec.methodBuilder((String)testName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Test.class).addStatement("$T.updateEmbeddedCollectionTest($T.class, $T.class, $L, $L, $S, $L, $L, $L)", new Object[]{testLogic, org.sindaryn.apifi.StaticUtils.collectionTypeName((VariableElement)embedded), ClassName.get((TypeElement)owner), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)embedded), org.sindaryn.apifi.StaticUtils.dataManagerName((Element)owner), embedded.getSimpleName(), StaticUtils.entityMocker(), "reflectionCache", org.sindaryn.apifi.StaticUtils.embeddedCollectionMetaOpsName((VariableElement)embedded)}).returns(Void.TYPE).build();
    }

    public TestMethodSpecs(@NonNull ProcessingEnvironment processingEnvironment) {
        if (processingEnvironment == null) {
            throw new NullPointerException("processingEnvironment is marked non-null but is null");
        }
        this.processingEnvironment = processingEnvironment;
    }
}

