/*
 * Decompiled with CFR 0.152.
 */
package org.siqisource.demosupport;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class InitListener
implements ServletContextListener {
    public void contextDestroyed(ServletContextEvent context) {
    }

    public void contextInitialized(ServletContextEvent contextEvent) {
        try {
            ServletContext context = contextEvent.getServletContext();
            String physicalPath = context.getRealPath("/");
            File cvsPath = new File(physicalPath + "WEB-INF/csv");
            String[] extensions = new String[]{"csv"};
            Collection files = FileUtils.listFiles((File)cvsPath, (String[])extensions, (boolean)true);
            Connection connection = (Connection)context.getAttribute("connection");
            System.out.println("cleaning database");
            this.clearDatabase(connection);
            System.out.println("loading tables");
            for (File file : files) {
                this.loadTable(connection, file);
            }
            System.out.println("loaded tables");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("init demo error ", e);
        }
    }

    private void clearDatabase(Connection conn) throws SQLException {
        Statement statement = conn.createStatement();
        statement.execute("DROP ALL OBJECTS");
        statement.close();
    }

    private void loadTable(Connection conn, File file) throws SQLException {
        String fileName = file.getName();
        String tableName = FilenameUtils.getBaseName((String)fileName);
        String fileFullName = file.getAbsolutePath();
        String sql = "CREATE TABLE " + tableName + " AS SELECT * FROM CSVREAD('" + fileFullName + "')";
        Statement statement = conn.createStatement();
        statement.execute(sql);
        statement.close();
    }
}

