/*
 * Decompiled with CFR 0.152.
 */
package org.siqisource.demosupport.tags;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.siqisource.demosupport.NameConverter;
import org.siqisource.demosupport.TagUtils;

public class ListTag
extends SimpleTagSupport {
    protected String tableName;
    protected String resultKey;
    protected Integer offset;
    protected Integer limit;
    protected boolean json = false;

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setResultKey(String resultKey) {
        this.resultKey = resultKey;
    }

    public void setJson(boolean json) {
        this.json = json;
    }

    public void doTag() throws JspException, IOException {
        PageContext pageCtx = (PageContext)this.getJspContext();
        HttpServletRequest request = (HttpServletRequest)pageCtx.getRequest();
        List<Object> list = new ArrayList();
        try {
            list = this.list(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String string = this.resultKey = this.resultKey == null ? "list" : this.resultKey;
        if (this.json) {
            ObjectMapper mapper = new ObjectMapper();
            String result = mapper.writeValueAsString((Object)this.json);
            request.setAttribute(this.resultKey, (Object)result);
        } else {
            request.setAttribute(this.resultKey, list);
        }
    }

    private List<Map<String, String>> list(HttpServletRequest request) throws SQLException {
        ArrayList<String> sqlParamValues = new ArrayList<String>();
        String sql = this.getSql(request, sqlParamValues, " * ", true);
        Connection conn = (Connection)request.getServletContext().getAttribute("connection");
        QueryRunner qr = new QueryRunner();
        List list = (List)qr.query(conn, sql, (ResultSetHandler)new MapListHandler(), sqlParamValues.toArray());
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (Map columns : list) {
            HashMap<String, String> properties = new HashMap<String, String>();
            for (Map.Entry entry : columns.entrySet()) {
                String value = (String)entry.getValue();
                value = value == null ? "" : value;
                properties.put(NameConverter.columnToProperty((String)entry.getKey()), value);
            }
            result.add(properties);
        }
        return result;
    }

    protected String getSql(HttpServletRequest request, List<String> sqlParamValues, String columns, boolean limitAble) throws SQLException {
        Map<String, String> params = TagUtils.getUsefulParams(request, this.tableName);
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select ");
        sbSql.append(columns);
        sbSql.append(" from ");
        sbSql.append(this.tableName);
        if (!params.isEmpty()) {
            sbSql.append(" where ");
            boolean needAnd = false;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (needAnd) {
                    sbSql.append(" and ");
                }
                sbSql.append(entry.getKey());
                sbSql.append(" like ? ");
                sqlParamValues.add("%" + entry.getValue() + "%");
                needAnd = true;
            }
        }
        if (!limitAble) {
            return sbSql.toString();
        }
        if (this.limit != null && this.limit > 0) {
            sbSql.append(" LIMIT  ");
            sbSql.append(this.limit);
            if (this.offset != null && this.offset > 0) {
                sbSql.append(" OFFSET  ");
                sbSql.append(this.offset);
            }
        }
        return sbSql.toString();
    }
}

