package org.sireum {
  object Either {
    def apply[L, R](leftOpt: Option[L], rightOpt: Option[R]): Either[L, R] = new Either(leftOpt, rightOpt);
    def unapply[L, R](o: Either[L, R]): _root_.scala.Option[scala.Tuple2[Option[L], Option[R]]] = _root_.scala.Some(scala.Tuple2(o.leftOpt, o.rightOpt))
  }

  @datatype class Either[L, R](_leftOpt: Option[L], _rightOpt: Option[R]) extends _root_.org.sireum.DatatypeSig {
    StringContext(" invariant leftOpt.nonEmpty || rightOpt.nonEmpty ").lUnit();
    def leftOpt = _leftOpt;
    def rightOpt = _rightOpt;
    override def toString: _root_.java.lang.String = {
      val sb = new _root_.java.lang.StringBuilder();
      sb.append("Either");
      sb.append('(');
      sb.append(_root_.org.sireum.String.escape(leftOpt));
      sb.append(", ");
      sb.append(_root_.org.sireum.String.escape(rightOpt));
      sb.append(')');
      sb.toString
    };
    override def string: _root_.org.sireum.String = toString;
    override lazy val hashCode: _root_.scala.Int = _root_.scala.Seq(this.getClass, leftOpt, rightOpt).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): Either[L, R] @unchecked)) => if (this.hashCode.!=(o.hashCode))
          false
        else
          leftOpt.==(o.leftOpt).&&(rightOpt.==(o.rightOpt))
        case _ => false
      };
    def apply(leftOpt: Option[L] = this.leftOpt, rightOpt: Option[R] = this.rightOpt): Either[L, R] = new Either(leftOpt, rightOpt);
    override lazy val content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Either")), scala.Tuple2("leftOpt", leftOpt), scala.Tuple2("rightOpt", rightOpt))
  }
}