package org.sireum {
  object HashSMap {
    @pure def empty[K, V]: HashSMap[K, V] = return HashSMap(HashMap.empty, Set.empty);
    @pure def emptyInit[K, V](initialCapacity: Z): HashSMap[K, V] = return HashSMap(HashMap.emptyInit(initialCapacity), Set.empty);
    def apply[K, V](map: HashMap[K, V], keys: Set[K]): HashSMap[K, V] = new HashSMap(map, keys);
    def unapply[K, V](o: HashSMap[K, V]): _root_.scala.Option[scala.Tuple2[HashMap[K, V], Set[K]]] = _root_.scala.Some(scala.Tuple2(o.map, o.keys))
  }

  @datatype class HashSMap[K, V](_map: HashMap[K, V], _keys: Set[K]) extends _root_.org.sireum.DatatypeSig {
    @pure def size: Z = return keys.size;
    @pure override def hash: Z = return _root_.org.sireum.Z(map.hashCode);
    @pure def entries: ISZ[scala.Tuple2[K, V]] = {
      var r = _root_.org.sireum.helper.$assign(ISZ[scala.Tuple2[K, V]]());
      keys.elements.foreach(((k) => _root_.org.sireum.helper.$tmatch(map.get(k)) match {
        case Some((v @ _)) => r = _root_.org.sireum.helper.$assign(r.:+(scala.Tuple2(_root_.org.sireum.helper.$assign(k), _root_.org.sireum.helper.$assign(v))))
        case _ => ()
      }));
      return r
    };
    @pure def values: ISZ[V] = return map.values;
    @pure def keySet: Set[K] = return keys;
    @pure def valueSet: Set[V] = return Set.empty[V].addAll(values);
    @pure def put(key: K, value: V): HashSMap[K, V] = {
      val newMap = _root_.org.sireum.helper.$assign(map.put(key, value));
      return HashSMap(newMap, keys.add(key))
    };
    @pure def putAll(entries: ISZ[scala.Tuple2[K, V]]): HashSMap[K, V] = {
      if (entries.isEmpty)
        return this
      else
        ();
      val newMap = _root_.org.sireum.helper.$assign(map.putAll(entries));
      var newKeys = _root_.org.sireum.helper.$assign(keys);
      entries.foreach(((kv) => newKeys = _root_.org.sireum.helper.$assign(newKeys.add(kv._1))));
      return HashSMap(newMap, newKeys)
    };
    @pure def get(key: K): Option[V] = return map.get(key);
    @pure def entry(key: K): Option[scala.Tuple2[K, V]] = return map.entry(key);
    @pure def removeAll(keys: ISZ[K]): HashSMap[K, V] = return HashSMap(map.removeAll(keys), this.keys.removeAll(keys));
    @pure def remove(key: K, value: V): HashSMap[K, V] = return HashSMap(map.remove(key, value), keys.remove(key));
    @pure def isEqual(other: HashSMap[K, V]): B = return map.isEqual(other.map);
    @pure def contains(key: K): B = return map.contains(key);
    @pure def isEmpty: B = return size.==(StringContext("0").z());
    @pure def nonEmpty: B = return size.!=(StringContext("0").z());
    def map = _map;
    def keys = _keys;
    override def toString: _root_.java.lang.String = {
      val sb = new _root_.java.lang.StringBuilder();
      sb.append("HashSMap");
      sb.append('(');
      sb.append(_root_.org.sireum.String.escape(map));
      sb.append(", ");
      sb.append(_root_.org.sireum.String.escape(keys));
      sb.append(')');
      sb.toString
    };
    override def string: _root_.org.sireum.String = toString;
    override lazy val hashCode: _root_.scala.Int = hash.hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): HashSMap[K, V] @unchecked)) => isEqual(o)
        case _ => false
      };
    def apply(map: HashMap[K, V] = this.map, keys: Set[K] = this.keys): HashSMap[K, V] = new HashSMap(map, keys);
    override lazy val content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "HashSMap")), scala.Tuple2("map", map), scala.Tuple2("keys", keys))
  }
}