package org.sireum {
  object HashSSet {
    @pure def empty[T]: HashSSet[T] = return HashSSet(HashSMap.empty);
    @pure def emptyInit[T](initialCapacity: Z): HashSSet[T] = return HashSSet(HashSMap.emptyInit(initialCapacity));
    def apply[T](map: HashSMap[T, B]): HashSSet[T] = new HashSSet(map);
    def unapply[T](o: HashSSet[T]): _root_.scala.Option[HashSMap[T, B]] = _root_.scala.Some(o.map)
  }

  @datatype class HashSSet[T](_map: HashSMap[T, B]) extends _root_.org.sireum.DatatypeSig {
    @pure def add(e: T): HashSSet[T] = return HashSSet(map.put(e, T));
    @pure def addAll(is: ISZ[T]): HashSSet[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      is.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.add(e))));
      return r
    };
    @pure def remove(e: T): HashSSet[T] = return HashSSet(map.remove(e, T));
    @pure def removeAll(is: ISZ[T]): HashSSet[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      is.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.remove(e))));
      return r
    };
    @pure def contains(e: T): B = return map.contains(e);
    @pure def union(other: HashSSet[T]): HashSSet[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      other.map.keys.elements.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.add(e))));
      return r
    };
    @pure def intersect(other: HashSSet[T]): HashSSet[T] = {
      var r = _root_.org.sireum.helper.$assign(HashSSet.emptyInit[T](size));
      other.map.keys.elements.foreach(((e) => if (contains(e))
        r = _root_.org.sireum.helper.$assign(r.add(e))
      else
        ()));
      return r
    };
    @pure def substract(other: HashSSet[T]): HashSSet[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      other.map.keys.elements.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.remove(e))));
      return r
    };
    @pure def isEqual(other: HashSSet[T]): B = return map.isEqual(other.map);
    @pure def isEmpty: B = return size.==(StringContext("0").z());
    @pure def nonEmpty: B = return size.!=(StringContext("0").z());
    @pure def size: Z = return map.size;
    @pure def elements: ISZ[T] = return map.keys.elements;
    def map = _map;
    override def toString: _root_.java.lang.String = {
      val sb = new _root_.java.lang.StringBuilder();
      sb.append("HashSSet");
      sb.append('(');
      sb.append(_root_.org.sireum.String.escape(map));
      sb.append(')');
      sb.toString
    };
    override def string: _root_.org.sireum.String = toString;
    override lazy val hashCode: _root_.scala.Int = 0;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): HashSSet[T] @unchecked)) => isEqual(o)
        case _ => false
      };
    def apply(map: HashSMap[T, B] = this.map): HashSSet[T] = new HashSSet(map);
    override lazy val content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "HashSSet")), scala.Tuple2("map", map))
  }
}