package org.sireum {
  object HashSet {
    @pure def empty[T]: HashSet[T] = return HashSet(HashMap.empty[T, B]);
    @pure def emptyInit[T](initialCapacity: Z): HashSet[T] = return HashSet(HashMap.emptyInit(initialCapacity));
    def apply[T](map: HashMap[T, B]): HashSet[T] = new HashSet(map);
    def unapply[T](o: HashSet[T]): _root_.scala.Option[HashMap[T, B]] = _root_.scala.Some(o.map)
  }

  @datatype class HashSet[T](_map: HashMap[T, B]) extends _root_.org.sireum.DatatypeSig {
    @pure def add(e: T): HashSet[T] = return HashSet(map.put(e, T));
    @pure def addAll(is: ISZ[T]): HashSet[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      is.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.add(e))));
      return r
    };
    @pure def remove(e: T): HashSet[T] = return HashSet(map.remove(e, T));
    @pure def removeAll(is: ISZ[T]): HashSet[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      is.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.remove(e))));
      return r
    };
    @pure def contains(e: T): B = return map.contains(e);
    @pure def union(other: HashSet[T]): HashSet[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      other.map.keys.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.add(e))));
      return r
    };
    @pure def intersect(other: HashSet[T]): HashSet[T] = {
      var r = _root_.org.sireum.helper.$assign(HashSet.emptyInit[T](size));
      other.map.keys.foreach(((e) => if (contains(e))
        r = _root_.org.sireum.helper.$assign(r.add(e))
      else
        ()));
      return r
    };
    @pure def substract(other: HashSet[T]): HashSet[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      other.map.keys.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.remove(e))));
      return r
    };
    @pure def isEqual(other: HashSet[T]): B = return map.isEqual(other.map);
    @pure def isEmpty: B = return size.==(StringContext("0").z());
    @pure def nonEmpty: B = return size.!=(StringContext("0").z());
    @pure def size: Z = return map.size;
    @pure def elements: ISZ[T] = return map.keys;
    def map = _map;
    override def toString: _root_.java.lang.String = {
      val sb = new _root_.java.lang.StringBuilder();
      sb.append("HashSet");
      sb.append('(');
      sb.append(_root_.org.sireum.String.escape(map));
      sb.append(')');
      sb.toString
    };
    override def string: _root_.org.sireum.String = toString;
    override lazy val hashCode: _root_.scala.Int = 0;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): HashSet[T] @unchecked)) => isEqual(o)
        case _ => false
      };
    def apply(map: HashMap[T, B] = this.map): HashSet[T] = new HashSet(map);
    override lazy val content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "HashSet")), scala.Tuple2("map", map))
  }
}