package org.sireum {
  import org.sireum.ops._

  object Json {
    @sig trait JsonAstBinding[V] extends _root_.org.sireum.Immutable {
      @pure def toObject(fields: ISZ[scala.Tuple2[String, V]]): V;
      @pure def toArray(elements: ISZ[V]): V;
      @pure def toNumber(s: String): V;
      @pure def toString(s: String): V;
      @pure def toNull: V;
      @pure def toBoolean(b: B): V;
      @pure def kind(o: V): ValueKind.Type;
      @pure def fromObject(o: V): ISZ[scala.Tuple2[String, V]];
      @pure def fromArray(o: V): ISZ[V];
      @pure def fromNumber(o: V): String;
      @pure def fromString(o: V): String;
      @pure def fromBoolean(o: V): B
    };
    object ErrorMsg {
      def apply(line: Z, column: Z, message: String): ErrorMsg = new ErrorMsg(line, column, message);
      def unapply(o: ErrorMsg): _root_.scala.Option[scala.Tuple3[Z, Z, String]] = _root_.scala.Some(scala.Tuple3(o.line, o.column, o.message))
    };
    @datatype class ErrorMsg(_line: Z, _column: Z, _message: String) extends _root_.org.sireum.DatatypeSig {
      def line = _line;
      def column = _column;
      def message = _message;
      override def toString: _root_.java.lang.String = {
        val sb = new _root_.java.lang.StringBuilder();
        sb.append("ErrorMsg");
        sb.append('(');
        sb.append(_root_.org.sireum.String.escape(line));
        sb.append(", ");
        sb.append(_root_.org.sireum.String.escape(column));
        sb.append(", ");
        sb.append(_root_.org.sireum.String.escape(message));
        sb.append(')');
        sb.toString
      };
      override def string: _root_.org.sireum.String = toString;
      override lazy val hashCode: _root_.scala.Int = _root_.scala.Seq(this.getClass, line, column, message).hashCode;
      override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): ErrorMsg)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            line.==(o.line).&&(column.==(o.column)).&&(message.==(o.message))
          case _ => false
        };
      def apply(line: Z = this.line, column: Z = this.column, message: String = this.message): ErrorMsg = new ErrorMsg(line, column, message);
      override lazy val content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "ErrorMsg")), scala.Tuple2("line", line), scala.Tuple2("column", column), scala.Tuple2("message", message))
    };
    @enum object ValueKind extends _root_.org.sireum.EnumSig {
      scala.Symbol("String");
      scala.Symbol("Number");
      scala.Symbol("Object");
      scala.Symbol("Array");
      scala.Symbol("True");
      scala.Symbol("False");
      scala.Symbol("Null");
      sealed trait Type extends _root_.scala.Ordered[Type] {
        def ordinal: _root_.org.sireum.Z;
        def name: _root_.org.sireum.String;
        final def hash: _root_.org.sireum.Z = hashCode;
        final def isEqual(other: Type): _root_.org.sireum.B = this.==(other);
        final def compare(that: Type): _root_.scala.Int = this.ordinal.compareTo(that.ordinal)
      };
      final def byName(name: _root_.org.sireum.String): _root_.org.sireum.Option[Type] = elements.elements.find(((x$1) => x$1.name.==(name))) match {
        case _root_.scala.Some((v @ _)) => _root_.org.sireum.Some(v)
        case _ => _root_.org.sireum.None()
      };
      final def byOrdinal(n: _root_.org.sireum.Z): _root_.org.sireum.Option[Type] = if ((0).<=(n).&&(n.<(elements.size)))
        _root_.org.sireum.Some(elements(n))
      else
        _root_.org.sireum.None();
      final case object String extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 0;
        def name: _root_.org.sireum.String = "String"
      };
      final case object Number extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 1;
        def name: _root_.org.sireum.String = "Number"
      };
      final case object Object extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 2;
        def name: _root_.org.sireum.String = "Object"
      };
      final case object Array extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 3;
        def name: _root_.org.sireum.String = "Array"
      };
      final case object True extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 4;
        def name: _root_.org.sireum.String = "True"
      };
      final case object False extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 5;
        def name: _root_.org.sireum.String = "False"
      };
      final case object Null extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 6;
        def name: _root_.org.sireum.String = "Null"
      };
      val numOfElements: _root_.org.sireum.Z = 7;
      val elements: _root_.org.sireum.ISZ[Type] = _root_.org.sireum.ISZ[Type](String, Number, Object, Array, True, False, Null)
    };
    object Printer {
      val trueSt: ST = StringContext("true").st();
      val falseSt: ST = StringContext("false").st();
      val nullSt: ST = StringContext("null").st();
      @pure def printB(b: B): ST = if (b)
        return trueSt
      else
        return falseSt;
      @pure def printC(c: C): ST = return printString(c.string);
      @pure def printZ(n: Z): ST = return printNumber(n.string);
      @pure def printZ8(n: Z8): ST = return printNumber(n.string);
      @pure def printZ16(n: Z16): ST = return printNumber(n.string);
      @pure def printZ32(n: Z32): ST = return printNumber(n.string);
      @pure def printZ64(n: Z64): ST = return printNumber(n.string);
      @pure def printN(n: N): ST = return printNumber(n.string);
      @pure def printN8(n: N8): ST = return printNumber(n.string);
      @pure def printN16(n: N16): ST = return printNumber(n.string);
      @pure def printN32(n: N32): ST = return printNumber(n.string);
      @pure def printN64(n: N64): ST = return printNumber(n.string);
      @pure def printS8(n: S8): ST = return printNumber(n.string);
      @pure def printS16(n: S16): ST = return printNumber(n.string);
      @pure def printS32(n: S32): ST = return printNumber(n.string);
      @pure def printS64(n: S64): ST = return printNumber(n.string);
      @pure def printU8(n: U8): ST = return printNumber(n.string);
      @pure def printU16(n: U16): ST = return printNumber(n.string);
      @pure def printU32(n: U32): ST = return printNumber(n.string);
      @pure def printU64(n: U64): ST = return printNumber(n.string);
      @pure def printF32(n: F32): ST = return printNumber(n.string);
      @pure def printF64(n: F64): ST = return printNumber(n.string);
      @pure def printR(n: R): ST = return printNumber(n.string);
      @pure def printISZ[T](isSimple: B, s: IS[Z, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printISZ8[T](isSimple: B, s: IS[Z8, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printISZ16[T](isSimple: B, s: IS[Z16, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printISZ32[T](isSimple: B, s: IS[Z32, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printISZ64[T](isSimple: B, s: IS[Z64, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printISN[T](isSimple: B, s: IS[N, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printISN8[T](isSimple: B, s: IS[N8, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printISN16[T](isSimple: B, s: IS[N16, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printISN32[T](isSimple: B, s: IS[N32, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printISN64[T](isSimple: B, s: IS[N64, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printISS8[T](isSimple: B, s: IS[S8, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printISS16[T](isSimple: B, s: IS[S16, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printISS32[T](isSimple: B, s: IS[S32, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printISS64[T](isSimple: B, s: IS[S64, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printISU8[T](isSimple: B, s: IS[U8, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printISU16[T](isSimple: B, s: IS[U16, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printISU32[T](isSimple: B, s: IS[U32, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printISU64[T](isSimple: B, s: IS[U64, T], f: _root_.scala.Function1[T, ST]): ST = return printIS(isSimple, s.map(f));
      @pure def printMSZ[T](isSimple: B, s: MS[Z, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printMSZ8[T](isSimple: B, s: MS[Z8, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printMSZ16[T](isSimple: B, s: MS[Z16, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printMSZ32[T](isSimple: B, s: MS[Z32, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printMSZ64[T](isSimple: B, s: MS[Z64, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printMSN[T](isSimple: B, s: MS[N, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printMSN8[T](isSimple: B, s: MS[N8, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printMSN16[T](isSimple: B, s: MS[N16, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printMSN32[T](isSimple: B, s: MS[N32, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printMSN64[T](isSimple: B, s: MS[N64, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printMSS8[T](isSimple: B, s: MS[S8, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printMSS16[T](isSimple: B, s: MS[S16, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printMSS32[T](isSimple: B, s: MS[S32, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printMSS64[T](isSimple: B, s: MS[S64, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printMSU8[T](isSimple: B, s: MS[U8, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printMSU16[T](isSimple: B, s: MS[U16, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printMSU32[T](isSimple: B, s: MS[U32, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printMSU64[T](isSimple: B, s: MS[U64, T], f: _root_.scala.Function1[T, ST]): ST = return printMS(isSimple, s.map(f));
      @pure def printOption[T](o: Option[T], f: _root_.scala.Function1[T, ST]): ST = _root_.org.sireum.helper.$tmatch(o) match {
        case Some((t @ _)) => return printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Some")))), scala.Tuple2(_root_.org.sireum.String("value"), _root_.org.sireum.helper.$assign(f(t)))))
        case _ => return printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("None"))))))
      };
      @pure def printMOption[T](o: MOption[T], f: _root_.scala.Function1[T, ST]): ST = _root_.org.sireum.helper.$tmatch(o) match {
        case MSome((t @ _)) => return printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Some")))), scala.Tuple2(_root_.org.sireum.String("value"), _root_.org.sireum.helper.$assign(f(t)))))
        case _ => return printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("None"))))))
      };
      @pure def printEither[L, R](o: Either[L, R], f0: _root_.scala.Function1[L, ST], f1: _root_.scala.Function1[R, ST]): ST = _root_.org.sireum.helper.$tmatch(o) match {
        case Either(Some((l @ _)), _) => return printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Or")))), scala.Tuple2(_root_.org.sireum.String("i"), _root_.org.sireum.helper.$assign(printZ(_root_.org.sireum.Z(0)))), scala.Tuple2(_root_.org.sireum.String("value"), _root_.org.sireum.helper.$assign(f0(l)))))
        case Either(_, Some((r @ _))) => return printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Or")))), scala.Tuple2(_root_.org.sireum.String("i"), _root_.org.sireum.helper.$assign(printZ(_root_.org.sireum.Z(1)))), scala.Tuple2(_root_.org.sireum.String("value"), _root_.org.sireum.helper.$assign(f1(r)))))
        case _ => {
          assume(F);
          return nullSt
        }
      };
      @pure def printMEither[L, R](o: MEither[L, R], f0: _root_.scala.Function1[L, ST], f1: _root_.scala.Function1[R, ST]): ST = _root_.org.sireum.helper.$tmatch(o) match {
        case MEither(MSome((l @ _)), _) => return printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Or")))), scala.Tuple2(_root_.org.sireum.String("i"), _root_.org.sireum.helper.$assign(printZ(_root_.org.sireum.Z(0)))), scala.Tuple2(_root_.org.sireum.String("value"), _root_.org.sireum.helper.$assign(f0(l)))))
        case MEither(_, MSome((r @ _))) => return printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Or")))), scala.Tuple2(_root_.org.sireum.String("i"), _root_.org.sireum.helper.$assign(printZ(_root_.org.sireum.Z(1)))), scala.Tuple2(_root_.org.sireum.String("value"), _root_.org.sireum.helper.$assign(f1(r)))))
        case _ => {
          assume(F);
          return nullSt
        }
      };
      @pure def printString(s: String): ST = {
        var r = _root_.org.sireum.helper.$assign(ISZ[C]());
        s.toCis.foreach(((c) => _root_.org.sireum.helper.$tmatch(c.native) match {
          case '\"' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('\"')))
          case '\\' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('\\')))
          case '/' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('/')))
          case '\b' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('b')))
          case '\f' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('f')))
          case '\n' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('n')))
          case '\r' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('r')))
          case '\t' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('t')))
          case _ if _root_.org.sireum.C(' ').<=(c).&&(c.<(_root_.org.sireum.C('ÿ'))).&&(c.!=(_root_.org.sireum.C('\u007F'))) => r = _root_.org.sireum.helper.$assign(r.:+(c))
          case _ => {
            val q = _root_.org.sireum.helper.$assign(COps(c).toUnicodeHex);
            r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('u')).:+(q._1).:+(q._2).:+(q._3).:+(q._4))
          }
        }));
        return StringContext("\"", "\"").st(String(r))
      };
      @pure def printConstant(s: String): ST = _root_.org.sireum.helper.$tmatch(s.native) match {
        case "true" => return trueSt
        case "false" => return falseSt
        case "null" => return nullSt
      };
      @pure def printNumber(s: String): ST = return StringContext("", "").st(s);
      @pure def printObject(fields: ISZ[scala.Tuple2[String, ST]]): ST = {
        val fs: ISZ[ST] = _root_.org.sireum.helper.$assign(fields.map(((p) => StringContext("\"", "\" : ", "").st(p._1, p._2))));
        return StringContext("""{
                 |  """, """
                 |}""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(fs), _root_.org.sireum.String(",\n")))
      };
      @pure def printIS[I](isSimple: B, elements: IS[I, ST]): ST = if (isSimple)
        return StringContext("[", "]").st(scala.Tuple2(_root_.org.sireum.helper.$assign(elements), _root_.org.sireum.String(", ")))
      else
        return StringContext("""[
                   |  """, """
                   |]""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(elements), _root_.org.sireum.String(",\n")));
      @pure def printMS[I](isSimple: B, elements: MS[I, ST]): ST = if (isSimple)
        return StringContext("[", "]").st(scala.Tuple2(_root_.org.sireum.helper.$assign(elements), _root_.org.sireum.String(", ")))
      else
        return StringContext("""[
                   |  """, """
                   |]""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(elements), _root_.org.sireum.String(",\n")))
    };
    object Parser {
      @pure def create(input: String): Parser = return Parser(input, _root_.org.sireum.Z(0), None());
      def apply(input: String, offset: Z, errorOpt: Option[ErrorMsg]): Parser = new Parser(_root_.org.sireum.helper.$assign(input), _root_.org.sireum.helper.$assign(offset), _root_.org.sireum.helper.$assign(errorOpt));
      def unapply(o: Parser): _root_.scala.Option[scala.Tuple3[String, Z, Option[ErrorMsg]]] = _root_.scala.Some(scala.Tuple3(_root_.org.sireum.helper.clone(o.input), _root_.org.sireum.helper.clone(o.offset), _root_.org.sireum.helper.clone(o.errorOpt)))
    };
    @record class Parser(_input: String, var _offset: Z, var _errorOpt: Option[ErrorMsg]) extends _root_.org.sireum.RecordSig {
      val typesOption: ISZ[String] = _root_.org.sireum.helper.$assign(ISZ(_root_.org.sireum.String("Some"), _root_.org.sireum.String("None")));
      def errorMessage: String = _root_.org.sireum.helper.$tmatch(errorOpt) match {
        case Some((e @ _)) => return StringContext("[", ", ", "] ", "").s(e.line, e.column, e.message)
        case _ => return _root_.org.sireum.String("")
      };
      def eof(): B = if (input.size.!=(offset))
        {
          if (errorOpt.nonEmpty)
            return F
          else
            ();
          val p = _root_.org.sireum.helper.$assign(computeLineColumn(offset));
          errorOpt = _root_.org.sireum.helper.$assign(Some(ErrorMsg(p._1, p._2, StringContext("Expected end-of-file, but \'", "\' found.").s(input.at(offset)))));
          return F
        }
      else
        return T;
      def parseB(): B = {
        errorIfEof(offset);
        _root_.org.sireum.helper.$tmatch(at(offset).native) match {
          case 't' => {
            parseConstant(_root_.org.sireum.String("true"));
            return T
          }
          case 'f' => {
            parseConstant(_root_.org.sireum.String("false"));
            return F
          }
          case (c @ _) => {
            parseException(offset, StringContext("Expected \'true\' or \'false\', but \'", "...\' found.").s(c));
            return F
          }
        }
      };
      def parseC(): C = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseString().toCis);
        if (s.size.!=(_root_.org.sireum.Z(1)))
          {
            parseException(i, StringContext("Expected a C, but \'", "\' found.").s(s));
            return _root_.org.sireum.C(' ')
          }
        else
          return s(_root_.org.sireum.Z(0))
      };
      def parseZ(): Z = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(Z(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a Z, but \'", "\' found.").s(s));
            return _root_.org.sireum.Z(0)
          }
        }
      };
      def parseZ8(): Z8 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(Z8(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a Z8, but \'", "\' found.").s(s));
            return Z8(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseZ16(): Z16 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(Z16(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a Z16, but \'", "\' found.").s(s));
            return Z16(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseZ32(): Z32 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(Z32(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a Z32, but \'", "\' found.").s(s));
            return Z32(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseZ64(): Z64 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(Z64(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a Z64, but \'", "\' found.").s(s));
            return Z64(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseN(): N = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(N(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a N, but \'", "\' found.").s(s));
            return N(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseN8(): N8 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(N8(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a N8, but \'", "\' found.").s(s));
            return N8(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseN16(): N16 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(N16(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a N16, but \'", "\' found.").s(s));
            return N16(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseN32(): N32 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(N32(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a N32, but \'", "\' found.").s(s));
            return N32(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseN64(): N64 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(N64(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a N64, but \'", "\' found.").s(s));
            return N64(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseS8(): S8 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(S8(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a S8, but \'", "\' found.").s(s));
            return S8(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseS16(): S16 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(S16(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a S16, but \'", "\' found.").s(s));
            return S16(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseS32(): S32 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(S32(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a S32, but \'", "\' found.").s(s));
            return S32(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseS64(): S64 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(S64(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a S64, but \'", "\' found.").s(s));
            return S64(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseU8(): U8 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(U8(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a U8, but \'", "\' found.").s(s));
            return U8(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseU16(): U16 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(U16(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a U16, but \'", "\' found.").s(s));
            return U16(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseU32(): U32 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(U32(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a U32, but \'", "\' found.").s(s));
            return U32(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseU64(): U64 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(U64(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a U64, but \'", "\' found.").s(s));
            return U64(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseF32(): F32 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(F32(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a F32, but \'", "\' found.").s(s));
            return _root_.org.sireum.F32(0.0F)
          }
        }
      };
      def parseF64(): F64 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(F64(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a F64, but \'", "\' found.").s(s));
            return _root_.org.sireum.F64(0.0)
          }
        }
      };
      def parseR(): R = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(R(s)) match {
          case Some((n @ _)) => return n
          case _ => {
            parseException(i, StringContext("Expected a R, but \'", "\' found.").s(s));
            return R(_root_.org.sireum.Z(0))
          }
        }
      };
      def parseISZ[T](f: _root_.scala.Function0[T]): IS[Z, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[Z, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseISZ8[T](f: _root_.scala.Function0[T]): IS[Z8, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS[Z8, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[Z8, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseISZ16[T](f: _root_.scala.Function0[T]): IS[Z16, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS[Z16, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[Z16, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseISZ32[T](f: _root_.scala.Function0[T]): IS[Z32, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS[Z32, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[Z32, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseISZ64[T](f: _root_.scala.Function0[T]): IS[Z64, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS[Z64, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[Z64, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseISN[T](f: _root_.scala.Function0[T]): IS[N, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS[N, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[N, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseISN8[T](f: _root_.scala.Function0[T]): IS[N8, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS[N8, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[N8, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseISN16[T](f: _root_.scala.Function0[T]): IS[N16, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS[N16, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[N16, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseISN32[T](f: _root_.scala.Function0[T]): IS[N32, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS[N32, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[N32, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseISN64[T](f: _root_.scala.Function0[T]): IS[N64, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS[N64, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[N64, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseISS8[T](f: _root_.scala.Function0[T]): IS[S8, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS[S8, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[S8, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseISS16[T](f: _root_.scala.Function0[T]): IS[S16, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS[S16, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[S16, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseISS32[T](f: _root_.scala.Function0[T]): IS[S32, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS[S32, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[S32, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseISS64[T](f: _root_.scala.Function0[T]): IS[S64, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS[S64, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[S64, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseISU8[T](f: _root_.scala.Function0[T]): IS[U8, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS[U8, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[U8, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseISU16[T](f: _root_.scala.Function0[T]): IS[U16, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS[U16, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[U16, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseISU32[T](f: _root_.scala.Function0[T]): IS[U32, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS[U32, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[U32, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseISU64[T](f: _root_.scala.Function0[T]): IS[U64, T] = {
        if (parseArrayBegin().`unary_!`)
          return IS[U64, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[U64, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSZ[T](f: _root_.scala.Function0[T]): MS[Z, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[Z, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[Z, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSZ8[T](f: _root_.scala.Function0[T]): MS[Z8, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[Z8, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[Z8, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSZ16[T](f: _root_.scala.Function0[T]): MS[Z16, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[Z16, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[Z16, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSZ32[T](f: _root_.scala.Function0[T]): MS[Z32, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[Z32, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[Z32, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSZ64[T](f: _root_.scala.Function0[T]): MS[Z64, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[Z64, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[Z64, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSN[T](f: _root_.scala.Function0[T]): MS[N, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[N, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[N, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSN8[T](f: _root_.scala.Function0[T]): MS[N8, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[N8, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[N8, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSN16[T](f: _root_.scala.Function0[T]): MS[N16, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[N16, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[N16, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSN32[T](f: _root_.scala.Function0[T]): MS[N32, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[N32, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[N32, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSN64[T](f: _root_.scala.Function0[T]): MS[N64, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[N64, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[N64, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSS8[T](f: _root_.scala.Function0[T]): MS[S8, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[S8, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[S8, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSS16[T](f: _root_.scala.Function0[T]): MS[S16, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[S16, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[S16, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSS32[T](f: _root_.scala.Function0[T]): MS[S32, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[S32, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[S32, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSS64[T](f: _root_.scala.Function0[T]): MS[S64, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[S64, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[S64, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSU8[T](f: _root_.scala.Function0[T]): MS[U8, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[U8, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[U8, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSU16[T](f: _root_.scala.Function0[T]): MS[U16, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[U16, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[U16, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSU32[T](f: _root_.scala.Function0[T]): MS[U32, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[U32, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[U32, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseMSU64[T](f: _root_.scala.Function0[T]): MS[U64, T] = {
        if (parseArrayBegin().`unary_!`)
          return MS[U64, T]()
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[U64, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return r
      };
      def parseOption[T](f: _root_.scala.Function0[T]): Option[T] = {
        val tpe = _root_.org.sireum.helper.$assign(parseObjectTypes(typesOption));
        _root_.org.sireum.helper.$tmatch(tpe.native) match {
          case "Some" => {
            parseObjectKey(_root_.org.sireum.String("value"));
            val v = _root_.org.sireum.helper.$assign(f());
            parseObjectNext();
            return Some(v)
          }
          case "None" => return None()
        }
      };
      def parseMOption[T](f: _root_.scala.Function0[T]): MOption[T] = {
        val tpe = _root_.org.sireum.helper.$assign(parseObjectTypes(typesOption));
        _root_.org.sireum.helper.$tmatch(tpe.native) match {
          case "Some" => {
            parseObjectKey(_root_.org.sireum.String("value"));
            val v = _root_.org.sireum.helper.$assign(f());
            parseObjectNext();
            return MSome(v)
          }
          case "None" => return MNone()
        }
      };
      def parseEither[L, R](f0: _root_.scala.Function0[L], f1: _root_.scala.Function0[R]): Either[L, R] = {
        parseObjectType(_root_.org.sireum.String("Or"));
        parseObjectKey(_root_.org.sireum.String("i"));
        val i = _root_.org.sireum.helper.$assign(parseZ());
        parseObjectKey(_root_.org.sireum.String("value"));
        _root_.org.sireum.helper.$tmatch(i) match {
          case StringContext("0").z() => {
            val l = _root_.org.sireum.helper.$assign(f0());
            parseObjectNext();
            return Either(Some(l), None())
          }
          case StringContext("1").z() => {
            val r = _root_.org.sireum.helper.$assign(f1());
            parseObjectNext();
            return Either(None(), Some(r))
          }
        }
      };
      def parseMEither[L, R](f0: _root_.scala.Function0[L], f1: _root_.scala.Function0[R]): MEither[L, R] = {
        parseObjectType(_root_.org.sireum.String("Or"));
        parseObjectKey(_root_.org.sireum.String("i"));
        val i = _root_.org.sireum.helper.$assign(parseZ());
        parseObjectKey(_root_.org.sireum.String("value"));
        _root_.org.sireum.helper.$tmatch(i) match {
          case StringContext("0").z() => {
            val l = _root_.org.sireum.helper.$assign(f0());
            parseObjectNext();
            return MEither(MSome(l), MNone())
          }
          case StringContext("1").z() => {
            val r = _root_.org.sireum.helper.$assign(f1());
            parseObjectNext();
            return MEither(MNone(), MSome(r))
          }
        }
      };
      def at(i: Z): C = {
        if (_root_.org.sireum.Z(0).<=(i).&&(i.<(input.size)).&&(errorOpt.isEmpty))
          return input.at(i)
        else
          ();
        return _root_.org.sireum.C('\u0000')
      };
      def detect(): ValueKind.Type = {
        parseWhitespace();
        errorIfEof(offset);
        _root_.org.sireum.helper.$tmatch(at(offset).native) match {
          case '\"' => return ValueKind.String
          case '{' => return ValueKind.Object
          case '[' => return ValueKind.Array
          case 't' => return ValueKind.True
          case 'f' => return ValueKind.False
          case 'n' => return ValueKind.Null
          case '-' => return ValueKind.Number
          case '0' => return ValueKind.Number
          case '1' => return ValueKind.Number
          case '2' => return ValueKind.Number
          case '3' => return ValueKind.Number
          case '4' => return ValueKind.Number
          case '5' => return ValueKind.Number
          case '6' => return ValueKind.Number
          case '7' => return ValueKind.Number
          case '8' => return ValueKind.Number
          case '9' => return ValueKind.Number
          case _ => {
            parseException(offset, _root_.org.sireum.String("Unexpected end-of-file."));
            return ValueKind.Null
          }
        }
      };
      def parseObjectType(expectedType: String): String = {
        parseObjectBegin();
        parseObjectKey(_root_.org.sireum.String("type"));
        val i = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
        val value = _root_.org.sireum.helper.$assign(parseString());
        parseObjectNext();
        if (value.!=(expectedType))
          parseException(i, StringContext("Expected \'", "\', but \'", "\' found.").s(expectedType, value))
        else
          ();
        return value
      };
      def parseObjectTypes(expectedTypes: ISZ[String]): String = {
        parseObjectBegin();
        parseObjectKey(_root_.org.sireum.String("type"));
        val i = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
        val value = _root_.org.sireum.helper.$assign(parseString());
        parseObjectNext();
        if (expectedTypes.nonEmpty.&&(ISZOps(expectedTypes).contains(value).`unary_!`))
          _root_.org.sireum.helper.$tmatch(expectedTypes.size) match {
            case StringContext("1").z() => parseException(i, StringContext("Expected \'", "\', but \'", "\' found.").s(expectedTypes(_root_.org.sireum.Z(0)), value))
            case StringContext("2").z() => parseException(i, StringContext("Expected \'", "\' or \'", "\' , but \'", "\' found.").s(expectedTypes(_root_.org.sireum.Z(0)), expectedTypes(_root_.org.sireum.Z(1)), value))
            case _ => parseException(i, StringContext("Expected ", " , but \'", "\' found.").s(StringContext("\'", "\', or \'", "\'").st(scala.Tuple2(_root_.org.sireum.helper.$assign(ISZOps(expectedTypes).dropRight(_root_.org.sireum.Z(1))), _root_.org.sireum.String("\', \'")), expectedTypes(expectedTypes.size.-(_root_.org.sireum.Z(1)))).render, value))
          }
        else
          ();
        return value
      };
      def parseObjectKey(expectedKey: String): String = {
        errorIfEof(offset);
        val i = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
        val key = _root_.org.sireum.helper.$assign(parseString());
        if (key.!=(expectedKey))
          parseException(i, StringContext("Expected \'", "\', but \'", "\' found.").s(expectedKey, key))
        else
          ();
        parseWhitespace();
        errorIfEof(offset);
        _root_.org.sireum.helper.$tmatch(at(offset).native) match {
          case ':' => {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            parseWhitespace();
            return key
          }
          case (c @ _) => {
            parseException(offset, StringContext("Expected \':\', but \'", "\' found.").s(c));
            return _root_.org.sireum.String("")
          }
        }
      };
      def parseObjectKeys(expectedKeys: ISZ[String]): String = {
        errorIfEof(offset);
        val i = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
        val key = _root_.org.sireum.helper.$assign(parseString());
        if (expectedKeys.nonEmpty.&&(ISZOps(expectedKeys).contains(key).`unary_!`))
          _root_.org.sireum.helper.$tmatch(expectedKeys.size) match {
            case StringContext("1").z() => parseException(i, StringContext("Expected \'", "\', but \'", "\' found.").s(expectedKeys(_root_.org.sireum.Z(0)), key))
            case StringContext("2").z() => parseException(i, StringContext("Expected \'", "\' or \'", "\' , but \'", "\' found.").s(expectedKeys(_root_.org.sireum.Z(0)), expectedKeys(_root_.org.sireum.Z(1)), key))
            case _ => parseException(i, StringContext("Expected ", " , but \'", "\' found.").s(StringContext("\'", "\', or \'", "\'").st(scala.Tuple2(_root_.org.sireum.helper.$assign(ISZOps(expectedKeys).dropRight(_root_.org.sireum.Z(1))), _root_.org.sireum.String("\', \'")), expectedKeys(expectedKeys.size.-(_root_.org.sireum.Z(1)))).render, key))
          }
        else
          ();
        parseWhitespace();
        errorIfEof(offset);
        _root_.org.sireum.helper.$tmatch(at(offset).native) match {
          case ':' => {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            parseWhitespace();
            return key
          }
          case (c @ _) => {
            parseException(offset, StringContext("Expected \':\', but \'", "\' found.").s(c));
            return _root_.org.sireum.String("")
          }
        }
      };
      def parseObjectBegin(): Boolean = {
        errorIfEof(offset);
        _root_.org.sireum.helper.$tmatch(at(offset).native) match {
          case '{' => {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            parseWhitespace();
            errorIfEof(offset);
            (_root_.org.sireum.helper.$tmatch(at(offset).native) match {
              case '}' => {
                offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
                return F
              }
              case _ => return T
            })
          }
          case (c @ _) => {
            parseException(offset, StringContext("Expected \'{\', but \'", "\' found.").s(c));
            return F
          }
        }
      };
      def parseObjectNext(): Boolean = {
        parseWhitespace();
        errorIfEof(offset);
        _root_.org.sireum.helper.$tmatch(at(offset).native) match {
          case ',' => {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            parseWhitespace();
            return T
          }
          case '}' => {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            parseWhitespace();
            return F
          }
          case (c @ _) => {
            parseException(offset, StringContext("Expected \',\' or \'}\', but \'", "\' found.").s(c));
            return F
          }
        }
      };
      def parseArrayBegin(): Boolean = {
        errorIfEof(offset);
        _root_.org.sireum.helper.$tmatch(at(offset).native) match {
          case '[' => {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            parseWhitespace();
            errorIfEof(offset);
            (_root_.org.sireum.helper.$tmatch(at(offset).native) match {
              case ']' => {
                offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
                return F
              }
              case _ => return T
            })
          }
          case (c @ _) => {
            parseException(offset, StringContext("Expected \'[\', but \'", "\' found.").s(c));
            return F
          }
        }
      };
      def parseArrayNext(): Boolean = {
        parseWhitespace();
        errorIfEof(offset);
        _root_.org.sireum.helper.$tmatch(at(offset).native) match {
          case ',' => {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            parseWhitespace();
            return T
          }
          case ']' => {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            parseWhitespace();
            return F
          }
          case (c @ _) => {
            parseException(offset, StringContext("Expected \',\' or \']\', but \'", "\' found.").s(c));
            return F
          }
        }
      };
      def parseNumber(): String = {
        var r = _root_.org.sireum.helper.$assign(ISZ[C]());
        errorIfEof(offset);
        var c = _root_.org.sireum.helper.$assign(at(offset));
        _root_.org.sireum.helper.$tmatch(c.native) match {
          case '-' => {
            r = _root_.org.sireum.helper.$assign(r.:+(c));
            c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)))
          }
          case _ => if (isDigit(c).`unary_!`)
            parseException(offset, StringContext("Expected a \'-\' or a digit but \'", "\' found.").s(c))
          else
            ()
        };
        _root_.org.sireum.helper.$tmatch(c.native) match {
          case '0' => {
            r = _root_.org.sireum.helper.$assign(r.:+(c));
            if (offset.+(_root_.org.sireum.Z(1)).==(input.size))
              {
                offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
                return String(r)
              }
            else
              ();
            c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)))
          }
          case _ => {
            r = _root_.org.sireum.helper.$assign(r.:+(c));
            if (offset.+(_root_.org.sireum.Z(1)).==(input.size))
              {
                offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
                return String(r)
              }
            else
              ();
            c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)));
            while (isDigit(c)) 
              {
                r = _root_.org.sireum.helper.$assign(r.:+(c));
                if (offset.+(_root_.org.sireum.Z(1)).==(input.size))
                  {
                    offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
                    return String(r)
                  }
                else
                  ();
                c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)))
              }
            
          }
        };
        _root_.org.sireum.helper.$tmatch(c.native) match {
          case '.' => {
            r = _root_.org.sireum.helper.$assign(r.:+(c));
            c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)));
            while (isDigit(c)) 
              {
                r = _root_.org.sireum.helper.$assign(r.:+(c));
                if (offset.+(_root_.org.sireum.Z(1)).==(input.size))
                  {
                    offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
                    return String(r)
                  }
                else
                  ();
                c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)))
              }
            
          }
          case _ => ()
        };
        _root_.org.sireum.helper.$tmatch(c.native) match {
          case 'e' => ()
          case 'E' => ()
          case _ => return String(r)
        };
        r = _root_.org.sireum.helper.$assign(r.:+(c));
        c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)));
        val hasPlusMinus: B = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(c.native) match {
          case '+' => T
          case '-' => T
          case _ => F
        });
        if (hasPlusMinus)
          {
            r = _root_.org.sireum.helper.$assign(r.:+(c));
            c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)))
          }
        else
          ();
        while (isDigit(c)) 
          {
            r = _root_.org.sireum.helper.$assign(r.:+(c));
            if (offset.+(_root_.org.sireum.Z(1)).==(input.size))
              {
                offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
                return String(r)
              }
            else
              ();
            c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)))
          }
        ;
        return String(r)
      };
      def parseString(): String = {
        errorIfEof(offset);
        var r = _root_.org.sireum.helper.$assign(ISZ[C]());
        var c = _root_.org.sireum.helper.$assign(at(offset));
        _root_.org.sireum.helper.$tmatch(c.native) match {
          case '\"' => {
            c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)));
            while (c.!=(_root_.org.sireum.C('\"'))) 
              {
                (_root_.org.sireum.helper.$tmatch(c.native) match {
                  case '\\' => {
                    c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)));
                    (_root_.org.sireum.helper.$tmatch(c.native) match {
                      case '\"' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\"')))
                      case '\\' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')))
                      case '/' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('/')))
                      case 'b' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\b')))
                      case 'f' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\f')))
                      case 'n' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\n')))
                      case 'r' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\r')))
                      case 't' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\t')))
                      case 'u' => {
                        incOffset(_root_.org.sireum.Z(4));
                        val hex = _root_.org.sireum.helper.$assign(slice(offset.-(_root_.org.sireum.Z(3)), offset.+(_root_.org.sireum.Z(1))));
                        (_root_.org.sireum.helper.$tmatch(COps.fromUnicodeHex(hex)) match {
                          case Some((ch @ _)) => r = _root_.org.sireum.helper.$assign(r.:+(ch))
                          case _ => parseException(offset.-(_root_.org.sireum.Z(3)), StringContext("Expected a character hex but \'", "\' found.").s(hex))
                        })
                      }
                      case _ => parseException(offset, StringContext("Expected an escaped character but \'", "\' found.").s(c))
                    })
                  }
                  case _ => r = _root_.org.sireum.helper.$assign(r.:+(c))
                });
                c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)))
              }
            ;
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            return String(r)
          }
          case _ => {
            parseException(offset, StringContext("Expected \'\"\' but \'", "\' found.").s(c));
            return _root_.org.sireum.String("")
          }
        }
      };
      def parseConstant(text: String): Unit = {
        errorIfEof(offset.+(text.size).-(_root_.org.sireum.Z(1)));
        val t = _root_.org.sireum.helper.$assign(String(slice(offset, offset.+(text.size))));
        if (t.!=(text))
          parseException(offset, StringContext("Expected \'", "\', but \'", "\' found.").s(text, t))
        else
          ();
        offset = _root_.org.sireum.helper.$assign(offset.+(text.size));
        _root_.org.sireum.helper.$tmatch(text.native) match {
          case "true" => ()
          case "false" => ()
          case "null" => ()
          case _ => parseException(offset, StringContext("Invalid constant value \'", "\'.").s(text))
        }
      };
      def computeLineColumn(i: Z): scala.Tuple2[Z, Z] = {
        var line: Z = _root_.org.sireum.Z(1);
        var column: Z = _root_.org.sireum.Z(1);
        var j: Z = _root_.org.sireum.Z(0);
        while (j.!=(i)) 
          {
            _root_.org.sireum.helper.$tmatch(at(j).native) match {
              case '\n' => {
                line = _root_.org.sireum.helper.$assign(line.+(_root_.org.sireum.Z(1)));
                column = _root_.org.sireum.Z(1)
              }
              case _ => column = _root_.org.sireum.helper.$assign(column.+(_root_.org.sireum.Z(1)))
            };
            j = _root_.org.sireum.helper.$assign(j.+(_root_.org.sireum.Z(1)))
          }
        ;
        return scala.Tuple2(_root_.org.sireum.helper.$assign(line), _root_.org.sireum.helper.$assign(column))
      };
      def parseException(i: Z, msg: String): Unit = {
        if (errorOpt.nonEmpty)
          return ()
        else
          ();
        val p = _root_.org.sireum.helper.$assign(computeLineColumn(i));
        errorOpt = _root_.org.sireum.helper.$assign(Some(ErrorMsg(p._1, p._2, msg)))
      };
      def errorIfEof(i: Z): Unit = if (i.>=(input.size).||(errorOpt.nonEmpty))
        parseException(offset, _root_.org.sireum.String("Unexpected end-of-file."))
      else
        ();
      def incOffset(n: Z): C = {
        offset = _root_.org.sireum.helper.$assign(offset.+(n));
        errorIfEof(offset);
        return at(offset)
      };
      def parseWhitespace(): Unit = {
        if (errorOpt.nonEmpty)
          {
            offset = _root_.org.sireum.helper.$assign(input.size);
            return ()
          }
        else
          ();
        if (offset.>=(input.size))
          return ()
        else
          ();
        var c = _root_.org.sireum.helper.$assign(at(offset));
        while (isWhitespace(c)) 
          {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            if (offset.>=(input.size))
              return ()
            else
              ();
            c = _root_.org.sireum.helper.$assign(at(offset))
          }
        
      };
      @pure def isDigit(c: C): B = _root_.org.sireum.helper.$tmatch(c.native) match {
        case '0' => return T
        case '1' => return T
        case '2' => return T
        case '3' => return T
        case '4' => return T
        case '5' => return T
        case '6' => return T
        case '7' => return T
        case '8' => return T
        case '9' => return T
        case _ => return F
      };
      @pure def isWhitespace(c: C): B = _root_.org.sireum.helper.$tmatch(c.native) match {
        case ' ' => return T
        case '\n' => return T
        case '\r' => return T
        case '\t' => return T
        case _ => return F
      };
      @pure def slice(start: Z, til: Z): ISZ[C] = {
        var r = _root_.org.sireum.helper.$assign(ISZ[C]());
        start.until(til).foreach(((i) => r = _root_.org.sireum.helper.$assign(r.:+(at(i)))));
        return r
      };
      private var dirty: _root_.scala.Boolean = true;
      def input = _input;
      def offset = _offset;
      def `offset_=`(offset: Z): this.type = {
        dirty = true;
        _offset = offset;
        this
      };
      def errorOpt = _errorOpt;
      def `errorOpt_=`(errorOpt: Option[ErrorMsg]): this.type = {
        dirty = true;
        _errorOpt = errorOpt;
        this
      };
      private var _hashCode: _root_.scala.Int = _;
      private def computeHashCode: _root_.scala.Int = _root_.scala.Seq(this.getClass, input, offset, errorOpt).hashCode;
      override def toString: _root_.java.lang.String = {
        val sb = new _root_.java.lang.StringBuilder();
        sb.append("Parser");
        sb.append('(');
        sb.append(_root_.org.sireum.String.escape(input));
        sb.append(", ");
        sb.append(_root_.org.sireum.String.escape(offset));
        sb.append(", ");
        sb.append(_root_.org.sireum.String.escape(errorOpt));
        sb.append(')');
        sb.toString
      };
      override def string: _root_.org.sireum.String = toString;
      override def hashCode: _root_.scala.Int = {
        if (dirty)
          {
            dirty = false;
            _hashCode = computeHashCode
          }
        else
          ();
        _hashCode
      };
      override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): Parser)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            input.==(o.input).&&(offset.==(o.offset)).&&(errorOpt.==(o.errorOpt))
          case _ => false
        };
      def apply(input: String = this.input, offset: Z = this.offset, errorOpt: Option[ErrorMsg] = this.errorOpt): Parser = new Parser(_root_.org.sireum.helper.$assign(input), _root_.org.sireum.helper.$assign(offset), _root_.org.sireum.helper.$assign(errorOpt));
      override lazy val content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Parser")), scala.Tuple2("input", input), scala.Tuple2("offset", offset), scala.Tuple2("errorOpt", errorOpt));
      override def $clone: Parser = {
        val r: Parser = new Parser(_root_.org.sireum.helper.cloneAssign(input), _root_.org.sireum.helper.cloneAssign(offset), _root_.org.sireum.helper.cloneAssign(errorOpt));
        r
      }
    };
    def parseAst[V](binding: JsonAstBinding[V], input: String): Either[V, ErrorMsg] = {
      val parser = _root_.org.sireum.helper.$assign(Parser.create(input));
      val emptyKeys = _root_.org.sireum.helper.$assign(ISZ[String]());
      def parseString(): V = {
        val s = _root_.org.sireum.helper.$assign(parser.parseString());
        return binding.toString(s)
      };
      def parseNumber(): V = {
        val n = _root_.org.sireum.helper.$assign(parser.parseNumber());
        return binding.toNumber(n)
      };
      def parseTrue(): V = {
        parser.parseConstant(_root_.org.sireum.String("true"));
        return binding.toBoolean(T)
      };
      def parseFalse(): V = {
        parser.parseConstant(_root_.org.sireum.String("false"));
        return binding.toBoolean(F)
      };
      def parseNull(): V = {
        parser.parseConstant(_root_.org.sireum.String("null"));
        return binding.toNull
      };
      def parseArray(): V = {
        var continue = _root_.org.sireum.helper.$assign(parser.parseArrayBegin());
        if (continue.`unary_!`)
          return binding.toArray(ISZ())
        else
          ();
        var v = _root_.org.sireum.helper.$assign(parseValue());
        var values = _root_.org.sireum.helper.$assign(ISZ[V](v));
        continue = _root_.org.sireum.helper.$assign(parser.parseArrayNext());
        while (continue) 
          {
            v = _root_.org.sireum.helper.$assign(parseValue());
            values = _root_.org.sireum.helper.$assign(values.:+(v));
            continue = _root_.org.sireum.helper.$assign(parser.parseArrayNext())
          }
        ;
        return binding.toArray(values)
      };
      def parseObject(): V = {
        var continue = _root_.org.sireum.helper.$assign(parser.parseObjectBegin());
        if (continue.`unary_!`)
          return binding.toObject(ISZ())
        else
          ();
        var key = _root_.org.sireum.helper.$assign(parser.parseObjectKeys(emptyKeys));
        var value = _root_.org.sireum.helper.$assign(parseValue());
        var fields = _root_.org.sireum.helper.$assign(ISZ[scala.Tuple2[String, V]](scala.Tuple2(_root_.org.sireum.helper.$assign(key), _root_.org.sireum.helper.$assign(value))));
        continue = _root_.org.sireum.helper.$assign(parser.parseObjectNext());
        while (continue) 
          {
            key = _root_.org.sireum.helper.$assign(parser.parseObjectKeys(emptyKeys));
            value = _root_.org.sireum.helper.$assign(parseValue());
            fields = _root_.org.sireum.helper.$assign(fields.:+(scala.Tuple2(_root_.org.sireum.helper.$assign(key), _root_.org.sireum.helper.$assign(value))));
            continue = _root_.org.sireum.helper.$assign(parser.parseObjectNext())
          }
        ;
        return binding.toObject(fields)
      };
      def parseValue(): V = {
        val k = _root_.org.sireum.helper.$assign(parser.detect());
        _root_.org.sireum.helper.$tmatch(k) match {
          case ValueKind.String => {
            val r = _root_.org.sireum.helper.$assign(parseString());
            return r
          }
          case ValueKind.Object => {
            val r = _root_.org.sireum.helper.$assign(parseObject());
            return r
          }
          case ValueKind.Array => {
            val r = _root_.org.sireum.helper.$assign(parseArray());
            return r
          }
          case ValueKind.True => {
            val r = _root_.org.sireum.helper.$assign(parseTrue());
            return r
          }
          case ValueKind.False => {
            val r = _root_.org.sireum.helper.$assign(parseFalse());
            return r
          }
          case ValueKind.Null => {
            val r = _root_.org.sireum.helper.$assign(parseNull());
            return r
          }
          case ValueKind.Number => {
            val r = _root_.org.sireum.helper.$assign(parseNumber());
            return r
          }
        }
      };
      val r = _root_.org.sireum.helper.$assign(parseValue());
      parser.eof();
      _root_.org.sireum.helper.$tmatch(parser.errorOpt) match {
        case Some(_) => return Either(None(), parser.errorOpt)
        case _ => return Either(Some(r), None())
      }
    };
    def printAst[V](binding: JsonAstBinding[V], v: V): ST = {
      @pure def isSimple(o: V): B = _root_.org.sireum.helper.$tmatch(binding.kind(o)) match {
        case ValueKind.Object => return F
        case ValueKind.Array => return F
        case _ => return T
      };
      @pure def printValue(o: V): ST = _root_.org.sireum.helper.$tmatch(binding.kind(o)) match {
        case ValueKind.String => return Printer.printString(binding.fromString(o))
        case ValueKind.Number => return Printer.printNumber(binding.fromNumber(o))
        case ValueKind.Object => return Printer.printObject(binding.fromObject(o).map(((p) => scala.Tuple2(_root_.org.sireum.helper.$assign(p._1), _root_.org.sireum.helper.$assign(printValue(p._2))))))
        case ValueKind.Array => {
          val es = _root_.org.sireum.helper.$assign(binding.fromArray(o));
          return Printer.printIS(ISZOps(es).forall(isSimple), es.map(printValue))
        }
        case ValueKind.True => return Printer.trueSt
        case ValueKind.False => return Printer.falseSt
        case ValueKind.Null => return Printer.nullSt
      };
      return printValue(v)
    }
  }
}