package org.sireum {
  object Map {
    @pure def empty[K, V]: Map[K, V] = return Map[K, V](ISZ[scala.Tuple2[K, V]]());
    def apply[K, V](entries: ISZ[scala.Tuple2[K, V]]): Map[K, V] = new Map(entries);
    def unapply[K, V](o: Map[K, V]): _root_.scala.Option[ISZ[scala.Tuple2[K, V]]] = _root_.scala.Some(o.entries)
  }

  @datatype class Map[K, V](_entries: ISZ[scala.Tuple2[K, V]]) extends _root_.org.sireum.DatatypeSig {
    @pure override def hash: Z = return entries.size;
    @pure def keys: ISZ[K] = {
      var r = _root_.org.sireum.helper.$assign(ISZ[K]());
      entries.foreach(((kv) => r = _root_.org.sireum.helper.$assign(r.:+(kv._1))));
      return r
    };
    @pure def values: ISZ[V] = {
      var r = _root_.org.sireum.helper.$assign(ISZ[V]());
      entries.foreach(((kv) => r = _root_.org.sireum.helper.$assign(r.:+(kv._2))));
      return r
    };
    @pure def keySet: Set[K] = return Set.empty[K].addAll(keys);
    @pure def valueSet: Set[V] = return Set.empty[V].addAll(values);
    @pure def put(key: K, value: V): Map[K, V] = {
      val index = _root_.org.sireum.helper.$assign(indexOf(key));
      val newEntries: ISZ[scala.Tuple2[K, V]] = _root_.org.sireum.helper.$assign(if (index.<(_root_.org.sireum.Z(0)))
        entries.:+(scala.Tuple2(_root_.org.sireum.helper.$assign(key), _root_.org.sireum.helper.$assign(value)))
      else
        entries(scala.Tuple2(_root_.org.sireum.helper.$assign(index), _root_.org.sireum.helper.$assign(scala.Tuple2(_root_.org.sireum.helper.$assign(key), _root_.org.sireum.helper.$assign(value))))));
      return Map(newEntries)
    };
    @pure def get(key: K): Option[V] = {
      val index = _root_.org.sireum.helper.$assign(indexOf(key));
      return if (index.<(_root_.org.sireum.Z(0)))
        None[V]()
      else
        Some(entries(index)._2)
    };
    @pure def entry(key: K): Option[scala.Tuple2[K, V]] = {
      val index = _root_.org.sireum.helper.$assign(indexOf(key));
      return if (index.<(_root_.org.sireum.Z(0)))
        None[scala.Tuple2[K, V]]()
      else
        Some(entries(index))
    };
    @pure def indexOf(key: K): Z = {
      var index = StringContext("-1").z();
      entries.indices.withFilter(((i) => index.==(StringContext("-1").z()))).foreach(((i) => if (entries(i)._1.==(key))
        index = _root_.org.sireum.helper.$assign(i)
      else
        ()));
      return index
    };
    @pure def removeAll(keys: ISZ[K]): Map[K, V] = {
      var deletedMappings = _root_.org.sireum.helper.$assign(ISZ[scala.Tuple2[K, V]]());
      keys.foreach(((key) => _root_.org.sireum.helper.$tmatch(get(key)) match {
        case Some((value @ _)) => deletedMappings = _root_.org.sireum.helper.$assign(deletedMappings.:+(scala.Tuple2(_root_.org.sireum.helper.$assign(key), _root_.org.sireum.helper.$assign(value))))
        case _ => ()
      }));
      if (deletedMappings.nonEmpty)
        return Map(entries.--(deletedMappings))
      else
        return this
    };
    @pure def remove(key: K, value: V): Map[K, V] = return Map(entries.-(scala.Tuple2(_root_.org.sireum.helper.$assign(key), _root_.org.sireum.helper.$assign(value))));
    @pure def isEqual(other: Map[K, V]): B = {
      if (size.!=(other.size))
        return F
      else
        ();
      var seen = _root_.org.sireum.helper.$assign(Set.empty[K]);
      entries.foreach(((kv) => {
        val k = _root_.org.sireum.helper.$assign(kv._1);
        seen = _root_.org.sireum.helper.$assign(seen.add(k));
        _root_.org.sireum.helper.$tmatch(other.get(k)) match {
          case Some((v @ _)) => if (v.!=(kv._2))
            return F
          else
            ()
          case _ => return F
        }
      }));
      other.entries.foreach(((kv) => {
        val k = _root_.org.sireum.helper.$assign(kv._1);
        if (seen.contains(k).`unary_!`)
          _root_.org.sireum.helper.$tmatch(get(k)) match {
            case Some((v @ _)) => if (v.!=(kv._2))
              return F
            else
              ()
            case _ => return F
          }
        else
          ()
      }));
      return T
    };
    @pure def contains(key: K): B = return indexOf(key).>=(_root_.org.sireum.Z(0));
    @pure def isEmpty: B = return size.==(StringContext("0").z());
    @pure def nonEmpty: B = return size.!=(StringContext("0").z());
    @pure def size: Z = return entries.size;
    @pure def toHashMap: HashMap[K, V] = {
      var r = _root_.org.sireum.helper.$assign(HashMap.emptyInit[K, V](size));
      entries.foreach(((kv) => r = _root_.org.sireum.helper.$assign(r.put(kv._1, kv._2))));
      return r
    };
    @pure def toHashSMap: HashSMap[K, V] = {
      var r = _root_.org.sireum.helper.$assign(HashSMap.emptyInit[K, V](size));
      entries.foreach(((kv) => r = _root_.org.sireum.helper.$assign(r.put(kv._1, kv._2))));
      return r
    };
    def entries = _entries;
    override def toString: _root_.java.lang.String = {
      val sb = new _root_.java.lang.StringBuilder();
      sb.append("Map");
      sb.append('(');
      sb.append(_root_.org.sireum.String.escape(entries));
      sb.append(')');
      sb.toString
    };
    override def string: _root_.org.sireum.String = toString;
    override lazy val hashCode: _root_.scala.Int = hash.hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): Map[K, V] @unchecked)) => isEqual(o)
        case _ => false
      };
    def apply(entries: ISZ[scala.Tuple2[K, V]] = this.entries): Map[K, V] = new Map(entries);
    override lazy val content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Map")), scala.Tuple2("entries", entries))
  }
}