package org.sireum {
  @datatype trait Option[T] extends _root_.org.sireum.DatatypeSig {
    @pure def isEmpty: B;
    @pure def nonEmpty: B;
    @pure def map[T2](f: _root_.scala.Function1[T, T2]): Option[T2];
    @pure def flatMap[T2](f: _root_.scala.Function1[T, Option[T2]]): Option[T2];
    @pure def forall(f: _root_.scala.Function1[T, B]): B;
    @pure def exists(f: _root_.scala.Function1[T, B]): B;
    @pure def get: T;
    @pure def getOrElse(default: => T): T;
    def foreach(f: _root_.scala.Function1[T, Unit]): Unit
  }

  object None {
    private[this] val v: _root_.scala.AnyRef = new None[_root_.scala.Nothing]();
    def apply[T](): None[T] = v.asInstanceOf[None[T]];
    def unapply[T](o: None[T]): _root_.scala.Boolean = true
  }

  @datatype class None[T] extends Option[T] with _root_.org.sireum.DatatypeSig {
    @pure def isEmpty: B = {
      StringContext(" ensures  result ≡ T ").lUnit();
      return T
    };
    @pure def nonEmpty: B = {
      StringContext(" ensures  result ≡ F ").lUnit();
      return F
    };
    @pure def map[T2](f: _root_.scala.Function1[T, T2]): Option[T2] = {
      StringContext(" ensures  result ≡ None[T2]() ").lUnit();
      return None[T2]()
    };
    @pure def flatMap[T2](f: _root_.scala.Function1[T, Option[T2]]): Option[T2] = {
      StringContext(" ensures  result ≡ None[T2]() ").lUnit();
      return None[T2]()
    };
    @pure def forall(f: _root_.scala.Function1[T, B]): B = {
      StringContext(" ensures  result ≡ T ").lUnit();
      return T
    };
    @pure def exists(f: _root_.scala.Function1[T, B]): B = {
      StringContext(" ensures  result ≡ F ").lUnit();
      return F
    };
    @pure def getOrElse(default: => T): T = {
      StringContext(" ensures  result ≡ default ").lUnit();
      return default
    };
    @pure def get: T = {
      StringContext(" requires  F ").lUnit();
      halt(_root_.org.sireum.String("Invalid \'None\' operation \'get\'."))
    };
    def foreach(f: _root_.scala.Function1[T, Unit]): Unit = ();
    override def toString: _root_.java.lang.String = "None()";
    override def string: _root_.org.sireum.String = toString;
    override val hashCode: _root_.scala.Int = this.getClass.hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): None[T] @unchecked)) => true
        case _ => false
      };
    override lazy val content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "None")))
  }

  object Some {
    def apply[T](value: T): Some[T] = new Some(value);
    def unapply[T](o: Some[T]): _root_.scala.Option[T] = _root_.scala.Some(o.value)
  }

  @datatype class Some[T](_value: T) extends Option[T] with _root_.org.sireum.DatatypeSig {
    @pure def isEmpty: B = {
      StringContext(" ensures  result ≡ F ").lUnit();
      return F
    };
    @pure def nonEmpty: B = {
      StringContext(" ensures  result ≡ T ").lUnit();
      return T
    };
    @pure def map[T2](f: _root_.scala.Function1[T, T2]): Option[T2] = {
      StringContext(" ensures  result ≡ f(value) ").lUnit();
      return Some(f(value))
    };
    @pure def flatMap[T2](f: _root_.scala.Function1[T, Option[T2]]): Option[T2] = {
      StringContext(" ensures  result ≡ f(value) ").lUnit();
      return f(value)
    };
    @pure def forall(f: _root_.scala.Function1[T, B]): B = {
      StringContext(" ensures  result ≡ f(value) ").lUnit();
      return f(value)
    };
    @pure def exists(f: _root_.scala.Function1[T, B]): B = {
      StringContext(" ensures  result ≡ f(value) ").lUnit();
      return f(value)
    };
    @pure def getOrElse(default: => T): T = {
      StringContext(" ensures  result ≡ value ").lUnit();
      return value
    };
    @pure def get: T = {
      StringContext(" ensures  result ≡ value ").lUnit();
      return value
    };
    def foreach(f: _root_.scala.Function1[T, Unit]): Unit = {
      StringContext(""" reads    f_reads
         requires f_requires(value)
         modifies f_modifies
         ensures  f_ensures(value) """).lUnit();
      f(value)
    };
    def value = _value;
    override def toString: _root_.java.lang.String = {
      val sb = new _root_.java.lang.StringBuilder();
      sb.append("Some");
      sb.append('(');
      sb.append(_root_.org.sireum.String.escape(value));
      sb.append(')');
      sb.toString
    };
    override def string: _root_.org.sireum.String = toString;
    override lazy val hashCode: _root_.scala.Int = _root_.scala.Seq(this.getClass, value).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): Some[T] @unchecked)) => if (this.hashCode.!=(o.hashCode))
          false
        else
          value.==(o.value)
        case _ => false
      };
    def apply(value: T = this.value): Some[T] = new Some(value);
    override lazy val content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Some")), scala.Tuple2("value", value))
  }
}