package org.sireum {
  object Poset {
    @pure def empty[T]: Poset[T] = return Poset[T](HashMap.empty, HashMap.empty);
    def apply[T](parents: HashMap[T, HashSet[T]], children: HashMap[T, HashSet[T]]): Poset[T] = new Poset(parents, children);
    def unapply[T](o: Poset[T]): _root_.scala.Option[scala.Tuple2[HashMap[T, HashSet[T]], HashMap[T, HashSet[T]]]] = _root_.scala.Some(scala.Tuple2(o.parents, o.children))
  }

  @datatype class Poset[T](_parents: HashMap[T, HashSet[T]], _children: HashMap[T, HashSet[T]]) extends _root_.org.sireum.DatatypeSig {
    val emptySet: HashSet[T] = _root_.org.sireum.helper.$assign(HashSet.empty);
    @pure def isEqual(other: Poset[T]): B = {
      if (parents.isEqual(other.parents).`unary_!`)
        return F
      else
        ();
      if (children.isEqual(other.children).`unary_!`)
        return F
      else
        ();
      return T
    };
    @pure def addNode(n: T): Poset[T] = _root_.org.sireum.helper.$tmatch(parents.get(n)) match {
      case Some(_) => return this
      case _ => return Poset(parents.put(n, emptySet), children.put(n, emptySet))
    };
    @pure def addParents(n: T, ns: ISZ[T]): Poset[T] = {
      val newParents: HashMap[T, HashSet[T]] = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(parents.get(n)) match {
        case Some((s @ _)) => parents.put(n, s.addAll(ns))
        case _ => parents.put(n, emptySet.addAll(ns))
      });
      var newChildren: HashMap[T, HashSet[T]] = _root_.org.sireum.helper.$assign(children);
      ns.foreach(((c) => newChildren = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(newChildren.get(c)) match {
        case Some((s @ _)) => newChildren.put(c, s.add(n))
        case _ => newChildren.put(c, emptySet.add(n))
      })));
      return Poset(newParents, newChildren)
    };
    @pure def removeParent(n: T, parent: T): Poset[T] = _root_.org.sireum.helper.$tmatch(parents.get(n)) match {
      case Some((s @ _)) => return Poset(parents.put(n, s.remove(parent)), children.put(parent, children.get(parent).getOrElse(emptySet).remove(n)))
      case _ => return this
    };
    @pure def removeChild(n: T, child: T): Poset[T] = return removeParent(child, n);
    @pure def addChildren(n: T, ns: ISZ[T]): Poset[T] = {
      val newChildren: HashMap[T, HashSet[T]] = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(children.get(n)) match {
        case Some((s @ _)) => children.put(n, s.addAll(ns))
        case _ => children.put(n, emptySet.addAll(ns))
      });
      var newParents: HashMap[T, HashSet[T]] = _root_.org.sireum.helper.$assign(parents);
      ns.foreach(((c) => newParents = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(newParents.get(c)) match {
        case Some((s @ _)) => newParents.put(c, s.add(n))
        case _ => newParents.put(c, emptySet.add(n))
      })));
      return Poset(newParents, newChildren)
    };
    @pure def childrenOf(n: T): HashSet[T] = _root_.org.sireum.helper.$tmatch(children.get(n)) match {
      case Some((s @ _)) => return s
      case _ => return emptySet
    };
    @pure def isChildOf(n: T, m: T): B = return childrenOf(n).contains(m);
    @pure def parentsOf(n: T): HashSet[T] = _root_.org.sireum.helper.$tmatch(parents.get(n)) match {
      case Some((s @ _)) => return s
      case _ => return emptySet
    };
    @pure def isParentOf(n: T, m: T): B = return parentsOf(n).contains(m);
    @pure def ancestorsOf(n: T): HashSet[T] = return ancestorsCache(n, HashMap.empty)._1;
    @pure def ancestorsCache(n: T, acc: HashMap[T, HashSet[T]]): scala.Tuple2[HashSet[T], HashMap[T, HashSet[T]]] = {
      var mAcc = _root_.org.sireum.helper.$assign(acc);
      var r = _root_.org.sireum.helper.$assign(emptySet);
      parentsOf(n).elements.foreach(((nParent) => {
        mAcc = _root_.org.sireum.helper.$assign(ancestorsRec(nParent, mAcc));
        r = _root_.org.sireum.helper.$assign(r.add(nParent).union(mAcc.get(nParent).getOrElse(emptySet)))
      }));
      return scala.Tuple2(_root_.org.sireum.helper.$assign(r), _root_.org.sireum.helper.$assign(mAcc))
    };
    @pure def ancestorsRec(m: T, acc: HashMap[T, HashSet[T]]): HashMap[T, HashSet[T]] = {
      if (acc.contains(m))
        return acc
      else
        ();
      val p = _root_.org.sireum.helper.$assign(ancestorsCache(m, acc.put(m, emptySet)));
      val mAncestors = _root_.org.sireum.helper.$assign(p._1);
      val mAcc = _root_.org.sireum.helper.$assign(p._2);
      return mAcc.put(m, mAncestors)
    };
    @pure def lub(ns: ISZ[T]): Option[T] = {
      if (ns.isEmpty)
        return None()
      else
        ();
      val p0 = _root_.org.sireum.helper.$assign(ancestorsCache(ns(_root_.org.sireum.Z(0)), HashMap.empty));
      var commons = _root_.org.sireum.helper.$assign(p0._1.add(ns(_root_.org.sireum.Z(0))));
      var acc = _root_.org.sireum.helper.$assign(p0._2);
      _root_.org.sireum.Z(1).until(ns.size).foreach(((i) => {
        val p = _root_.org.sireum.helper.$assign(ancestorsCache(ns(i), acc));
        acc = _root_.org.sireum.helper.$assign(p._2);
        commons = _root_.org.sireum.helper.$assign(commons.intersect(p._1.add(ns(i))))
      }));
      if (commons.isEmpty)
        return None()
      else
        ();
      commons.elements.foreach(((b1) => commons.elements.withFilter(((b2) => b1.!=(b2))).foreach(((b2) => if (ancestorsCache(b1, acc)._1.contains(b2))
        commons = _root_.org.sireum.helper.$assign(commons.remove(b2))
      else
        ()))));
      if (commons.size.==(_root_.org.sireum.Z(1)))
        return Some(commons.elements(_root_.org.sireum.Z(0)))
      else
        return None()
    };
    @pure def descendantsOf(n: T): HashSet[T] = return descendantsCache(n, HashMap.empty)._1;
    @pure def descendantsCache(n: T, acc: HashMap[T, HashSet[T]]): scala.Tuple2[HashSet[T], HashMap[T, HashSet[T]]] = {
      var mAcc = _root_.org.sireum.helper.$assign(acc);
      var r = _root_.org.sireum.helper.$assign(emptySet);
      childrenOf(n).elements.foreach(((nChild) => {
        mAcc = _root_.org.sireum.helper.$assign(descendantsRec(nChild, mAcc));
        r = _root_.org.sireum.helper.$assign(r.add(nChild).union(mAcc.get(nChild).getOrElse(emptySet)))
      }));
      return scala.Tuple2(_root_.org.sireum.helper.$assign(r), _root_.org.sireum.helper.$assign(mAcc))
    };
    @pure def descendantsRec(m: T, acc: HashMap[T, HashSet[T]]): HashMap[T, HashSet[T]] = {
      if (acc.contains(m))
        return acc
      else
        ();
      val p = _root_.org.sireum.helper.$assign(descendantsCache(m, acc.put(m, emptySet)));
      val mDescendants = _root_.org.sireum.helper.$assign(p._1);
      val mAcc = _root_.org.sireum.helper.$assign(p._2);
      return mAcc.put(m, mDescendants)
    };
    @pure def glb(ns: ISZ[T]): Option[T] = {
      if (ns.isEmpty)
        return None()
      else
        ();
      val p0 = _root_.org.sireum.helper.$assign(descendantsCache(ns(_root_.org.sireum.Z(0)), HashMap.empty));
      var commons = _root_.org.sireum.helper.$assign(p0._1.add(ns(_root_.org.sireum.Z(0))));
      var acc = _root_.org.sireum.helper.$assign(p0._2);
      _root_.org.sireum.Z(1).until(ns.size).foreach(((i) => {
        val p = _root_.org.sireum.helper.$assign(descendantsCache(ns(i), acc));
        acc = _root_.org.sireum.helper.$assign(p._2);
        commons = _root_.org.sireum.helper.$assign(commons.intersect(p._1.add(ns(i))))
      }));
      if (commons.isEmpty)
        return None()
      else
        ();
      commons.elements.foreach(((b1) => commons.elements.withFilter(((b2) => b1.!=(b2))).foreach(((b2) => if (descendantsCache(b1, acc)._1.contains(b2))
        commons = _root_.org.sireum.helper.$assign(commons.remove(b2))
      else
        ()))));
      if (commons.size.==(_root_.org.sireum.Z(1)))
        return Some(commons.elements(_root_.org.sireum.Z(0)))
      else
        return None()
    };
    def parents = _parents;
    def children = _children;
    override def toString: _root_.java.lang.String = {
      val sb = new _root_.java.lang.StringBuilder();
      sb.append("Poset");
      sb.append('(');
      sb.append(_root_.org.sireum.String.escape(parents));
      sb.append(", ");
      sb.append(_root_.org.sireum.String.escape(children));
      sb.append(')');
      sb.toString
    };
    override def string: _root_.org.sireum.String = toString;
    override lazy val hashCode: _root_.scala.Int = 0;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): Poset[T] @unchecked)) => isEqual(o)
        case _ => false
      };
    def apply(parents: HashMap[T, HashSet[T]] = this.parents, children: HashMap[T, HashSet[T]] = this.children): Poset[T] = new Poset(parents, children);
    override lazy val content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Poset")), scala.Tuple2("parents", parents), scala.Tuple2("children", children))
  }
}