package org.sireum {
  object HashMap {
    @pure def empty[K, V]: HashMap[K, V] = return emptyInit[K, V](_root_.org.sireum.Z(16));
    @pure def emptyInit[K, V](initialCapacity: Z): HashMap[K, V] = {
      val sz: Z = _root_.org.sireum.helper.$assign(if (initialCapacity.<=(_root_.org.sireum.Z(0)))
        _root_.org.sireum.Z(4)
      else
        initialCapacity.*(_root_.org.sireum.Z(4))./(_root_.org.sireum.Z(3)).+(_root_.org.sireum.Z(1)));
      return HashMap[K, V](ISZ.create(sz, Map.empty), _root_.org.sireum.Z(0))
    };
    def apply[K, V](mapEntries: ISZ[Map[K, V]], size: Z): HashMap[K, V] = new HashMap(mapEntries, size);
    def unapply[K, V](o: HashMap[K, V]): _root_.scala.Option[scala.Tuple2[ISZ[Map[K, V]], Z]] = _root_.scala.Some(scala.Tuple2(o.mapEntries, o.size))
  }

  @datatype class HashMap[K, V](_mapEntries: ISZ[Map[K, V]], _size: Z) extends _root_.org.sireum.DatatypeSig {
    @pure override def hash: Z = return size;
    @pure def entries: ISZ[scala.Tuple2[K, V]] = {
      var r = _root_.org.sireum.helper.$assign(ISZ[scala.Tuple2[K, V]]());
      mapEntries.foreach(((ms) => if (ms.nonEmpty)
        r = _root_.org.sireum.helper.$assign(r.++(ms.entries))
      else
        ()));
      return r
    };
    @pure def keys: ISZ[K] = {
      var r = _root_.org.sireum.helper.$assign(ISZ[K]());
      mapEntries.foreach(((ms) => if (ms.nonEmpty)
        r = _root_.org.sireum.helper.$assign(r.++(ms.keys))
      else
        ()));
      return r
    };
    @pure def values: ISZ[V] = {
      var r = _root_.org.sireum.helper.$assign(ISZ[V]());
      mapEntries.foreach(((ms) => if (ms.nonEmpty)
        r = _root_.org.sireum.helper.$assign(r.++(ms.values))
      else
        ()));
      return r
    };
    @pure def keySet: Set[K] = return Set.empty[K].addAll(keys);
    @pure def valueSet: Set[V] = return Set.empty[V].addAll(values);
    @pure def put(key: K, value: V): HashMap[K, V] = {
      val r = _root_.org.sireum.helper.$assign(ensureCapacity(size.+(_root_.org.sireum.Z(1))));
      val i = _root_.org.sireum.helper.$assign(hashIndex(key));
      val m = _root_.org.sireum.helper.$assign(mapEntries(i));
      val newSize: Z = _root_.org.sireum.helper.$assign(if (m.contains(key))
        size
      else
        size.+(_root_.org.sireum.Z(1)));
      return r(mapEntries = mapEntries(i.->(mapEntries(i).put(key, value))), size = newSize)
    };
    @pure def putAll(entries: ISZ[scala.Tuple2[K, V]]): HashMap[K, V] = {
      if (entries.isEmpty)
        return this
      else
        ();
      var r = _root_.org.sireum.helper.$assign(ensureCapacity(size.+(entries.size)));
      entries.foreach(((kv) => r = _root_.org.sireum.helper.$assign(r.put(kv._1, kv._2))));
      return r
    };
    @pure def ensureCapacity(sz: Z): HashMap[K, V] = {
      if (mapEntries.size.*(_root_.org.sireum.Z(3))./(_root_.org.sireum.Z(4)).>=(sz))
        return this
      else
        ();
      val init = _root_.org.sireum.helper.$assign(sz.*(_root_.org.sireum.Z(2)));
      var r = _root_.org.sireum.helper.$assign(HashMap.emptyInit[K, V](init));
      mapEntries.foreach(((ms) => ms.entries.foreach(((kv) => r = _root_.org.sireum.helper.$assign(r.put(kv._1, kv._2))))));
      return r
    };
    @pure def hashIndex(key: K): Z = {
      val sz = _root_.org.sireum.helper.$assign(mapEntries.size);
      val i = _root_.org.sireum.helper.$assign(key.hashCode.%(sz));
      return if (i.<(_root_.org.sireum.Z(0)))
        i.+(sz)
      else
        i
    };
    @pure def get(key: K): Option[V] = {
      val m = _root_.org.sireum.helper.$assign(mapEntries(hashIndex(key)));
      return m.get(key)
    };
    @pure def entry(key: K): Option[scala.Tuple2[K, V]] = {
      val m = _root_.org.sireum.helper.$assign(mapEntries(hashIndex(key)));
      return m.entry(key)
    };
    @pure def removeAll(keys: ISZ[K]): HashMap[K, V] = {
      var r = _root_.org.sireum.helper.$assign(this);
      keys.foreach(((k) => _root_.org.sireum.helper.$tmatch(r.get(k)) match {
        case Some((v @ _)) => r = _root_.org.sireum.helper.$assign(r.remove(k, v))
        case _ => ()
      }));
      return r
    };
    @pure def remove(key: K, value: V): HashMap[K, V] = {
      val i = _root_.org.sireum.helper.$assign(hashIndex(key));
      return this(mapEntries = mapEntries(i.->(mapEntries(i).remove(key, value))), size = size.-(_root_.org.sireum.Z(1)))
    };
    @pure def isEqual(other: HashMap[K, V]): B = {
      if (size.!=(other.size))
        return F
      else
        ();
      var seen = _root_.org.sireum.helper.$assign(HashSet.emptyInit[K](size.+(_root_.org.sireum.Z(1)).*(_root_.org.sireum.Z(3))./(_root_.org.sireum.Z(4))));
      mapEntries.foreach(((ms) => ms.entries.foreach(((kv) => {
        val k = _root_.org.sireum.helper.$assign(kv._1);
        seen = _root_.org.sireum.helper.$assign(seen.add(k));
        _root_.org.sireum.helper.$tmatch(other.get(k)) match {
          case Some((v @ _)) => if (kv._2.!=(v))
            return F
          else
            ()
          case _ => return F
        }
      }))));
      other.mapEntries.foreach(((ms) => ms.entries.foreach(((kv) => {
        val k = _root_.org.sireum.helper.$assign(kv._1);
        if (seen.contains(k).`unary_!`)
          _root_.org.sireum.helper.$tmatch(get(k)) match {
            case Some((v @ _)) => if (kv._2.!=(v))
              return F
            else
              ()
            case _ => return F
          }
        else
          ()
      }))));
      return T
    };
    @pure def contains(key: K): B = return get(key).nonEmpty;
    @pure def isEmpty: B = return size.==(StringContext("0").z());
    @pure def nonEmpty: B = return size.!=(StringContext("0").z());
    def mapEntries = _mapEntries;
    def size = _size;
    override def toString: _root_.java.lang.String = {
      val sb = new _root_.java.lang.StringBuilder();
      sb.append("HashMap");
      sb.append('(');
      sb.append(_root_.org.sireum.String.escape(mapEntries));
      sb.append(", ");
      sb.append(_root_.org.sireum.String.escape(size));
      sb.append(')');
      sb.toString
    };
    override def string: _root_.org.sireum.String = toString;
    override lazy val hashCode: _root_.scala.Int = hash.hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): HashMap[K, V] @unchecked)) => isEqual(o)
        case _ => false
      };
    def apply(mapEntries: ISZ[Map[K, V]] = this.mapEntries, size: Z = this.size): HashMap[K, V] = new HashMap(mapEntries, size);
    override lazy val content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "HashMap")), scala.Tuple2("mapEntries", mapEntries), scala.Tuple2("size", size))
  }
}