package org.sireum {
  @record trait MOption[T] extends _root_.org.sireum.RecordSig {
    @pure def isEmpty: B;
    @pure def nonEmpty: B;
    @pure def map[T2](f: _root_.scala.Function1[T, T2]): MOption[T2];
    @pure def flatMap[T2](f: _root_.scala.Function1[T, MOption[T2]]): MOption[T2];
    @pure def forall(f: _root_.scala.Function1[T, B]): B;
    @pure def exists(f: _root_.scala.Function1[T, B]): B;
    @pure def getOrElse(default: T): T;
    def foreach(f: _root_.scala.Function1[T, Unit]): Unit
  }

  object MNone {
    private[this] val v: _root_.scala.AnyRef = new MNone[_root_.scala.Nothing]();
    def apply[T](): MNone[T] = v.asInstanceOf[MNone[T]];
    def unapply[T](o: MNone[T]): _root_.scala.Boolean = true
  }

  @record class MNone[T] extends MOption[T] with _root_.org.sireum.RecordSig {
    @pure def isEmpty: B = {
      StringContext(" ensures  result ≡ T ").lUnit();
      return T
    };
    @pure def nonEmpty: B = {
      StringContext(" ensures  result ≡ F ").lUnit();
      return F
    };
    @pure def map[T2](f: _root_.scala.Function1[T, T2]): MOption[T2] = {
      StringContext(" ensures  result ≡ MNone[T2]() ").lUnit();
      return MNone[T2]()
    };
    @pure def flatMap[T2](f: _root_.scala.Function1[T, MOption[T2]]): MOption[T2] = {
      StringContext(" ensures  result ≡ MNone[T2]() ").lUnit();
      return MNone[T2]()
    };
    @pure def forall(f: _root_.scala.Function1[T, B]): B = {
      StringContext(" ensures  result ≡ T ").lUnit();
      return T
    };
    @pure def exists(f: _root_.scala.Function1[T, B]): B = {
      StringContext(" ensures  result ≡ F ").lUnit();
      return F
    };
    @pure def getOrElse(default: T): T = {
      StringContext(" ensures  result ≡ default ").lUnit();
      return default
    };
    def foreach(f: _root_.scala.Function1[T, Unit]): Unit = ();
    override def toString: _root_.java.lang.String = "MNone()";
    override def string: _root_.org.sireum.String = toString;
    override val hashCode: _root_.scala.Int = this.getClass.hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): MNone[T] @unchecked)) => true
        case _ => false
      };
    override lazy val content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "MNone")));
    override def $clone: MNone[T] = this
  }

  object MSome {
    def apply[T](value: T): MSome[T] = new MSome(value);
    def unapply[T](o: MSome[T]): _root_.scala.Option[T] = _root_.scala.Some(_root_.org.sireum.helper.clone(o.value))
  }

  @record class MSome[T](_value: T) extends MOption[T] with _root_.org.sireum.RecordSig {
    @pure def isEmpty: B = {
      StringContext(" ensures  result ≡ F ").lUnit();
      return F
    };
    @pure def nonEmpty: B = {
      StringContext(" ensures  result ≡ T ").lUnit();
      return T
    };
    @pure def map[T2](f: _root_.scala.Function1[T, T2]): MOption[T2] = {
      StringContext(" ensures  result ≡ f(value) ").lUnit();
      return MSome(f(value))
    };
    @pure def flatMap[T2](f: _root_.scala.Function1[T, MOption[T2]]): MOption[T2] = {
      StringContext(" ensures  result ≡ f(value) ").lUnit();
      return f(value)
    };
    @pure def forall(f: _root_.scala.Function1[T, B]): B = {
      StringContext(" ensures  result ≡ f(value) ").lUnit();
      return f(value)
    };
    @pure def exists(f: _root_.scala.Function1[T, B]): B = {
      StringContext(" ensures  result ≡ f(value) ").lUnit();
      return f(value)
    };
    @pure def getOrElse(default: T): T = {
      StringContext(" ensures  result ≡ value ").lUnit();
      return value
    };
    def foreach(f: _root_.scala.Function1[T, Unit]): Unit = {
      StringContext(""" reads    f_reads
         requires f_requires(value)
         modifies f_modifies
         ensures  f_ensures(value) """).lUnit();
      f(value)
    };
    private var dirty: _root_.scala.Boolean = true;
    def value = _value;
    private var _hashCode: _root_.scala.Int = _;
    private def computeHashCode: _root_.scala.Int = _root_.scala.Seq(this.getClass, value).hashCode;
    override def toString: _root_.java.lang.String = {
      val sb = new _root_.java.lang.StringBuilder();
      sb.append("MSome");
      sb.append('(');
      sb.append(_root_.org.sireum.String.escape(value));
      sb.append(')');
      sb.toString
    };
    override def string: _root_.org.sireum.String = toString;
    override def hashCode: _root_.scala.Int = {
      if (dirty)
        {
          dirty = false;
          _hashCode = computeHashCode
        }
      else
        ();
      _hashCode
    };
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): MSome[T] @unchecked)) => if (this.hashCode.!=(o.hashCode))
          false
        else
          value.==(o.value)
        case _ => false
      };
    def apply(value: T = this.value): MSome[T] = new MSome(_root_.org.sireum.helper.$assign(value));
    override lazy val content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "MSome")), scala.Tuple2("value", value));
    override def $clone: MSome[T] = {
      val r: MSome[T] = new MSome(_root_.org.sireum.helper.cloneAssign(value));
      r
    }
  }
}