package org.sireum {
  object Set {
    @pure def empty[T]: Set[T] = return Set(Map.empty[T, B]);
    def apply[T](map: Map[T, B]): Set[T] = new Set(map);
    def unapply[T](o: Set[T]): _root_.scala.Option[Map[T, B]] = _root_.scala.Some(o.map)
  }

  @datatype class Set[T](_map: Map[T, B]) extends _root_.org.sireum.DatatypeSig {
    @pure def add(e: T): Set[T] = return Set(map.put(e, T));
    @pure def addAll(is: ISZ[T]): Set[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      is.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.add(e))));
      return r
    };
    @pure def remove(e: T): Set[T] = return Set(map.remove(e, T));
    @pure def removeAll(is: ISZ[T]): Set[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      is.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.remove(e))));
      return r
    };
    @pure def contains(e: T): B = return map.contains(e);
    @pure def union(other: Set[T]): Set[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      other.map.entries.foreach(((p) => r = _root_.org.sireum.helper.$assign(r.add(p._1))));
      return r
    };
    @pure def intersect(other: Set[T]): Set[T] = {
      var r = _root_.org.sireum.helper.$assign(Set.empty[T]);
      other.map.entries.foreach(((p) => {
        val e = _root_.org.sireum.helper.$assign(p._1);
        if (contains(e))
          r = _root_.org.sireum.helper.$assign(r.add(e))
        else
          ()
      }));
      return r
    };
    @pure def substract(other: Set[T]): Set[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      other.map.entries.foreach(((p) => r = _root_.org.sireum.helper.$assign(r.remove(p._1))));
      return r
    };
    @pure def isEqual(other: Set[T]): B = return map.isEqual(other.map);
    @pure def isEmpty: B = return size.==(StringContext("0").z());
    @pure def nonEmpty: B = return size.!=(StringContext("0").z());
    @pure def size: Z = return map.size;
    @pure def elements: ISZ[T] = return map.keys;
    def map = _map;
    override def toString: _root_.java.lang.String = {
      val sb = new _root_.java.lang.StringBuilder();
      sb.append("Set");
      sb.append('(');
      sb.append(_root_.org.sireum.String.escape(map));
      sb.append(')');
      sb.toString
    };
    override def string: _root_.org.sireum.String = toString;
    override lazy val hashCode: _root_.scala.Int = 0;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): Set[T] @unchecked)) => isEqual(o)
        case _ => false
      };
    def apply(map: Map[T, B] = this.map): Set[T] = new Set(map);
    override lazy val content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Set")), scala.Tuple2("map", map))
  }
}