package org.sireum {
  import org.sireum.ops.ISZOps

  object Stack {
    def empty[T]: Stack[T] = return Stack[T](ISZ());
    def apply[T](elements: ISZ[T]): Stack[T] = new Stack(elements);
    def unapply[T](o: Stack[T]): _root_.scala.Option[ISZ[T]] = _root_.scala.Some(o.elements)
  }

  @datatype class Stack[T](_elements: ISZ[T]) extends _root_.org.sireum.DatatypeSig {
    def isEmpty: B = return elements.isEmpty;
    def nonEmpty: B = return elements.nonEmpty;
    def peek: Option[T] = if (nonEmpty)
      return Some(elements(elements.size.-(_root_.org.sireum.Z(1))))
    else
      return None();
    def push(e: T): Stack[T] = return Stack(elements.:+(e));
    def pop(): Option[scala.Tuple2[T, Stack[T]]] = if (nonEmpty)
      return Some(scala.Tuple2(_root_.org.sireum.helper.$assign(elements(elements.size.-(_root_.org.sireum.Z(1)))), _root_.org.sireum.helper.$assign(Stack(ISZOps(elements).dropRight(_root_.org.sireum.Z(1))))))
    else
      return None();
    def elements = _elements;
    override def toString: _root_.java.lang.String = {
      val sb = new _root_.java.lang.StringBuilder();
      sb.append("Stack");
      sb.append('(');
      sb.append(_root_.org.sireum.String.escape(elements));
      sb.append(')');
      sb.toString
    };
    override def string: _root_.org.sireum.String = toString;
    override lazy val hashCode: _root_.scala.Int = _root_.scala.Seq(this.getClass, elements).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): Stack[T] @unchecked)) => if (this.hashCode.!=(o.hashCode))
          false
        else
          elements.==(o.elements)
        case _ => false
      };
    def apply(elements: ISZ[T] = this.elements): Stack[T] = new Stack(elements);
    override lazy val content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Stack")), scala.Tuple2("elements", elements))
  }
}