package org.sireum {
  object Map {
    @pure def empty[K, V]: Map[K, V] = return _root_.org.sireum.helper.$assign(Map[K, V](ISZ()));
    @pure def of[K, V]: Map[K, V] = return _root_.org.sireum.helper.$assign(Map.empty);
    @pure def ++[K, V, I](s: IS[I, scala.Tuple2[K, V]]): Map[K, V] = return _root_.org.sireum.helper.$assign(Map.empty[K, V].++(s));
    def apply[K, V](entries: ISZ[scala.Tuple2[K, V]]): Map[K, V] = new Map(entries);
    def unapply[K, V](o: Map[K, V]): _root_.scala.Option[ISZ[scala.Tuple2[K, V]]] = _root_.scala.Some(o.entries)
  }

  @datatype final class Map[K, V](__entries: ISZ[scala.Tuple2[K, V]]) extends _root_.org.sireum.DatatypeSig {
    private[this] val _entries = __entries;
    def entries = _entries;
    def getEntries = _entries;
    override def toString: _root_.java.lang.String = string.value;
    override lazy val hashCode: _root_.scala.Int = hash.hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): Map[K, V] @unchecked)) => isEqual(o)
        case _ => halt("Invalid equality test between ".+(this.getClass).+(" and ").+(o.getClass))
      };
    def apply(entries: ISZ[scala.Tuple2[K, V]] = this.entries): Map[K, V] = new Map(entries);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Map")), scala.Tuple2("entries", this.entries));
    @pure def keys: ISZ[K] = {
      var r = _root_.org.sireum.helper.$assign(ISZ[K]());
      entries.foreach(((kv) => r = _root_.org.sireum.helper.$assign(r.:+(kv._1))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def values: ISZ[V] = {
      var r = _root_.org.sireum.helper.$assign(ISZ[V]());
      entries.foreach(((kv) => r = _root_.org.sireum.helper.$assign(r.:+(kv._2))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def keySet: Set[K] = return _root_.org.sireum.helper.$assign(Set.empty[K].++(keys));
    @pure def valueSet: Set[V] = return _root_.org.sireum.helper.$assign(Set.empty[V].++(values));
    @pure def +(p: scala.Tuple2[K, V]): Map[K, V] = {
      val x$1 = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(p: @scala.unchecked) match {
        case scala.Tuple2((key @ _), (value @ _)) => scala.Tuple2(_root_.org.sireum.helper.$assign(key), _root_.org.sireum.helper.$assign(value))
      });
      val key = _root_.org.sireum.helper.$assign(x$1._1);
      val value = _root_.org.sireum.helper.$assign(x$1._2);
      val index = _root_.org.sireum.helper.$assign(indexOf(key));
      val newEntries: ISZ[scala.Tuple2[K, V]] = _root_.org.sireum.helper.$assign(if (index.<(_root_.org.sireum.Z(0)))
        entries.:+(scala.Tuple2(_root_.org.sireum.helper.$assign(key), _root_.org.sireum.helper.$assign(value)))
      else
        entries(scala.Tuple2(_root_.org.sireum.helper.$assign(index), _root_.org.sireum.helper.$assign(scala.Tuple2(_root_.org.sireum.helper.$assign(key), _root_.org.sireum.helper.$assign(value))))));
      return _root_.org.sireum.helper.$assign(Map(newEntries))
    };
    @pure def ++[I](kvs: IS[I, scala.Tuple2[K, V]]): Map[K, V] = {
      var r = _root_.org.sireum.helper.$assign(this);
      kvs.foreach(((kv) => r = _root_.org.sireum.helper.$assign(r.+(kv._1.~>(kv._2)))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def get(key: K): Option[V] = {
      val index = _root_.org.sireum.helper.$assign(indexOf(key));
      return _root_.org.sireum.helper.$assign(if (index.<(_root_.org.sireum.Z(0)))
        None[V]()
      else
        Some(entries(index)._2))
    };
    @pure def getOrElse(key: K, default: => V): V = {
      val index = _root_.org.sireum.helper.$assign(indexOf(key));
      return _root_.org.sireum.helper.$assign(if (index.<(_root_.org.sireum.Z(0)))
        default
      else
        entries(index)._2)
    };
    @pure def entry(key: K): Option[scala.Tuple2[K, V]] = {
      val index = _root_.org.sireum.helper.$assign(indexOf(key));
      return _root_.org.sireum.helper.$assign(if (index.<(_root_.org.sireum.Z(0)))
        None[scala.Tuple2[K, V]]()
      else
        Some(entries(index)))
    };
    @pure def indexOf(key: K): Z = {
      var index = StringContext("-1").z();
      entries.indices.withFilter(((i) => index.==(StringContext("-1").z()))).foreach(((i) => if (entries(i)._1.==(key))
        index = _root_.org.sireum.helper.$assign(i)
      else
        ()));
      return _root_.org.sireum.helper.$assign(index)
    };
    @pure def --[I](keys: IS[I, K]): Map[K, V] = {
      var deletedMappings = _root_.org.sireum.helper.$assign(ISZ[scala.Tuple2[K, V]]());
      keys.foreach(((key) => _root_.org.sireum.helper.$tmatch(get(key)) match {
        case Some((value @ _)) => deletedMappings = _root_.org.sireum.helper.$assign(deletedMappings.:+(scala.Tuple2(_root_.org.sireum.helper.$assign(key), _root_.org.sireum.helper.$assign(value))))
        case _ => ()
      }));
      if (deletedMappings.nonEmpty)
        return _root_.org.sireum.helper.$assign(Map(entries.--(deletedMappings)))
      else
        return _root_.org.sireum.helper.$assign(this)
    };
    @pure def -(p: scala.Tuple2[K, V]): Map[K, V] = return _root_.org.sireum.helper.$assign(Map(entries.-(p)));
    @pure def contains(key: K): B = return _root_.org.sireum.helper.$assign(indexOf(key).>=(_root_.org.sireum.Z(0)));
    @pure def isEmpty: B = return _root_.org.sireum.helper.$assign(size.==(StringContext("0").z()));
    @pure def nonEmpty: B = return _root_.org.sireum.helper.$assign(size.!=(StringContext("0").z()));
    @pure def size: Z = return _root_.org.sireum.helper.$assign(entries.size);
    @pure override def string: String = {
      val r = StringContext("""{
    |  """, """
    |}""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(entries.map(((e) => StringContext("", " -> ", "").st(e._1, e._2)))), _root_.org.sireum.String(",\n")));
      return _root_.org.sireum.helper.$assign(r.render)
    };
    @pure override def hash: Z = return _root_.org.sireum.helper.$assign(entries.size);
    @pure def isEqual(other: Map[K, V]): B = {
      if (size.!=(other.size))
        return _root_.org.sireum.helper.$assign(F)
      else
        ();
      var seen = _root_.org.sireum.helper.$assign(Set.empty[K]);
      entries.foreach(((kv) => {
        val k = _root_.org.sireum.helper.$assign(kv._1);
        seen = _root_.org.sireum.helper.$assign(seen.+(k));
        _root_.org.sireum.helper.$tmatch(other.get(k)) match {
          case Some((v @ _)) => if (v.!=(kv._2))
            return _root_.org.sireum.helper.$assign(F)
          else
            ()
          case _ => return _root_.org.sireum.helper.$assign(F)
        }
      }));
      other.entries.foreach(((kv) => {
        val k = _root_.org.sireum.helper.$assign(kv._1);
        if (seen.contains(k).`unary_!`)
          _root_.org.sireum.helper.$tmatch(get(k)) match {
            case Some((v @ _)) => if (v.!=(kv._2))
              return _root_.org.sireum.helper.$assign(F)
            else
              ()
            case _ => return _root_.org.sireum.helper.$assign(F)
          }
        else
          ()
      }));
      return _root_.org.sireum.helper.$assign(T)
    }
  }
}