package org.sireum {
  object HashBag {
    @pure def empty[T]: HashBag[T] = return _root_.org.sireum.helper.$assign(HashBag(HashMap.empty));
    @pure def emptyInit[T](initialCapacity: Z): HashBag[T] = return _root_.org.sireum.helper.$assign(HashBag(HashMap.emptyInit(initialCapacity)));
    @pure def ++[I, T](s: IS[I, T]): HashBag[T] = return _root_.org.sireum.helper.$assign(HashBag.empty[T].++(s));
    def apply[T](map: HashMap[T, Z]): HashBag[T] = new HashBag(map);
    def unapply[T](o: HashBag[T]): _root_.scala.Option[HashMap[T, Z]] = _root_.scala.Some(o.map)
  }

  @datatype final class HashBag[T](__map: HashMap[T, Z]) extends _root_.org.sireum.DatatypeSig {
    private[this] val _map = __map;
    def map = _map;
    def getMap = _map;
    override def toString: _root_.java.lang.String = string.value;
    override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      _root_.scala.Seq(this.getClass, map).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): HashBag[T] @unchecked)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            this.map.==(o.map)
          case _ => false
        };
    def apply(map: HashMap[T, Z] = this.map): HashBag[T] = new HashBag(map);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "HashBag")), scala.Tuple2("map", this.map));
    @pure def size: Z = {
      var r = StringContext("0").z();
      map.values.foreach(((n) => r = _root_.org.sireum.helper.$assign(r.+(n))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def elements: ISZ[T] = {
      var r = _root_.org.sireum.helper.$assign(ISZ[T]());
      entries.foreach(((entry) => {
        val x$1 = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(entry: @scala.unchecked) match {
          case scala.Tuple2((e @ _), (size @ _)) => scala.Tuple2(_root_.org.sireum.helper.$assign(e), _root_.org.sireum.helper.$assign(size))
        });
        val e = _root_.org.sireum.helper.$assign(x$1._1);
        val size = _root_.org.sireum.helper.$assign(x$1._2);
        r = _root_.org.sireum.helper.$assign(r.++(StringContext("0").z().until(size).map(((_ ) => e))))
      }));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def isEmpty: B = return _root_.org.sireum.helper.$assign(size.==(_root_.org.sireum.Z(0)));
    @pure def nonEmpty: B = return _root_.org.sireum.helper.$assign(isEmpty.`unary_!`);
    @pure def count(e: T): Z = _root_.org.sireum.helper.$tmatch(map.get(e)) match {
      case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
      case _ => return _root_.org.sireum.Z(0)
    };
    @pure def contains(e: T): B = return _root_.org.sireum.helper.$assign(count(e).>(_root_.org.sireum.Z(0)));
    @pure def +(e: T): HashBag[T] = return _root_.org.sireum.helper.$assign(addN(e, _root_.org.sireum.Z(1)));
    @pure def +#(p: scala.Tuple2[T, Z]): HashBag[T] = return _root_.org.sireum.helper.$assign(addN(p._1, p._2));
    @pure def addN(e: T, n: Z): HashBag[T] = {
      if (n.<=(_root_.org.sireum.Z(0)))
        return _root_.org.sireum.helper.$assign(this)
      else
        ();
      return _root_.org.sireum.helper.$assign(this(map.+(e.~>(count(e).+(n)))))
    };
    @pure def ++[I](es: IS[I, T]): HashBag[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      es.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.+(e))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def -(e: T): HashBag[T] = return _root_.org.sireum.helper.$assign(removeN(e, _root_.org.sireum.Z(1)));
    @pure def --[I](s: IS[I, T]): HashBag[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      s.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.-(e))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def -#(p: scala.Tuple2[T, Z]): HashBag[T] = return _root_.org.sireum.helper.$assign(removeN(p._1, p._2));
    @pure def removeN(e: T, n: Z): HashBag[T] = {
      val current = _root_.org.sireum.helper.$assign(count(e));
      val newN = _root_.org.sireum.helper.$assign(current.-(n));
      if (newN.<=(_root_.org.sireum.Z(0)))
        return _root_.org.sireum.helper.$assign(this(map.-(e.~>(current))))
      else
        return _root_.org.sireum.helper.$assign(this(map.+(e.~>(newN))))
    };
    @pure def \(other: HashBag[T]): HashBag[T] = return _root_.org.sireum.helper.$assign(this.--(other.elements));
    @pure def entries: ISZ[scala.Tuple2[T, Z]] = return _root_.org.sireum.helper.$assign(map.entries);
    @pure def union(other: HashBag[T]): HashBag[T] = return _root_.org.sireum.helper.$assign(this.∪(other));
    @pure def ∪(other: HashBag[T]): HashBag[T] = return _root_.org.sireum.helper.$assign(this.++(other.elements));
    @pure def intersect(other: HashBag[T]): HashBag[T] = return _root_.org.sireum.helper.$assign(this.∩(other));
    @pure def ∩(other: HashBag[T]): HashBag[T] = {
      var r = _root_.org.sireum.helper.$assign(HashBag.empty[T]);
      entries.foreach(((e) => {
        val n = _root_.org.sireum.helper.$assign(e._2);
        val m = _root_.org.sireum.helper.$assign(other.count(e._1));
        if (n.<(m))
          r = _root_.org.sireum.helper.$assign(r.addN(e._1, n))
        else
          r = _root_.org.sireum.helper.$assign(r.addN(e._1, m))
      }));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure override def string: String = return _root_.org.sireum.helper.$assign(map.string)
  }
}