package org.sireum {
  object HashSMap {
    @pure def empty[K, V]: HashSMap[K, V] = return _root_.org.sireum.helper.$assign(HashSMap(HashMap.empty, Set.empty));
    @pure def emptyInit[K, V](initialCapacity: Z): HashSMap[K, V] = return _root_.org.sireum.helper.$assign(HashSMap(HashMap.emptyInit(initialCapacity), Set.empty));
    @pure def ++[I, K, V](s: IS[I, scala.Tuple2[K, V]]): HashSMap[K, V] = return _root_.org.sireum.helper.$assign(HashSMap.emptyInit[K, V](s.zize).++(s));
    def apply[K, V](map: HashMap[K, V], keys: Set[K]): HashSMap[K, V] = new HashSMap(map, keys);
    def unapply[K, V](o: HashSMap[K, V]): _root_.scala.Option[scala.Tuple2[HashMap[K, V], Set[K]]] = _root_.scala.Some(scala.Tuple2(o.map, o.keys))
  }

  @datatype final class HashSMap[K, V](__map: HashMap[K, V], __keys: Set[K]) extends _root_.org.sireum.DatatypeSig {
    private[this] val _map = __map;
    def map = _map;
    def getMap = _map;
    private[this] val _keys = __keys;
    def keys = _keys;
    def getKeys = _keys;
    override def toString: _root_.java.lang.String = string.value;
    override lazy val hashCode: _root_.scala.Int = hash.hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): HashSMap[K, V] @unchecked)) => isEqual(o)
        case _ => halt("Invalid equality test between ".+(this.getClass).+(" and ").+(o.getClass))
      };
    def apply(map: HashMap[K, V] = this.map, keys: Set[K] = this.keys): HashSMap[K, V] = new HashSMap(map, keys);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "HashSMap")), scala.Tuple2("map", this.map), scala.Tuple2("keys", this.keys));
    @pure def size: Z = return _root_.org.sireum.helper.$assign(keys.size);
    @pure def entries: ISZ[scala.Tuple2[K, V]] = {
      var r = _root_.org.sireum.helper.$assign(ISZ[scala.Tuple2[K, V]]());
      keys.elements.foreach(((k) => _root_.org.sireum.helper.$tmatch(map.get(k)) match {
        case Some((v @ _)) => r = _root_.org.sireum.helper.$assign(r.:+(scala.Tuple2(_root_.org.sireum.helper.$assign(k), _root_.org.sireum.helper.$assign(v))))
        case _ => ()
      }));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def values: ISZ[V] = return _root_.org.sireum.helper.$assign(map.values);
    @pure def keySet: Set[K] = return _root_.org.sireum.helper.$assign(keys);
    @pure def valueSet: Set[V] = return _root_.org.sireum.helper.$assign(Set.empty[V].++(values));
    @pure def +(p: scala.Tuple2[K, V]): HashSMap[K, V] = {
      val newMap = _root_.org.sireum.helper.$assign(map.+(p));
      return _root_.org.sireum.helper.$assign(HashSMap(newMap, keys.+(p._1)))
    };
    @pure def ++[I](entries: IS[I, scala.Tuple2[K, V]]): HashSMap[K, V] = {
      if (entries.isEmpty)
        return _root_.org.sireum.helper.$assign(this)
      else
        ();
      val newMap = _root_.org.sireum.helper.$assign(map.++(entries));
      var newKeys = _root_.org.sireum.helper.$assign(keys);
      entries.foreach(((kv) => newKeys = _root_.org.sireum.helper.$assign(newKeys.+(kv._1))));
      return _root_.org.sireum.helper.$assign(HashSMap(newMap, newKeys))
    };
    @pure def get(key: K): Option[V] = return _root_.org.sireum.helper.$assign(map.get(key));
    @pure def entry(key: K): Option[scala.Tuple2[K, V]] = return _root_.org.sireum.helper.$assign(map.entry(key));
    @pure def --(keys: ISZ[K]): HashSMap[K, V] = return _root_.org.sireum.helper.$assign(HashSMap(map.--(keys), this.keys.--(keys)));
    @pure def -(p: scala.Tuple2[K, V]): HashSMap[K, V] = return _root_.org.sireum.helper.$assign(HashSMap(map.-(p), keys.-(p._1)));
    @pure def contains(key: K): B = return _root_.org.sireum.helper.$assign(map.contains(key));
    @pure def isEmpty: B = return _root_.org.sireum.helper.$assign(size.==(StringContext("0").z()));
    @pure def nonEmpty: B = return _root_.org.sireum.helper.$assign(size.!=(StringContext("0").z()));
    @pure override def string: String = {
      val r = StringContext("""{
      |  """, """
      |}""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(entries.map(((e) => StringContext("", " -> ", "").st(e._1, e._2)))), _root_.org.sireum.String(",\n")));
      return _root_.org.sireum.helper.$assign(r.render)
    };
    @pure override def hash: Z = return _root_.org.sireum.helper.$assign(_root_.org.sireum.Z(map.hashCode));
    @pure def isEqual(other: HashSMap[K, V]): B = return _root_.org.sireum.helper.$assign(map.isEqual(other.map))
  }
}