package org.sireum {
  object UnionFind {
    type Index = Z;
    object Internal {
      @pure def find[T](ds: UnionFind[T], e: Index): Index = {
        var root = _root_.org.sireum.helper.$assign(e);
        while (ds.parentOf(root).!=(root)) 
          root = _root_.org.sireum.helper.$assign(ds.parentOf(root))
        ;
        return _root_.org.sireum.helper.$assign(root)
      };
      @pure def findCompress[T](ds: UnionFind[T], e: Index): scala.Tuple2[UnionFind[T], Index] = {
        var root = _root_.org.sireum.helper.$assign(e);
        var newParentOf = _root_.org.sireum.helper.$assign(ds.parentOf);
        while (newParentOf(root).!=(root)) 
          {
            newParentOf = _root_.org.sireum.helper.$assign(newParentOf(root.~>(newParentOf(newParentOf(root)))));
            root = _root_.org.sireum.helper.$assign(newParentOf(root))
          }
        ;
        return _root_.org.sireum.helper.$assign(scala.Tuple2(_root_.org.sireum.helper.$assign(ds(parentOf = newParentOf)), _root_.org.sireum.helper.$assign(root)))
      };
      @pure def merge[T](ds: UnionFind[T], e1: Index, e2: Index): UnionFind[T] = {
        var newDs = _root_.org.sireum.helper.$assign(ds);
        val rootN: Index = _root_.org.sireum.helper.$assign({
          val pe1 = _root_.org.sireum.helper.$assign(findCompress(newDs, e1));
          newDs = _root_.org.sireum.helper.$assign(pe1._1);
          pe1._2
        });
        val rootM: Index = _root_.org.sireum.helper.$assign({
          val pe2 = _root_.org.sireum.helper.$assign(findCompress(newDs, e2));
          newDs = _root_.org.sireum.helper.$assign(pe2._1);
          pe2._2
        });
        val x$1 = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch((((if (newDs.sizeOf(rootM).>(newDs.sizeOf(rootN)))
          scala.Tuple2(rootM, rootN)
        else
          scala.Tuple2(rootN, rootM)): @scala.unchecked): scala.Tuple2[Index, Index])) match {
          case scala.Tuple2((rep @ _), (other @ _)) => scala.Tuple2(_root_.org.sireum.helper.$assign(rep), _root_.org.sireum.helper.$assign(other))
        });
        val rep = _root_.org.sireum.helper.$assign(x$1._1);
        val other = _root_.org.sireum.helper.$assign(x$1._2);
        return _root_.org.sireum.helper.$assign(newDs(parentOf = newDs.parentOf(other.~>(rep)), sizeOf = newDs.sizeOf(rep.~>(newDs.sizeOf(rep).+(newDs.sizeOf(other))))))
      }
    };
    @pure def create[T](elements: ISZ[T]): UnionFind[T] = {
      val size = _root_.org.sireum.helper.$assign(elements.size);
      var es = _root_.org.sireum.helper.$assign(HashMap.emptyInit[T, Index](size));
      elements.foreach(((e) => es = _root_.org.sireum.helper.$assign(es.+(e.~>(es.size)))));
      val parentOf: IS[Index, Index] = _root_.org.sireum.helper.$assign(StringContext("0").z().until(size).map(((i) => i)));
      val sizeOf = _root_.org.sireum.helper.$assign(IS.create[Index, Index](size, _root_.org.sireum.Z(1)));
      return _root_.org.sireum.helper.$assign(UnionFind(es, elements, parentOf, sizeOf))
    };
    def apply[T](elements: HashMap[T, UnionFind.Index], elementsInverse: IS[UnionFind.Index, T], parentOf: IS[UnionFind.Index, UnionFind.Index], sizeOf: IS[UnionFind.Index, UnionFind.Index]): UnionFind[T] = new UnionFind(elements, elementsInverse, parentOf, sizeOf);
    def unapply[T](o: UnionFind[T]): _root_.scala.Option[scala.Tuple4[HashMap[T, UnionFind.Index], IS[UnionFind.Index, T], IS[UnionFind.Index, UnionFind.Index], IS[UnionFind.Index, UnionFind.Index]]] = _root_.scala.Some(scala.Tuple4(o.elements, o.elementsInverse, o.parentOf, o.sizeOf))
  }

  @datatype final class UnionFind[T](__elements: HashMap[T, UnionFind.Index], __elementsInverse: IS[UnionFind.Index, T], __parentOf: IS[UnionFind.Index, UnionFind.Index], __sizeOf: IS[UnionFind.Index, UnionFind.Index]) extends _root_.org.sireum.DatatypeSig {
    private[this] val _elements = __elements;
    def elements = _elements;
    def getElements = _elements;
    private[this] val _elementsInverse = __elementsInverse;
    def elementsInverse = _elementsInverse;
    def getElementsInverse = _elementsInverse;
    private[this] val _parentOf = __parentOf;
    def parentOf = _parentOf;
    def getParentOf = _parentOf;
    private[this] val _sizeOf = __sizeOf;
    def sizeOf = _sizeOf;
    def getSizeOf = _sizeOf;
    override def toString: _root_.java.lang.String = string.value;
    override lazy val hashCode: _root_.scala.Int = hash.hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): UnionFind[T] @unchecked)) => isEqual(o)
        case _ => halt("Invalid equality test between ".+(this.getClass).+(" and ").+(o.getClass))
      };
    def apply(elements: HashMap[T, UnionFind.Index] = this.elements, elementsInverse: IS[UnionFind.Index, T] = this.elementsInverse, parentOf: IS[UnionFind.Index, UnionFind.Index] = this.parentOf, sizeOf: IS[UnionFind.Index, UnionFind.Index] = this.sizeOf): UnionFind[T] = new UnionFind(elements, elementsInverse, parentOf, sizeOf);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "UnionFind")), scala.Tuple2("elements", this.elements), scala.Tuple2("elementsInverse", this.elementsInverse), scala.Tuple2("parentOf", this.parentOf), scala.Tuple2("sizeOf", this.sizeOf));
    @pure def size: Z = return _root_.org.sireum.helper.$assign(elements.size);
    @pure override def hash: Z = return _root_.org.sireum.helper.$assign(size);
    @pure def isEqual(other: UnionFind[T]): B = {
      if (elementsInverse.size.!=(other.elementsInverse.size))
        return _root_.org.sireum.helper.$assign(F)
      else
        ();
      if (HashSet.++(elementsInverse).!=(HashSet.++(other.elementsInverse)))
        return _root_.org.sireum.helper.$assign(F)
      else
        ();
      var seen = _root_.org.sireum.helper.$assign(HashSet.emptyInit[scala.Tuple2[T, T]](size));
      elementsInverse.foreach(((element1) => elementsInverse.withFilter(((element2) => element1.!=(element2))).foreach(((element2) => {
        val p = _root_.org.sireum.helper.$assign(scala.Tuple2(_root_.org.sireum.helper.$assign(element1), _root_.org.sireum.helper.$assign(element2)));
        if (seen.contains(p).`unary_!`)
          {
            seen = _root_.org.sireum.helper.$assign(seen.+(p).+(scala.Tuple2(_root_.org.sireum.helper.$assign(element2), _root_.org.sireum.helper.$assign(element1))));
            if (inSameSet(element1, element2).!=(inSameSet(element1, element2)))
              return _root_.org.sireum.helper.$assign(F)
            else
              ()
          }
        else
          ()
      }))));
      return _root_.org.sireum.helper.$assign(T)
    };
    @pure def inSameSet(element1: T, element2: T): B = return _root_.org.sireum.helper.$assign(UnionFind.Internal.find(this, elements.get(element1).get).==(UnionFind.Internal.find(this, elements.get(element2).get)));
    @pure def inSameSetCompress(element1: T, element2: T): scala.Tuple2[UnionFind[T], B] = {
      val e1 = _root_.org.sireum.helper.$assign(elements.get(element1).get);
      val e2 = _root_.org.sireum.helper.$assign(elements.get(element2).get);
      var newDs = _root_.org.sireum.helper.$assign(this);
      val rep1: UnionFind.Index = _root_.org.sireum.helper.$assign({
        val p1 = _root_.org.sireum.helper.$assign(UnionFind.Internal.findCompress(newDs, e1));
        newDs = _root_.org.sireum.helper.$assign(p1._1);
        p1._2
      });
      val rep2: UnionFind.Index = _root_.org.sireum.helper.$assign({
        val p2 = _root_.org.sireum.helper.$assign(UnionFind.Internal.findCompress(newDs, e2));
        newDs = _root_.org.sireum.helper.$assign(p2._1);
        p2._2
      });
      return _root_.org.sireum.helper.$assign(scala.Tuple2(_root_.org.sireum.helper.$assign(newDs), _root_.org.sireum.helper.$assign(rep1.==(rep2))))
    };
    @pure def find(element: T): T = {
      val n = _root_.org.sireum.helper.$assign(elements.get(element).get);
      val rep = _root_.org.sireum.helper.$assign(UnionFind.Internal.find(this, n));
      return _root_.org.sireum.helper.$assign(elementsInverse(rep))
    };
    @pure def findCompress(element: T): scala.Tuple2[UnionFind[T], T] = {
      val n = _root_.org.sireum.helper.$assign(elements.get(element).get);
      val x$2 = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(UnionFind.Internal.findCompress(this, n): @scala.unchecked) match {
        case scala.Tuple2((newDs @ _), (rep @ _)) => scala.Tuple2(_root_.org.sireum.helper.$assign(newDs), _root_.org.sireum.helper.$assign(rep))
      });
      val newDs = _root_.org.sireum.helper.$assign(x$2._1);
      val rep = _root_.org.sireum.helper.$assign(x$2._2);
      return _root_.org.sireum.helper.$assign(scala.Tuple2(_root_.org.sireum.helper.$assign(newDs), _root_.org.sireum.helper.$assign(elementsInverse(rep))))
    };
    @pure def merge(element1: T, element2: T): UnionFind[T] = {
      val e1 = _root_.org.sireum.helper.$assign(elements.get(element1).get);
      val e2 = _root_.org.sireum.helper.$assign(elements.get(element2).get);
      return _root_.org.sireum.helper.$assign(UnionFind.Internal.merge(this, e1, e2))
    };
    @pure def toST(f: _root_.scala.Function1[T, ST]): ST = {
      var map = _root_.org.sireum.helper.$assign(HashMap.emptyInit[UnionFind.Index, ISZ[ST]](size));
      elementsInverse.foreach(((element) => {
        val rep = _root_.org.sireum.helper.$assign(UnionFind.Internal.find(this, elements.get(element).get));
        map = _root_.org.sireum.helper.$assign(map.+(rep.~>(map.get(rep).getOrElse(ISZ[ST]()).:+(f(element)))))
      }));
      val sets: ISZ[ST] = _root_.org.sireum.helper.$assign(map.values.map(((sts) => StringContext("""{
    |  """, """
    |}""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(sts), _root_.org.sireum.String(",\n"))))));
      val r = StringContext("""{
      |  """, """
      |}""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(sets), _root_.org.sireum.String(",\n")));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure override def string: String = return _root_.org.sireum.helper.$assign(toST(((e) => StringContext("", "").st(e))).render)
  }
}