package org.sireum.conversions {
  import org.sireum._

  object Collection {
    @pure def mapToHashMap[K, V](map: Map[K, V]): HashMap[K, V] = {
      var r = _root_.org.sireum.helper.$assign(HashMap.emptyInit[K, V](map.size));
      map.entries.foreach(((kv) => r = _root_.org.sireum.helper.$assign(r.+(kv._1.~>(kv._2)))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def mapToHashSMap[K, V](map: Map[K, V]): HashSMap[K, V] = {
      var r = _root_.org.sireum.helper.$assign(HashSMap.emptyInit[K, V](map.size));
      map.entries.foreach(((kv) => r = _root_.org.sireum.helper.$assign(r.+(kv._1.~>(kv._2)))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def bagToHashBag[T](bag: Bag[T]): HashBag[T] = return _root_.org.sireum.helper.$assign(HashBag(mapToHashMap(bag.map)))
  }
}