package org.sireum.message {
  import org.sireum._

  object Reporter {
    @pure def create: Reporter = return _root_.org.sireum.helper.$assign(Reporter(ISZ()));
    @pure def combine(r1: Reporter, r2: Reporter): Reporter = return _root_.org.sireum.helper.$assign(Reporter(r1.messages.++(r2.messages)));
    def apply(messages: ISZ[Message]): Reporter = new Reporter(_root_.org.sireum.helper.$assign(messages));
    def unapply(o: Reporter): _root_.scala.Option[ISZ[Message]] = _root_.scala.Some(_root_.org.sireum.helper.clone(o.messages))
  }

  @record final class Reporter(__messages: ISZ[Message]) extends _root_.org.sireum.RecordSig {
    private[this] var _messages = __messages;
    def messages = _messages;
    def getMessages = _messages;
    def `messages_=`(messages: ISZ[Message]): this.type = {
      _messages = messages;
      this
    };
    def setMessages(messages: ISZ[Message]): this.type = {
      _messages = messages;
      this
    };
    override def toString: _root_.java.lang.String = if ($hasString)
      super.string.value
    else
      {
        val sb = new _root_.java.lang.StringBuilder();
        sb.append("Reporter");
        sb.append('(');
        sb.append(_root_.org.sireum.String.escape(this.messages));
        sb.append(')');
        sb.toString
      };
    override def string: _root_.org.sireum.String = if ($hasString)
      super.string
    else
      toString;
    override def hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      _root_.scala.Seq(this.getClass, messages).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): Reporter)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            this.messages.==(o.messages)
          case _ => false
        };
    def apply(messages: ISZ[Message] = this.messages): Reporter = new Reporter(_root_.org.sireum.helper.$assign(messages));
    override def $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "message", "Reporter")), scala.Tuple2("messages", messages));
    override def $clone: Reporter = {
      val r: Reporter = new Reporter(_root_.org.sireum.helper.cloneAssign(this.messages));
      r.ignore = _root_.org.sireum.helper.cloneAssign(ignore);
      r
    };
    var ignore: B = _root_.org.sireum.helper.$assign(F);
    def hasInternalError: B = {
      messages.foreach(((m) => _root_.org.sireum.helper.$tmatch(m.level) match {
        case Level.InternalError => return _root_.org.sireum.helper.$assign(T)
        case _ => ()
      }));
      return _root_.org.sireum.helper.$assign(F)
    };
    def hasError: B = {
      messages.withFilter(((m) => m.isError.||(m.isInternalError))).foreach(((m) => return _root_.org.sireum.helper.$assign(T)));
      return _root_.org.sireum.helper.$assign(F)
    };
    def hasWarning: B = {
      messages.withFilter(((m) => m.isWarning)).foreach(((m) => return _root_.org.sireum.helper.$assign(T)));
      return _root_.org.sireum.helper.$assign(F)
    };
    def hasIssue: B = {
      messages.withFilter(((m) => m.isError.||(m.isWarning).||(m.isInternalError))).foreach(((m) => return _root_.org.sireum.helper.$assign(T)));
      return _root_.org.sireum.helper.$assign(F)
    };
    def hasInfo: B = {
      messages.withFilter(((m) => m.isInfo)).foreach(((m) => return _root_.org.sireum.helper.$assign(T)));
      return _root_.org.sireum.helper.$assign(F)
    };
    def hasMessage: B = return _root_.org.sireum.helper.$assign(messages.nonEmpty);
    def internalErrors: ISZ[Message] = return _root_.org.sireum.helper.$assign(messages.withFilter(((m) => m.isInternalError)).map(((m) => m)));
    def errors: ISZ[Message] = return _root_.org.sireum.helper.$assign(messages.withFilter(((m) => m.isError)).map(((m) => m)));
    def warnings: ISZ[Message] = return _root_.org.sireum.helper.$assign(messages.withFilter(((m) => m.isWarning)).map(((m) => m)));
    def issues: ISZ[Message] = return _root_.org.sireum.helper.$assign(messages.withFilter(((m) => m.isError.||(m.isWarning).||(m.isInternalError))).map(((m) => m)));
    def infos: ISZ[Message] = return _root_.org.sireum.helper.$assign(messages.withFilter(((m) => m.isInfo)).map(((m) => m)));
    def report(m: Message): Unit = if (ignore.`unary_!`)
      messages = _root_.org.sireum.helper.$assign(messages.:+(m))
    else
      ();
    def messagesByFileUri: HashSMap[Option[String], ISZ[Message]] = {
      var r = _root_.org.sireum.helper.$assign(HashSMap.empty[Option[String], ISZ[Message]]);
      messages.foreach(((m) => {
        val key: Option[String] = _root_.org.sireum.helper.$assign(m.fileUriOpt);
        _root_.org.sireum.helper.$tmatch(r.get(key)) match {
          case Some((ms @ _)) => r = _root_.org.sireum.helper.$assign(r.+(key.~>(ms.:+(m))))
          case _ => r = _root_.org.sireum.helper.$assign(r.+(key.~>(ISZ(m))))
        }
      }));
      return _root_.org.sireum.helper.$assign(r)
    };
    def printMessages(): Unit = {
      @pure def sortMessages(ms: ISZ[Message]): ISZ[Message] = return _root_.org.sireum.helper.$assign(ops.ISZOps(ms).sortWith(((m1, m2) => _root_.org.sireum.helper.$tmatch(scala.Tuple2(m1.posOpt, m2.posOpt)) match {
        case scala.Tuple2(Some((m1pos @ _)), Some((m2pos @ _))) => if (m1pos.beginLine.<(m2pos.beginLine))
          T
        else
          if (m1pos.beginLine.>(m2pos.beginLine))
            F
          else
            if (m1pos.beginColumn.<(m2pos.beginColumn))
              T
            else
              if (m1pos.beginColumn.>(m2pos.beginColumn))
                F
              else
                m1.text.size.<(m2.text.size)
        case _ => m1.text.size.<(m2.text.size)
      })));
      val map = _root_.org.sireum.helper.$assign(messagesByFileUri);
      val err = _root_.org.sireum.helper.$assign(hasError);
      var first = _root_.org.sireum.helper.$assign(T);
      map.entries.foreach(((kv) => {
        if (first.`unary_!`)
          cprintln(err, _root_.org.sireum.String(""))
        else
          ();
        first = _root_.org.sireum.helper.$assign(F);
        val fileUriOpt = _root_.org.sireum.helper.$assign(kv._1);
        val ms = _root_.org.sireum.helper.$assign(kv._2);
        _root_.org.sireum.helper.$tmatch(fileUriOpt) match {
          case Some((fileUri @ _)) => {
            cprintln(err, StringContext("* ", "").s(fileUri));
            sortMessages(ms).foreach(((m) => {
              cprint(err, _root_.org.sireum.String("  "));
              val int: String = _root_.org.sireum.helper.$assign(if (m.level.==(Level.InternalError))
                _root_.org.sireum.String("INTERNAL ERROR -- ")
              else
                _root_.org.sireum.String(""));
              val mText: String = _root_.org.sireum.helper.$assign((_root_.org.sireum.helper.$tmatch(m.posOpt) match {
                case Some((pos @ _)) => StringContext("- [", ", ", "] ", "", "").s(pos.beginLine, pos.beginColumn, int, m.text)
                case _ => StringContext("- ", "").s(m.text)
              }));
              cprintln(err, mText)
            }))
          }
          case _ => sortMessages(ms).foreach(((m) => {
            val int: String = _root_.org.sireum.helper.$assign(if (m.level.==(Level.InternalError))
              _root_.org.sireum.String("INTERNAL ERROR -- ")
            else
              _root_.org.sireum.String(""));
            val mText: String = _root_.org.sireum.helper.$assign((_root_.org.sireum.helper.$tmatch(m.posOpt) match {
              case Some((pos @ _)) => StringContext("- [", ", ", "] ", "", "").s(pos.beginLine, pos.beginColumn, int, m.text)
              case _ => StringContext("- ", "").s(m.text)
            }));
            cprintln(err, mText)
          }))
        }
      }))
    };
    def internalError(posOpt: Option[Position], kind: String, message: String): Unit = if (ignore.`unary_!`)
      report(Message(Level.InternalError, posOpt, kind, message))
    else
      ();
    def error(posOpt: Option[Position], kind: String, message: String): Unit = if (ignore.`unary_!`)
      report(Message(Level.Error, posOpt, kind, message))
    else
      ();
    def warn(posOpt: Option[Position], kind: String, message: String): Unit = if (ignore.`unary_!`)
      report(Message(Level.Warning, posOpt, kind, message))
    else
      ();
    def info(posOpt: Option[Position], kind: String, message: String): Unit = if (ignore.`unary_!`)
      report(Message(Level.Info, posOpt, kind, message))
    else
      ();
    def reports(ms: ISZ[Message]): Unit = ms.foreach(((m) => report(m)))
  }
}