package org.sireum {
  object Poset {
    type Index = Z;
    object Internal {
      val emptySet: HashSet[Poset.Index] = _root_.org.sireum.helper.$assign(HashSet.empty);
      @pure def addNode[T](poset: Poset[T], node: T): scala.Tuple2[Poset[T], Index] = _root_.org.sireum.helper.$tmatch(poset.nodes.get(node)) match {
        case Some((n @ _)) => return _root_.org.sireum.helper.$assign(scala.Tuple2(_root_.org.sireum.helper.$assign(poset), _root_.org.sireum.helper.$assign(n)))
        case _ => {
          val n = _root_.org.sireum.helper.$assign(poset.nodes.size);
          return _root_.org.sireum.helper.$assign(scala.Tuple2(_root_.org.sireum.helper.$assign(poset(nodes = poset.nodes.+(node.~>(n)), nodesInverse = poset.nodesInverse.:+(node), parents = poset.parents.+(n.~>(emptySet)), children = poset.children.+(n.~>(emptySet)))), _root_.org.sireum.helper.$assign(n)))
        }
      };
      @pure def addNodes[T](poset: Poset[T], nodes: ISZ[T]): scala.Tuple2[Poset[T], ISZ[Index]] = {
        var r = _root_.org.sireum.helper.$assign(poset);
        val s = _root_.org.sireum.helper.$assign(ZS.create(nodes.size, _root_.org.sireum.Z(0)));
        var i = _root_.org.sireum.Z(0);
        nodes.foreach(((nd) => {
          val p = _root_.org.sireum.helper.$assign(addNode(r, nd));
          r = _root_.org.sireum.helper.$assign(p._1);
          s.update(i, _root_.org.sireum.helper.$assign(p._2));
          i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
        }));
        return _root_.org.sireum.helper.$assign(scala.Tuple2(_root_.org.sireum.helper.$assign(r), _root_.org.sireum.helper.$assign(s.toIS)))
      };
      @pure def addParents[T](poset: Poset[T], n: Index, ns: ISZ[Index]): Poset[T] = {
        var changed = _root_.org.sireum.helper.$assign(F);
        val newParents: HashMap[Index, HashSet[Index]] = _root_.org.sireum.helper.$assign({
          val s = _root_.org.sireum.helper.$assign(poset.parents.get(n).get);
          val newS = _root_.org.sireum.helper.$assign(s.++(ns));
          if (newS.size.!=(s.size))
            {
              changed = _root_.org.sireum.helper.$assign(T);
              poset.parents.+(n.~>(newS))
            }
          else
            poset.parents
        });
        var newChildren: HashMap[Index, HashSet[Index]] = _root_.org.sireum.helper.$assign(poset.children);
        ns.foreach(((c) => newChildren = _root_.org.sireum.helper.$assign({
          val s = _root_.org.sireum.helper.$assign(newChildren.get(c).get);
          val newS = _root_.org.sireum.helper.$assign(s.+(n));
          if (newS.size.!=(s.size))
            {
              changed = _root_.org.sireum.helper.$assign(T);
              newChildren.+(c.~>(newS))
            }
          else
            newChildren
        })));
        return _root_.org.sireum.helper.$assign(if (changed)
          poset(parents = newParents, children = newChildren)
        else
          poset)
      };
      @pure def removeParent[T](poset: Poset[T], n: Index, parent: Index): Poset[T] = _root_.org.sireum.helper.$tmatch(poset.parents.get(n)) match {
        case Some((s @ _)) => return _root_.org.sireum.helper.$assign(poset(parents = poset.parents.+(n.~>(s.-(parent))), children = poset.children.+(parent.~>(poset.children.get(parent).get.-(n)))))
        case _ => return _root_.org.sireum.helper.$assign(poset)
      };
      @pure def addChildren[T](poset: Poset[T], n: Index, ns: ISZ[Index]): Poset[T] = {
        var changed = _root_.org.sireum.helper.$assign(F);
        val newChildren: HashMap[Index, HashSet[Index]] = _root_.org.sireum.helper.$assign({
          val s = _root_.org.sireum.helper.$assign(poset.children.get(n).get);
          val newS = _root_.org.sireum.helper.$assign(s.++(ns));
          if (newS.size.!=(s.size))
            {
              changed = _root_.org.sireum.helper.$assign(T);
              poset.children.+(n.~>(newS))
            }
          else
            poset.children
        });
        var newParents: HashMap[Index, HashSet[Index]] = _root_.org.sireum.helper.$assign(poset.parents);
        ns.foreach(((c) => newParents = _root_.org.sireum.helper.$assign({
          val s = _root_.org.sireum.helper.$assign(newParents.get(c).get);
          val newS = _root_.org.sireum.helper.$assign(s.+(n));
          if (newS.size.!=(s.size))
            {
              changed = _root_.org.sireum.helper.$assign(T);
              newParents.+(c.~>(newS))
            }
          else
            newParents
        })));
        return _root_.org.sireum.helper.$assign(if (changed)
          poset(parents = newParents, children = newChildren)
        else
          poset)
      };
      @pure def childrenOf[T](poset: Poset[T], n: Index): HashSet[Index] = _root_.org.sireum.helper.$tmatch(poset.children.get(n)) match {
        case Some((s @ _)) => return _root_.org.sireum.helper.$assign(s)
        case _ => return _root_.org.sireum.helper.$assign(emptySet)
      };
      @pure def parentsOf[T](poset: Poset[T], n: Index): HashSet[Index] = _root_.org.sireum.helper.$tmatch(poset.parents.get(n)) match {
        case Some((s @ _)) => return _root_.org.sireum.helper.$assign(s)
        case _ => return _root_.org.sireum.helper.$assign(emptySet)
      };
      @pure def ancestorsOf[T](poset: Poset[T], n: Index): HashSet[Index] = return _root_.org.sireum.helper.$assign(ancestorsCache[T](poset, n, HashMap.empty)._1);
      @pure def ancestorsCache[T](poset: Poset[T], n: Index, acc: HashMap[Index, HashSet[Index]]): scala.Tuple2[HashSet[Index], HashMap[Index, HashSet[Index]]] = {
        var mAcc = _root_.org.sireum.helper.$assign(acc);
        var r = _root_.org.sireum.helper.$assign(emptySet);
        parentsOf(poset, n).elements.foreach(((nParent) => {
          mAcc = _root_.org.sireum.helper.$assign(ancestorsRec(poset, nParent, mAcc));
          r = _root_.org.sireum.helper.$assign(r.+(nParent).∪(mAcc.get(nParent).getOrElse(emptySet)))
        }));
        return _root_.org.sireum.helper.$assign(scala.Tuple2(_root_.org.sireum.helper.$assign(r), _root_.org.sireum.helper.$assign(mAcc)))
      };
      @pure def ancestorsRec[T](poset: Poset[T], m: Index, acc: HashMap[Index, HashSet[Index]]): HashMap[Index, HashSet[Index]] = {
        if (acc.contains(m))
          return _root_.org.sireum.helper.$assign(acc)
        else
          ();
        val p = _root_.org.sireum.helper.$assign(ancestorsCache(poset, m, acc.+(m.~>(emptySet))));
        val mAncestors = _root_.org.sireum.helper.$assign(p._1);
        val mAcc = _root_.org.sireum.helper.$assign(p._2);
        return _root_.org.sireum.helper.$assign(mAcc.+(m.~>(mAncestors)))
      };
      @pure def lub[T](poset: Poset[T], ns: ISZ[Index]): Option[Index] = {
        _root_.org.sireum.helper.$tmatch(ns.size) match {
          case StringContext("0").z() => return _root_.org.sireum.helper.$assign(None())
          case StringContext("1").z() => return _root_.org.sireum.helper.$assign(Some(ns(_root_.org.sireum.Z(0))))
          case _ => ()
        };
        if (HashSet.++(ns).size.==(_root_.org.sireum.Z(1)))
          return _root_.org.sireum.helper.$assign(Some(ns(_root_.org.sireum.Z(0))))
        else
          ();
        val p0 = _root_.org.sireum.helper.$assign(ancestorsCache[T](poset, ns(_root_.org.sireum.Z(0)), HashMap.empty));
        var commons = _root_.org.sireum.helper.$assign(p0._1.+(ns(_root_.org.sireum.Z(0))));
        var acc = _root_.org.sireum.helper.$assign(p0._2);
        StringContext("1").z().until(ns.size).foreach(((i) => {
          val p = _root_.org.sireum.helper.$assign(ancestorsCache(poset, ns(i), acc));
          acc = _root_.org.sireum.helper.$assign(p._2);
          commons = _root_.org.sireum.helper.$assign(commons.∩(p._1.+(ns(i))))
        }));
        if (commons.isEmpty)
          return _root_.org.sireum.helper.$assign(None())
        else
          ();
        commons.elements.foreach(((b1) => commons.elements.withFilter(((b2) => b1.!=(b2))).foreach(((b2) => if (ancestorsCache(poset, b1, acc)._1.contains(b2))
          commons = _root_.org.sireum.helper.$assign(commons.-(b2))
        else
          ()))));
        if (commons.size.==(_root_.org.sireum.Z(1)))
          return _root_.org.sireum.helper.$assign(Some(commons.elements(_root_.org.sireum.Z(0))))
        else
          return _root_.org.sireum.helper.$assign(None())
      };
      @pure def descendantsOf[T](poset: Poset[T], n: Index): HashSet[Index] = return _root_.org.sireum.helper.$assign(descendantsCache[T](poset, n, HashMap.empty)._1);
      @pure def descendantsCache[T](poset: Poset[T], n: Index, acc: HashMap[Index, HashSet[Index]]): scala.Tuple2[HashSet[Index], HashMap[Index, HashSet[Index]]] = {
        var mAcc = _root_.org.sireum.helper.$assign(acc);
        var r = _root_.org.sireum.helper.$assign(emptySet);
        childrenOf(poset, n).elements.foreach(((nChild) => {
          mAcc = _root_.org.sireum.helper.$assign(descendantsRec(poset, nChild, mAcc));
          r = _root_.org.sireum.helper.$assign(r.+(nChild).∪(mAcc.get(nChild).getOrElse(emptySet)))
        }));
        return _root_.org.sireum.helper.$assign(scala.Tuple2(_root_.org.sireum.helper.$assign(r), _root_.org.sireum.helper.$assign(mAcc)))
      };
      @pure def descendantsRec[T](poset: Poset[T], m: Index, acc: HashMap[Index, HashSet[Index]]): HashMap[Index, HashSet[Index]] = {
        if (acc.contains(m))
          return _root_.org.sireum.helper.$assign(acc)
        else
          ();
        val p = _root_.org.sireum.helper.$assign(descendantsCache(poset, m, acc.+(m.~>(emptySet))));
        val mDescendants = _root_.org.sireum.helper.$assign(p._1);
        val mAcc = _root_.org.sireum.helper.$assign(p._2);
        return _root_.org.sireum.helper.$assign(mAcc.+(m.~>(mDescendants)))
      };
      @pure def glb[T](poset: Poset[T], ns: ISZ[Index]): Option[Index] = {
        _root_.org.sireum.helper.$tmatch(ns.size) match {
          case StringContext("0").z() => return _root_.org.sireum.helper.$assign(None())
          case StringContext("1").z() => return _root_.org.sireum.helper.$assign(Some(ns(_root_.org.sireum.Z(0))))
          case _ => ()
        };
        if (HashSet.empty[Index].++(ns).size.==(_root_.org.sireum.Z(1)))
          return _root_.org.sireum.helper.$assign(Some(ns(_root_.org.sireum.Z(0))))
        else
          ();
        val p0 = _root_.org.sireum.helper.$assign(descendantsCache[T](poset, ns(_root_.org.sireum.Z(0)), HashMap.empty));
        var commons = _root_.org.sireum.helper.$assign(p0._1.+(ns(_root_.org.sireum.Z(0))));
        var acc = _root_.org.sireum.helper.$assign(p0._2);
        StringContext("1").z().until(ns.size).foreach(((i) => {
          val p = _root_.org.sireum.helper.$assign(descendantsCache(poset, ns(i), acc));
          acc = _root_.org.sireum.helper.$assign(p._2);
          commons = _root_.org.sireum.helper.$assign(commons.∩(p._1.+(ns(i))))
        }));
        if (commons.isEmpty)
          return _root_.org.sireum.helper.$assign(None())
        else
          ();
        commons.elements.foreach(((b1) => commons.elements.withFilter(((b2) => b1.!=(b2))).foreach(((b2) => if (descendantsCache(poset, b1, acc)._1.contains(b2))
          commons = _root_.org.sireum.helper.$assign(commons.-(b2))
        else
          ()))));
        if (commons.size.==(_root_.org.sireum.Z(1)))
          return _root_.org.sireum.helper.$assign(Some(commons.elements(_root_.org.sireum.Z(0))))
        else
          return _root_.org.sireum.helper.$assign(None())
      }
    };
    def empty[T]: Poset[T] = return _root_.org.sireum.helper.$assign(Poset[T](HashMap.empty, ISZ(), HashMap.empty, HashMap.empty));
    def apply[T](nodes: HashMap[T, Z], nodesInverse: IS[Z, T], parents: HashMap[Z, HashSet[Z]], children: HashMap[Z, HashSet[Z]]): Poset[T] = new Poset(nodes, nodesInverse, parents, children);
    def unapply[T](o: Poset[T]): _root_.scala.Option[scala.Tuple4[HashMap[T, Z], IS[Z, T], HashMap[Z, HashSet[Z]], HashMap[Z, HashSet[Z]]]] = _root_.scala.Some(scala.Tuple4(o.nodes, o.nodesInverse, o.parents, o.children))
  }

  import Poset._

  @datatype final class Poset[T](__nodes: HashMap[T, Z], __nodesInverse: IS[Z, T], __parents: HashMap[Z, HashSet[Z]], __children: HashMap[Z, HashSet[Z]]) extends _root_.org.sireum.DatatypeSig {
    private[this] val _nodes = __nodes;
    def nodes = _nodes;
    def getNodes = _nodes;
    private[this] val _nodesInverse = __nodesInverse;
    def nodesInverse = _nodesInverse;
    def getNodesInverse = _nodesInverse;
    private[this] val _parents = __parents;
    def parents = _parents;
    def getParents = _parents;
    private[this] val _children = __children;
    def children = _children;
    def getChildren = _children;
    override def toString: _root_.java.lang.String = string.value;
    override lazy val hashCode: _root_.scala.Int = hash.hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): Poset[T] @unchecked)) => isEqual(o)
        case _ => halt("Invalid equality test between ".+(this.getClass).+(" and ").+(o.getClass))
      };
    def apply(nodes: HashMap[T, Z] = this.nodes, nodesInverse: IS[Z, T] = this.nodesInverse, parents: HashMap[Z, HashSet[Z]] = this.parents, children: HashMap[Z, HashSet[Z]] = this.children): Poset[T] = new Poset(nodes, nodesInverse, parents, children);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Poset")), scala.Tuple2("nodes", this.nodes), scala.Tuple2("nodesInverse", this.nodesInverse), scala.Tuple2("parents", this.parents), scala.Tuple2("children", this.children));
    val emptySet: HashSet[T] = _root_.org.sireum.helper.$assign(HashSet.empty);
    @pure def size: Z = return _root_.org.sireum.helper.$assign(nodes.size);
    @pure override def hash: Z = return _root_.org.sireum.helper.$assign(size);
    @pure def isEqual(other: Poset[T]): B = {
      if (nodesInverse.!=(other.nodesInverse))
        return _root_.org.sireum.helper.$assign(F)
      else
        ();
      nodes.keys.foreach(((node) => {
        val n = _root_.org.sireum.helper.$assign(nodes.get(node).get);
        val m = _root_.org.sireum.helper.$assign(other.nodes.get(node).get);
        val nParents = _root_.org.sireum.helper.$assign(HashSet.++(parents.get(n).get.elements.map[T](((np) => nodesInverse(np)))));
        val mParents = _root_.org.sireum.helper.$assign(HashSet.++(other.parents.get(m).get.elements.map[T](((mp) => other.nodesInverse(mp)))));
        if (nParents.!=(mParents))
          return _root_.org.sireum.helper.$assign(F)
        else
          ()
      }));
      return _root_.org.sireum.helper.$assign(T)
    };
    @pure def addNode(node: T): Poset[T] = return _root_.org.sireum.helper.$assign(Poset.Internal.addNode(this, node)._1);
    @pure def rootNodes: ISZ[T] = return _root_.org.sireum.helper.$assign(parents.entries.withFilter(((e) => e._2.isEmpty)).map(((e) => nodesInverse(e._1))));
    @pure def addParents(node: T, nds: ISZ[T]): Poset[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      val n: Index = _root_.org.sireum.helper.$assign({
        val p = _root_.org.sireum.helper.$assign(Poset.Internal.addNode(r, node));
        r = _root_.org.sireum.helper.$assign(p._1);
        p._2
      });
      val ns: ISZ[Index] = _root_.org.sireum.helper.$assign({
        val p = _root_.org.sireum.helper.$assign(Poset.Internal.addNodes(r, nds));
        r = _root_.org.sireum.helper.$assign(p._1);
        p._2
      });
      return _root_.org.sireum.helper.$assign(Poset.Internal.addParents(r, n, ns))
    };
    @pure def removeParent(node: T, parent: T): Poset[T] = _root_.org.sireum.helper.$tmatch(scala.Tuple2(nodes.get(node), nodes.get(parent))) match {
      case scala.Tuple2(Some((n @ _)), Some((p @ _))) => return _root_.org.sireum.helper.$assign(Poset.Internal.removeParent(this, n, p))
      case _ => return _root_.org.sireum.helper.$assign(this)
    };
    @pure def removeChild(n: T, child: T): Poset[T] = return _root_.org.sireum.helper.$assign(removeParent(child, n));
    @pure def addChildren(node: T, nds: ISZ[T]): Poset[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      val n: Index = _root_.org.sireum.helper.$assign({
        val p = _root_.org.sireum.helper.$assign(Poset.Internal.addNode(r, node));
        r = _root_.org.sireum.helper.$assign(p._1);
        p._2
      });
      val ns: ISZ[Index] = _root_.org.sireum.helper.$assign({
        val p = _root_.org.sireum.helper.$assign(Poset.Internal.addNodes(r, nds));
        r = _root_.org.sireum.helper.$assign(p._1);
        p._2
      });
      return _root_.org.sireum.helper.$assign(Poset.Internal.addChildren(r, n, ns))
    };
    @pure def childrenOf(node: T): HashSet[T] = _root_.org.sireum.helper.$tmatch(nodes.get(node)) match {
      case Some((n @ _)) => HashSet.++(Poset.Internal.childrenOf(this, n).elements.map[T](((n) => nodesInverse(n))))
      case _ => return _root_.org.sireum.helper.$assign(emptySet)
    };
    @pure def isChildOf(node1: T, node2: T): B = _root_.org.sireum.helper.$tmatch(scala.Tuple2(nodes.get(node1), nodes.get(node2))) match {
      case scala.Tuple2(Some((n1 @ _)), Some((n2 @ _))) => return _root_.org.sireum.helper.$assign(Poset.Internal.childrenOf(this, n1).contains(n2))
      case _ => return _root_.org.sireum.helper.$assign(F)
    };
    @pure def parentsOf(node: T): HashSet[T] = _root_.org.sireum.helper.$tmatch(nodes.get(node)) match {
      case Some((n @ _)) => HashSet.++(Poset.Internal.parentsOf(this, n).elements.map[T](((n) => nodesInverse(n))))
      case _ => return _root_.org.sireum.helper.$assign(emptySet)
    };
    @pure def isParentOf(node1: T, node2: T): B = return _root_.org.sireum.helper.$assign(isChildOf(node2, node1));
    @pure def ancestorsOf(node: T): HashSet[T] = _root_.org.sireum.helper.$tmatch(nodes.get(node)) match {
      case Some((n @ _)) => HashSet.++(Poset.Internal.ancestorsOf(this, n).elements.map[T](((n) => nodesInverse(n))))
      case _ => return _root_.org.sireum.helper.$assign(emptySet)
    };
    @pure def lub(nds: ISZ[T]): Option[T] = {
      val ns: ISZ[Index] = _root_.org.sireum.helper.$assign(nds.flatMap(((node) => nodes.get(node).toIS.map(((n) => n)))));
      return _root_.org.sireum.helper.$assign(Poset.Internal.lub(this, ns).map(((n) => nodesInverse(n))))
    };
    @pure def descendantsOf(node: T): HashSet[T] = _root_.org.sireum.helper.$tmatch(nodes.get(node)) match {
      case Some((n @ _)) => HashSet.++(Poset.Internal.descendantsOf(this, n).elements.map[T](((n) => nodesInverse(n))))
      case _ => return _root_.org.sireum.helper.$assign(emptySet)
    };
    @pure def glb(nds: ISZ[T]): Option[T] = {
      val ns: ISZ[Index] = _root_.org.sireum.helper.$assign(nds.flatMap(((node) => nodes.get(node).toIS.map(((n) => n)))));
      return _root_.org.sireum.helper.$assign(Poset.Internal.glb(this, ns).map(((n) => nodesInverse(n))))
    };
    @pure def toST(f: _root_.scala.Function1[T, ST]): ST = {
      val nodes: ISZ[ST] = _root_.org.sireum.helper.$assign(this.nodes.entries.map(((e) => StringContext("n", " ", "").st(e._2, f(e._1)))));
      val edges: ISZ[ST] = _root_.org.sireum.helper.$assign(parents.entries.flatMap(((entry) => entry._2.elements.map(((parent) => StringContext("n", " -> n", "").st(entry._1, parent))))));
      val r = StringContext("""digraph G {
      |  rankdir="BT"
      |
      |  """, """
      |
      |  """, """
      |}""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(nodes), _root_.org.sireum.String("\n")), scala.Tuple2(_root_.org.sireum.helper.$assign(edges), _root_.org.sireum.String("\n")));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure override def string: String = return _root_.org.sireum.helper.$assign(toST(((node) => StringContext("[label=\"", "\"]").st(node))).render)
  }
}