package org.sireum.ops {
  import org.sireum.Graph

  import org.sireum._

  object GraphOps {
    def apply[V, E](graph: Graph[V, E]): GraphOps[V, E] = new GraphOps(graph);
    def unapply[V, E](o: GraphOps[V, E]): _root_.scala.Option[Graph[V, E]] = _root_.scala.Some(o.graph)
  }

  @datatype final class GraphOps[V, E](__graph: Graph[V, E]) extends _root_.org.sireum.DatatypeSig {
    private[this] val _graph = __graph;
    def graph = _graph;
    def getGraph = _graph;
    override def toString: _root_.java.lang.String = if ($hasString)
      super.string.value
    else
      {
        val sb = new _root_.java.lang.StringBuilder();
        sb.append("GraphOps");
        sb.append('(');
        sb.append(_root_.org.sireum.String.escape(this.graph));
        sb.append(')');
        sb.toString
      };
    override def string: _root_.org.sireum.String = if ($hasString)
      super.string
    else
      toString;
    override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      _root_.scala.Seq(this.getClass, graph).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): GraphOps[V, E] @unchecked)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            this.graph.==(o.graph)
          case _ => false
        };
    def apply(graph: Graph[V, E] = this.graph): GraphOps[V, E] = new GraphOps(graph);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "ops", "GraphOps")), scala.Tuple2("graph", this.graph));
    @pure def getEdgeData(e: Graph.Edge[V, E]): Option[E] = _root_.org.sireum.helper.$tmatch(e) match {
      case Graph.Edge.Data(_, _, (ed @ _)) => return _root_.org.sireum.helper.$assign(Some[E](ed))
      case _ => return _root_.org.sireum.helper.$assign(None[E]())
    };
    @pure def getAllSuccessor(v: V): Set[V] = if (graph.outgoingEdges.get(graph.nodes.get(v).get).nonEmpty)
      return _root_.org.sireum.helper.$assign(Set.empty[V].++(graph.outgoingEdges.get(graph.nodes.get(v).get).get.elements.map(((es) => graph.nodesInverse(es.dest)))))
    else
      return _root_.org.sireum.helper.$assign(Set.empty[V]);
    @pure def getAllPredecessor(v: V): Set[V] = if (graph.incomingEdges.get(graph.nodes.get(v).get).nonEmpty)
      return _root_.org.sireum.helper.$assign(Set.empty[V].++(graph.incomingEdges.get(graph.nodes.get(v).get).get.elements.map(((es) => graph.nodesInverse(es.source)))))
    else
      return _root_.org.sireum.helper.$assign(Set.empty[V]);
    @pure def getSCC: ISZ[HashSet[V]] = {
      var result = _root_.org.sireum.helper.$assign(ISZ[HashSet[V]]());
      var discoveryMap: HashMap[V, scala.Tuple2[B, B]] = _root_.org.sireum.helper.$assign(HashMap.++(graph.nodes.keys.map(((v) => scala.Tuple2(_root_.org.sireum.helper.$assign(v), _root_.org.sireum.helper.$assign(scala.Tuple2(_root_.org.sireum.helper.$assign(F), _root_.org.sireum.helper.$assign(F))))))));
      def resetDiscoveryMap(): Unit = discoveryMap = _root_.org.sireum.helper.$assign(HashMap.++(discoveryMap.entries.map(((e) => scala.Tuple2(_root_.org.sireum.helper.$assign(e._1), _root_.org.sireum.helper.$assign(scala.Tuple2(_root_.org.sireum.helper.$assign(F), _root_.org.sireum.helper.$assign(F))))))));
      def setDiscovered(v: V): B = return _root_.org.sireum.helper.$assign(discoveryMap.get(v).exists(((cf) => {
        discoveryMap = _root_.org.sireum.helper.$assign(discoveryMap.+(scala.Tuple2(_root_.org.sireum.helper.$assign(v), _root_.org.sireum.helper.$assign(scala.Tuple2(_root_.org.sireum.helper.$assign(T), _root_.org.sireum.helper.$assign(cf._2))))));
        T
      })));
      def setBoth(v: V): Unit = discoveryMap = _root_.org.sireum.helper.$assign(discoveryMap.+(scala.Tuple2(_root_.org.sireum.helper.$assign(v), _root_.org.sireum.helper.$assign(scala.Tuple2(_root_.org.sireum.helper.$assign(T), _root_.org.sireum.helper.$assign(T))))));
      def isAllMySuccDiscovered(v: V): B = return _root_.org.sireum.helper.$assign(ISZOps(getAllSuccessor(v).elements.flatMap(((s) => discoveryMap.get(s).toIS.map(((e) => e._1))))).foldLeft(((c: B, n: B) => c.&(n)), T));
      def dfs(v: V, isFirst: B): ISZ[V] = {
        var r = _root_.org.sireum.helper.$assign(ISZ[V]());
        var stack = _root_.org.sireum.helper.$assign(Stack.empty[V]);
        stack = _root_.org.sireum.helper.$assign(stack.push(v));
        while (stack.nonEmpty) 
          {
            val current = _root_.org.sireum.helper.$assign(stack.pop().get);
            stack = _root_.org.sireum.helper.$assign(current._2);
            if (discoveryMap.get(current._1).nonEmpty.&&(discoveryMap.get(current._1).get._1.`unary_!`))
              {
                setDiscovered(current._1);
                if (isFirst.`unary_!`)
                  r = _root_.org.sireum.helper.$assign(r.:+(current._1))
                else
                  ();
                setBoth(current._1);
                stack = _root_.org.sireum.helper.$assign(stack.push(current._1));
                val nexts: Set[V] = _root_.org.sireum.helper.$assign(if (isFirst)
                  getAllSuccessor(current._1)
                else
                  getAllPredecessor(current._1));
                nexts.elements.foreach(((n) => if (discoveryMap.get(n).get._1.`unary_!`)
                  stack = _root_.org.sireum.helper.$assign(stack.push(n))
                else
                  ()))
              }
            else
              if (discoveryMap.get(current._1).get._2.&&(isFirst))
                r = _root_.org.sireum.helper.$assign({
                  val x$1 = _root_.org.sireum.helper.$assign(current._1);
                  r.+:(x$1)
                })
              else
                ()
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      var orderedNodes = _root_.org.sireum.helper.$assign(ISZ[V]());
      graph.nodes.keys.foreach(((k) => if (discoveryMap.get(k).get._1.`unary_!`)
        orderedNodes = _root_.org.sireum.helper.$assign(dfs(k, T).++(orderedNodes))
      else
        ()));
      resetDiscoveryMap();
      orderedNodes.foreach(((k) => if (discoveryMap.get(k).get._1.`unary_!`)
        result = _root_.org.sireum.helper.$assign(result.:+(HashSet.empty[V].++(dfs(k, F))))
      else
        ()));
      return _root_.org.sireum.helper.$assign(result)
    };
    @pure def getCycles: ISZ[ISZ[V]] = {
      val sccs = _root_.org.sireum.helper.$assign(getSCC);
      var loops = _root_.org.sireum.helper.$assign(ISZ[ISZ[V]]());
      var bSets = _root_.org.sireum.helper.$assign(HashMap.empty[V, Set[V]]);
      var stack = _root_.org.sireum.helper.$assign(Stack.empty[V]);
      var marked = _root_.org.sireum.helper.$assign(Set.empty[V]);
      var removed = _root_.org.sireum.helper.$assign(HashMap.empty[V, Set[V]]);
      var position = _root_.org.sireum.helper.$assign(HashMap.empty[V, Z]);
      var reach = _root_.org.sireum.helper.$assign(HashMap.empty[V, B].++(graph.nodes.keys.map(((k) => scala.Tuple2(_root_.org.sireum.helper.$assign(k), _root_.org.sireum.helper.$assign(F))))));
      def cycle(v: V, tq: Z): B = {
        var q = _root_.org.sireum.helper.$assign(tq);
        var foundCycle = _root_.org.sireum.helper.$assign(F);
        marked = _root_.org.sireum.helper.$assign(marked.+(v));
        stack = _root_.org.sireum.helper.$assign(stack.push(v));
        val t = _root_.org.sireum.helper.$assign(stack.size);
        position = _root_.org.sireum.helper.$assign(position.+(scala.Tuple2(_root_.org.sireum.helper.$assign(v), _root_.org.sireum.helper.$assign(t))));
        if (reach.get(v).get.`unary_!`)
          q = _root_.org.sireum.helper.$assign(t)
        else
          ();
        val avRemoved: Set[V] = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(removed.get(v)) match {
          case Some((r @ _)) => r
          case _ => Set.empty[V]
        });
        getAllSuccessor(v).elements.foreach(((wV) => if (avRemoved.contains(wV).`unary_!`)
          if (marked.contains(wV).`unary_!`)
            {
              val gotCycle = _root_.org.sireum.helper.$assign(cycle(wV, q));
              if (gotCycle)
                foundCycle = _root_.org.sireum.helper.$assign(T)
              else
                noCycle(v, wV)
            }
          else
            if (position.get(wV).nonEmpty.&&(position.get(wV).get.<=(q)))
              {
                foundCycle = _root_.org.sireum.helper.$assign(T);
                var cycle = _root_.org.sireum.helper.$assign(ISZ[V]());
                val elements = _root_.org.sireum.helper.$assign(stack.elements);
                var current = _root_.org.sireum.helper.$assign(stack.peek.get);
                var break = _root_.org.sireum.helper.$assign(T);
                var i = _root_.org.sireum.Z(0);
                while (i.<(elements.size).&&(break)) 
                  {
                    current = _root_.org.sireum.helper.$assign(elements(i));
                    if (wV.==(current))
                      break = _root_.org.sireum.helper.$assign(F)
                    else
                      ();
                    i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
                  }
                ;
                cycle = _root_.org.sireum.helper.$assign(cycle.:+(wV));
                break = _root_.org.sireum.helper.$assign(T);
                while (i.<(elements.size).&&(break)) 
                  {
                    current = _root_.org.sireum.helper.$assign(elements(i));
                    cycle = _root_.org.sireum.helper.$assign(cycle.:+(current));
                    if (current.==(v))
                      break = _root_.org.sireum.helper.$assign(F)
                    else
                      ();
                    i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
                  }
                ;
                loops = _root_.org.sireum.helper.$assign(loops.:+(cycle))
              }
            else
              noCycle(v, wV)
        else
          ()));
        stack = _root_.org.sireum.helper.$assign(stack.pop().get._2);
        if (foundCycle)
          unmark(v)
        else
          ();
        reach = _root_.org.sireum.helper.$assign(reach.+(scala.Tuple2(_root_.org.sireum.helper.$assign(v), _root_.org.sireum.helper.$assign(T))));
        position = _root_.org.sireum.helper.$assign(position.+(scala.Tuple2(_root_.org.sireum.helper.$assign(v), _root_.org.sireum.helper.$assign(graph.nodes.size))));
        return _root_.org.sireum.helper.$assign(foundCycle)
      };
      def unmark(x: V): Unit = {
        marked = _root_.org.sireum.helper.$assign(marked.-(x));
        val temp: Set[V] = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(bSets.get(x)) match {
          case Some((bsx @ _)) => bsx
          case _ => Set.empty[V]
        });
        temp.elements.foreach(((y) => {
          val t: Set[V] = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(removed.get(y)) match {
            case Some((ry @ _)) => ry.-(x)
            case _ => Set.empty[V].-(x)
          });
          removed = _root_.org.sireum.helper.$assign(removed.+(scala.Tuple2(_root_.org.sireum.helper.$assign(y), _root_.org.sireum.helper.$assign(t))));
          if (marked.contains(y))
            unmark(y)
          else
            ()
        }));
        bSets = _root_.org.sireum.helper.$assign(bSets.+(scala.Tuple2(_root_.org.sireum.helper.$assign(x), _root_.org.sireum.helper.$assign(Set.empty[V]))))
      };
      def noCycle(x: V, y: V): Unit = {
        val t1: Set[V] = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(bSets.get(y)) match {
          case Some((bs @ _)) => bs
          case _ => Set.empty[V]
        });
        bSets = _root_.org.sireum.helper.$assign(bSets.+(scala.Tuple2(_root_.org.sireum.helper.$assign(y), _root_.org.sireum.helper.$assign(t1))));
        val t2: Set[V] = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(removed.get(x)) match {
          case Some((rx @ _)) => rx.+(y)
          case _ => Set.empty[V].+(y)
        });
        removed = _root_.org.sireum.helper.$assign(removed.+(scala.Tuple2(_root_.org.sireum.helper.$assign(x), _root_.org.sireum.helper.$assign(t2))))
      };
      var startNodes = _root_.org.sireum.helper.$assign(ISZ[V]());
      sccs.foreach(((scc) => {
        var max: Z = _root_.org.sireum.Z(-1);
        var startNode = _root_.org.sireum.helper.$assign(scc.elements(_root_.org.sireum.Z(0)));
        scc.elements.foreach(((node) => {
          val inDegree = _root_.org.sireum.helper.$assign(graph.incomingEdges.get(graph.nodes.get(node).get).get.size);
          if (inDegree.>(max))
            {
              max = _root_.org.sireum.helper.$assign(inDegree);
              startNode = _root_.org.sireum.helper.$assign(node)
            }
          else
            ()
        }));
        startNodes = _root_.org.sireum.helper.$assign(startNodes.:+(startNode))
      }));
      startNodes.foreach(((n) => cycle(n, _root_.org.sireum.Z(0))));
      return _root_.org.sireum.helper.$assign(loops)
    };
    @pure def forwardReach(criteria: ISZ[V]): ISZ[V] = {
      val r = _root_.org.sireum.helper.$assign(reachable(criteria, T));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def backwardReach(criteria: ISZ[V]): ISZ[V] = {
      val r = _root_.org.sireum.helper.$assign(reachable(criteria, F));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def reachable(criteria: ISZ[V], isForward: B): ISZ[V] = {
      var workList = _root_.org.sireum.helper.$assign(ISZ[V]());
      workList = _root_.org.sireum.helper.$assign(workList.++(criteria));
      var result = _root_.org.sireum.helper.$assign(HashSet.empty[V]);
      while (workList.nonEmpty) 
        {
          val current = _root_.org.sireum.helper.$assign(ISZOps(workList).first);
          if (result.contains(current).`unary_!`)
            {
              val next: Set[V] = _root_.org.sireum.helper.$assign(if (isForward)
                getAllSuccessor(current)
              else
                getAllPredecessor(current));
              workList = _root_.org.sireum.helper.$assign(workList.++(next.elements));
              result = _root_.org.sireum.helper.$assign(result.+(current))
            }
          else
            ();
          workList = _root_.org.sireum.helper.$assign(ISZOps(workList).tail)
        }
      ;
      return _root_.org.sireum.helper.$assign(result.elements)
    }
  }
}