package org.sireum {
  object Z8 extends _root_.org.sireum.$ZCompanion[Z8] {
    val Name: _root_.java.lang.String = "Z8";
    lazy val Min: Z8 = if (hasMin)
      new Z8(_root_.org.sireum.Z.MP("-128"))
    else
      halt("Unsupported Vector(Z8) operation \'Min\'");
    lazy val Max: Z8 = if (hasMax)
      new Z8(_root_.org.sireum.Z.MP("127"))
    else
      halt("Unsupported Vector(Z8) operation \'Max\'");
    val Index: Z8 = Z8(_root_.org.sireum.Z.MP("0"));
    val isZeroIndex: _root_.scala.Boolean = true;
    val isSigned: _root_.scala.Boolean = true;
    val isBitVector: _root_.scala.Boolean = false;
    val hasMin: _root_.scala.Boolean = true;
    val hasMax: _root_.scala.Boolean = true;
    def BitWidth: _root_.scala.Int = halt(StringContext("Unsupported ", " operation \'BitWidth\'").s(Name));
    def random: Z8 = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.random.%(d);
        Z8(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.random;
          Z8(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.random;
          Z8(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    def randomSeed(seed: _root_.org.sireum.Z): Z8 = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.randomSeed(seed).%(d);
        Z8(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          Z8(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          Z8(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    private def check(v: _root_.org.sireum.Z): _root_.org.sireum.Z = {
      if (hasMin)
        assert(Min.value.<=(v), v.+(" is less than Z8.Min (-128)"))
      else
        ();
      if (hasMax)
        assert(v.<=(Max.value), v.+(" is greater than Z8.Max (127)"))
      else
        ();
      v
    };
    def apply(n: _root_.scala.Int): Z8 = Int(n);
    def apply(n: _root_.scala.Long): Z8 = Long(n);
    def apply(n: _root_.org.sireum.Z): Z8 = new Z8(check(n));
    def apply(s: _root_.org.sireum.String): _root_.org.sireum.Option[Z8] = try {
      _root_.org.sireum.Some(Z8.$String(s.value))
    } catch {
      case ((_): _root_.java.lang.Throwable) => _root_.org.sireum.None[Z8]()
    };
    def unapply(n: Z8): _root_.scala.Option[_root_.org.sireum.Z] = _root_.scala.Some(n.value);
    object Int extends _root_.org.sireum.$ZCompanionInt[Z8] {
      def apply(n: _root_.scala.Int): Z8 = Z8(_root_.org.sireum.Z.MP(n));
      def unapply(n: Z8): _root_.scala.Option[_root_.scala.Int] = if (_root_.scala.Int.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Int.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toInt)
      else
        _root_.scala.None
    };
    object Long extends _root_.org.sireum.$ZCompanionLong[Z8] {
      def apply(n: _root_.scala.Long): Z8 = Z8(_root_.org.sireum.Z.MP(n));
      def unapply(n: Z8): _root_.scala.Option[_root_.scala.Long] = if (_root_.scala.Long.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Long.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toLong)
      else
        _root_.scala.None
    };
    object $String extends _root_.org.sireum.$ZCompanionString[Z8] {
      def apply(s: _root_.java.lang.String): Z8 = BigInt(_root_.org.sireum.Z.$String(s).toBigInt);
      def unapply(n: Z8): _root_.scala.Option[_root_.java.lang.String] = _root_.scala.Some(n.toBigInt.toString)
    };
    object BigInt extends _root_.org.sireum.$ZCompanionBigInt[Z8] {
      def apply(n: _root_.scala.BigInt): Z8 = Z8(_root_.org.sireum.Z.MP(n));
      def unapply(n: Z8): _root_.scala.Option[_root_.scala.BigInt] = _root_.scala.Some(n.toBigInt)
    };
    implicit class Z8$Slang(val sc: _root_.scala.StringContext) {
      object z8 {
        def apply(args: _root_.scala.Any*): Z8 = {
          assume(args.isEmpty.&&(sc.parts.length.==(1)));
          $String(sc.parts.head)
        };
        def unapply(n: Z8): _root_.scala.Boolean = {
          assume(sc.parts.length.==(1));
          n.==($String(sc.parts.head))
        }
      }
    };
    implicit val $Z8Companion: _root_.org.sireum.$ZCompanion[Z8] = this;
    object Boxer extends _root_.org.sireum.Z.Boxer.Byte {
      def make(o: _root_.scala.Byte): Z8 = Z8(_root_.org.sireum.Z.MP(o))
    }
  }

  final class Z8(val value: _root_.org.sireum.Z) extends _root_.scala.AnyVal with _root_.org.sireum.Z.Range[Z8] {
    @inline def Name: _root_.java.lang.String = Z8.Name;
    @inline def Min: Z8 = Z8.Min;
    @inline def Max: Z8 = Z8.Max;
    @inline def Index: Z8 = Z8.Index;
    @inline def isZeroIndex: _root_.scala.Boolean = Z8.isZeroIndex;
    @inline def isSigned: _root_.scala.Boolean = Z8.isSigned;
    @inline def hasMin: _root_.scala.Boolean = Z8.hasMin;
    @inline def hasMax: _root_.scala.Boolean = Z8.hasMax;
    def make(v: _root_.org.sireum.Z): Z8 = Z8(v);
    def boxer = Z8.Boxer
  }

  object Z16 extends _root_.org.sireum.$ZCompanion[Z16] {
    val Name: _root_.java.lang.String = "Z16";
    lazy val Min: Z16 = if (hasMin)
      new Z16(_root_.org.sireum.Z.MP("-32768"))
    else
      halt("Unsupported Vector(Z16) operation \'Min\'");
    lazy val Max: Z16 = if (hasMax)
      new Z16(_root_.org.sireum.Z.MP("32767"))
    else
      halt("Unsupported Vector(Z16) operation \'Max\'");
    val Index: Z16 = Z16(_root_.org.sireum.Z.MP("0"));
    val isZeroIndex: _root_.scala.Boolean = true;
    val isSigned: _root_.scala.Boolean = true;
    val isBitVector: _root_.scala.Boolean = false;
    val hasMin: _root_.scala.Boolean = true;
    val hasMax: _root_.scala.Boolean = true;
    def BitWidth: _root_.scala.Int = halt(StringContext("Unsupported ", " operation \'BitWidth\'").s(Name));
    def random: Z16 = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.random.%(d);
        Z16(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.random;
          Z16(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.random;
          Z16(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    def randomSeed(seed: _root_.org.sireum.Z): Z16 = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.randomSeed(seed).%(d);
        Z16(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          Z16(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          Z16(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    private def check(v: _root_.org.sireum.Z): _root_.org.sireum.Z = {
      if (hasMin)
        assert(Min.value.<=(v), v.+(" is less than Z16.Min (-32768)"))
      else
        ();
      if (hasMax)
        assert(v.<=(Max.value), v.+(" is greater than Z16.Max (32767)"))
      else
        ();
      v
    };
    def apply(n: _root_.scala.Int): Z16 = Int(n);
    def apply(n: _root_.scala.Long): Z16 = Long(n);
    def apply(n: _root_.org.sireum.Z): Z16 = new Z16(check(n));
    def apply(s: _root_.org.sireum.String): _root_.org.sireum.Option[Z16] = try {
      _root_.org.sireum.Some(Z16.$String(s.value))
    } catch {
      case ((_): _root_.java.lang.Throwable) => _root_.org.sireum.None[Z16]()
    };
    def unapply(n: Z16): _root_.scala.Option[_root_.org.sireum.Z] = _root_.scala.Some(n.value);
    object Int extends _root_.org.sireum.$ZCompanionInt[Z16] {
      def apply(n: _root_.scala.Int): Z16 = Z16(_root_.org.sireum.Z.MP(n));
      def unapply(n: Z16): _root_.scala.Option[_root_.scala.Int] = if (_root_.scala.Int.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Int.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toInt)
      else
        _root_.scala.None
    };
    object Long extends _root_.org.sireum.$ZCompanionLong[Z16] {
      def apply(n: _root_.scala.Long): Z16 = Z16(_root_.org.sireum.Z.MP(n));
      def unapply(n: Z16): _root_.scala.Option[_root_.scala.Long] = if (_root_.scala.Long.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Long.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toLong)
      else
        _root_.scala.None
    };
    object $String extends _root_.org.sireum.$ZCompanionString[Z16] {
      def apply(s: _root_.java.lang.String): Z16 = BigInt(_root_.org.sireum.Z.$String(s).toBigInt);
      def unapply(n: Z16): _root_.scala.Option[_root_.java.lang.String] = _root_.scala.Some(n.toBigInt.toString)
    };
    object BigInt extends _root_.org.sireum.$ZCompanionBigInt[Z16] {
      def apply(n: _root_.scala.BigInt): Z16 = Z16(_root_.org.sireum.Z.MP(n));
      def unapply(n: Z16): _root_.scala.Option[_root_.scala.BigInt] = _root_.scala.Some(n.toBigInt)
    };
    implicit class Z16$Slang(val sc: _root_.scala.StringContext) {
      object z16 {
        def apply(args: _root_.scala.Any*): Z16 = {
          assume(args.isEmpty.&&(sc.parts.length.==(1)));
          $String(sc.parts.head)
        };
        def unapply(n: Z16): _root_.scala.Boolean = {
          assume(sc.parts.length.==(1));
          n.==($String(sc.parts.head))
        }
      }
    };
    implicit val $Z16Companion: _root_.org.sireum.$ZCompanion[Z16] = this;
    object Boxer extends _root_.org.sireum.Z.Boxer.Short {
      def make(o: _root_.scala.Short): Z16 = Z16(_root_.org.sireum.Z.MP(o))
    }
  }

  final class Z16(val value: _root_.org.sireum.Z) extends _root_.scala.AnyVal with _root_.org.sireum.Z.Range[Z16] {
    @inline def Name: _root_.java.lang.String = Z16.Name;
    @inline def Min: Z16 = Z16.Min;
    @inline def Max: Z16 = Z16.Max;
    @inline def Index: Z16 = Z16.Index;
    @inline def isZeroIndex: _root_.scala.Boolean = Z16.isZeroIndex;
    @inline def isSigned: _root_.scala.Boolean = Z16.isSigned;
    @inline def hasMin: _root_.scala.Boolean = Z16.hasMin;
    @inline def hasMax: _root_.scala.Boolean = Z16.hasMax;
    def make(v: _root_.org.sireum.Z): Z16 = Z16(v);
    def boxer = Z16.Boxer
  }

  object Z32 extends _root_.org.sireum.$ZCompanion[Z32] {
    val Name: _root_.java.lang.String = "Z32";
    lazy val Min: Z32 = if (hasMin)
      new Z32(_root_.org.sireum.Z.MP("-2147483648"))
    else
      halt("Unsupported Vector(Z32) operation \'Min\'");
    lazy val Max: Z32 = if (hasMax)
      new Z32(_root_.org.sireum.Z.MP("2147483647"))
    else
      halt("Unsupported Vector(Z32) operation \'Max\'");
    val Index: Z32 = Z32(_root_.org.sireum.Z.MP("0"));
    val isZeroIndex: _root_.scala.Boolean = true;
    val isSigned: _root_.scala.Boolean = true;
    val isBitVector: _root_.scala.Boolean = false;
    val hasMin: _root_.scala.Boolean = true;
    val hasMax: _root_.scala.Boolean = true;
    def BitWidth: _root_.scala.Int = halt(StringContext("Unsupported ", " operation \'BitWidth\'").s(Name));
    def random: Z32 = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.random.%(d);
        Z32(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.random;
          Z32(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.random;
          Z32(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    def randomSeed(seed: _root_.org.sireum.Z): Z32 = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.randomSeed(seed).%(d);
        Z32(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          Z32(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          Z32(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    private def check(v: _root_.org.sireum.Z): _root_.org.sireum.Z = {
      if (hasMin)
        assert(Min.value.<=(v), v.+(" is less than Z32.Min (-2147483648)"))
      else
        ();
      if (hasMax)
        assert(v.<=(Max.value), v.+(" is greater than Z32.Max (2147483647)"))
      else
        ();
      v
    };
    def apply(n: _root_.scala.Int): Z32 = Int(n);
    def apply(n: _root_.scala.Long): Z32 = Long(n);
    def apply(n: _root_.org.sireum.Z): Z32 = new Z32(check(n));
    def apply(s: _root_.org.sireum.String): _root_.org.sireum.Option[Z32] = try {
      _root_.org.sireum.Some(Z32.$String(s.value))
    } catch {
      case ((_): _root_.java.lang.Throwable) => _root_.org.sireum.None[Z32]()
    };
    def unapply(n: Z32): _root_.scala.Option[_root_.org.sireum.Z] = _root_.scala.Some(n.value);
    object Int extends _root_.org.sireum.$ZCompanionInt[Z32] {
      def apply(n: _root_.scala.Int): Z32 = Z32(_root_.org.sireum.Z.MP(n));
      def unapply(n: Z32): _root_.scala.Option[_root_.scala.Int] = if (_root_.scala.Int.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Int.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toInt)
      else
        _root_.scala.None
    };
    object Long extends _root_.org.sireum.$ZCompanionLong[Z32] {
      def apply(n: _root_.scala.Long): Z32 = Z32(_root_.org.sireum.Z.MP(n));
      def unapply(n: Z32): _root_.scala.Option[_root_.scala.Long] = if (_root_.scala.Long.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Long.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toLong)
      else
        _root_.scala.None
    };
    object $String extends _root_.org.sireum.$ZCompanionString[Z32] {
      def apply(s: _root_.java.lang.String): Z32 = BigInt(_root_.org.sireum.Z.$String(s).toBigInt);
      def unapply(n: Z32): _root_.scala.Option[_root_.java.lang.String] = _root_.scala.Some(n.toBigInt.toString)
    };
    object BigInt extends _root_.org.sireum.$ZCompanionBigInt[Z32] {
      def apply(n: _root_.scala.BigInt): Z32 = Z32(_root_.org.sireum.Z.MP(n));
      def unapply(n: Z32): _root_.scala.Option[_root_.scala.BigInt] = _root_.scala.Some(n.toBigInt)
    };
    implicit class Z32$Slang(val sc: _root_.scala.StringContext) {
      object z32 {
        def apply(args: _root_.scala.Any*): Z32 = {
          assume(args.isEmpty.&&(sc.parts.length.==(1)));
          $String(sc.parts.head)
        };
        def unapply(n: Z32): _root_.scala.Boolean = {
          assume(sc.parts.length.==(1));
          n.==($String(sc.parts.head))
        }
      }
    };
    implicit val $Z32Companion: _root_.org.sireum.$ZCompanion[Z32] = this;
    object Boxer extends _root_.org.sireum.Z.Boxer.Int {
      def make(o: _root_.scala.Int): Z32 = Z32(_root_.org.sireum.Z.MP(o))
    }
  }

  final class Z32(val value: _root_.org.sireum.Z) extends _root_.scala.AnyVal with _root_.org.sireum.Z.Range[Z32] {
    @inline def Name: _root_.java.lang.String = Z32.Name;
    @inline def Min: Z32 = Z32.Min;
    @inline def Max: Z32 = Z32.Max;
    @inline def Index: Z32 = Z32.Index;
    @inline def isZeroIndex: _root_.scala.Boolean = Z32.isZeroIndex;
    @inline def isSigned: _root_.scala.Boolean = Z32.isSigned;
    @inline def hasMin: _root_.scala.Boolean = Z32.hasMin;
    @inline def hasMax: _root_.scala.Boolean = Z32.hasMax;
    def make(v: _root_.org.sireum.Z): Z32 = Z32(v);
    def boxer = Z32.Boxer
  }

  object Z64 extends _root_.org.sireum.$ZCompanion[Z64] {
    val Name: _root_.java.lang.String = "Z64";
    lazy val Min: Z64 = if (hasMin)
      new Z64(_root_.org.sireum.Z.MP("-9223372036854775808"))
    else
      halt("Unsupported Vector(Z64) operation \'Min\'");
    lazy val Max: Z64 = if (hasMax)
      new Z64(_root_.org.sireum.Z.MP("9223372036854775807"))
    else
      halt("Unsupported Vector(Z64) operation \'Max\'");
    val Index: Z64 = Z64(_root_.org.sireum.Z.MP("0"));
    val isZeroIndex: _root_.scala.Boolean = true;
    val isSigned: _root_.scala.Boolean = true;
    val isBitVector: _root_.scala.Boolean = false;
    val hasMin: _root_.scala.Boolean = true;
    val hasMax: _root_.scala.Boolean = true;
    def BitWidth: _root_.scala.Int = halt(StringContext("Unsupported ", " operation \'BitWidth\'").s(Name));
    def random: Z64 = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.random.%(d);
        Z64(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.random;
          Z64(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.random;
          Z64(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    def randomSeed(seed: _root_.org.sireum.Z): Z64 = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.randomSeed(seed).%(d);
        Z64(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          Z64(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          Z64(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    private def check(v: _root_.org.sireum.Z): _root_.org.sireum.Z = {
      if (hasMin)
        assert(Min.value.<=(v), v.+(" is less than Z64.Min (-9223372036854775808)"))
      else
        ();
      if (hasMax)
        assert(v.<=(Max.value), v.+(" is greater than Z64.Max (9223372036854775807)"))
      else
        ();
      v
    };
    def apply(n: _root_.scala.Int): Z64 = Int(n);
    def apply(n: _root_.scala.Long): Z64 = Long(n);
    def apply(n: _root_.org.sireum.Z): Z64 = new Z64(check(n));
    def apply(s: _root_.org.sireum.String): _root_.org.sireum.Option[Z64] = try {
      _root_.org.sireum.Some(Z64.$String(s.value))
    } catch {
      case ((_): _root_.java.lang.Throwable) => _root_.org.sireum.None[Z64]()
    };
    def unapply(n: Z64): _root_.scala.Option[_root_.org.sireum.Z] = _root_.scala.Some(n.value);
    object Int extends _root_.org.sireum.$ZCompanionInt[Z64] {
      def apply(n: _root_.scala.Int): Z64 = Z64(_root_.org.sireum.Z.MP(n));
      def unapply(n: Z64): _root_.scala.Option[_root_.scala.Int] = if (_root_.scala.Int.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Int.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toInt)
      else
        _root_.scala.None
    };
    object Long extends _root_.org.sireum.$ZCompanionLong[Z64] {
      def apply(n: _root_.scala.Long): Z64 = Z64(_root_.org.sireum.Z.MP(n));
      def unapply(n: Z64): _root_.scala.Option[_root_.scala.Long] = if (_root_.scala.Long.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Long.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toLong)
      else
        _root_.scala.None
    };
    object $String extends _root_.org.sireum.$ZCompanionString[Z64] {
      def apply(s: _root_.java.lang.String): Z64 = BigInt(_root_.org.sireum.Z.$String(s).toBigInt);
      def unapply(n: Z64): _root_.scala.Option[_root_.java.lang.String] = _root_.scala.Some(n.toBigInt.toString)
    };
    object BigInt extends _root_.org.sireum.$ZCompanionBigInt[Z64] {
      def apply(n: _root_.scala.BigInt): Z64 = Z64(_root_.org.sireum.Z.MP(n));
      def unapply(n: Z64): _root_.scala.Option[_root_.scala.BigInt] = _root_.scala.Some(n.toBigInt)
    };
    implicit class Z64$Slang(val sc: _root_.scala.StringContext) {
      object z64 {
        def apply(args: _root_.scala.Any*): Z64 = {
          assume(args.isEmpty.&&(sc.parts.length.==(1)));
          $String(sc.parts.head)
        };
        def unapply(n: Z64): _root_.scala.Boolean = {
          assume(sc.parts.length.==(1));
          n.==($String(sc.parts.head))
        }
      }
    };
    implicit val $Z64Companion: _root_.org.sireum.$ZCompanion[Z64] = this;
    object Boxer extends _root_.org.sireum.Z.Boxer.Long {
      def make(o: _root_.scala.Long): Z64 = Z64(_root_.org.sireum.Z.MP(o))
    }
  }

  final class Z64(val value: _root_.org.sireum.Z) extends _root_.scala.AnyVal with _root_.org.sireum.Z.Range[Z64] {
    @inline def Name: _root_.java.lang.String = Z64.Name;
    @inline def Min: Z64 = Z64.Min;
    @inline def Max: Z64 = Z64.Max;
    @inline def Index: Z64 = Z64.Index;
    @inline def isZeroIndex: _root_.scala.Boolean = Z64.isZeroIndex;
    @inline def isSigned: _root_.scala.Boolean = Z64.isSigned;
    @inline def hasMin: _root_.scala.Boolean = Z64.hasMin;
    @inline def hasMax: _root_.scala.Boolean = Z64.hasMax;
    def make(v: _root_.org.sireum.Z): Z64 = Z64(v);
    def boxer = Z64.Boxer
  }

  object N extends _root_.org.sireum.$ZCompanion[N] {
    val Name: _root_.java.lang.String = "N";
    lazy val Min: N = if (hasMin)
      new N(_root_.org.sireum.Z.MP("0"))
    else
      halt("Unsupported Vector(N) operation \'Min\'");
    lazy val Max: N = if (hasMax)
      new N(_root_.org.sireum.Z.MP("0"))
    else
      halt("Unsupported Vector(N) operation \'Max\'");
    val Index: N = N(_root_.org.sireum.Z.MP("0"));
    val isZeroIndex: _root_.scala.Boolean = true;
    val isSigned: _root_.scala.Boolean = false;
    val isBitVector: _root_.scala.Boolean = false;
    val hasMin: _root_.scala.Boolean = true;
    val hasMax: _root_.scala.Boolean = false;
    def BitWidth: _root_.scala.Int = halt(StringContext("Unsupported ", " operation \'BitWidth\'").s(Name));
    def random: N = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.random.%(d);
        N(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.random;
          N(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.random;
          N(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    def randomSeed(seed: _root_.org.sireum.Z): N = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.randomSeed(seed).%(d);
        N(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          N(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          N(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    private def check(v: _root_.org.sireum.Z): _root_.org.sireum.Z = {
      if (hasMin)
        assert(Min.value.<=(v), v.+(" is less than N.Min (0)"))
      else
        ();
      if (hasMax)
        assert(v.<=(Max.value), v.+(" is greater than N.Max (0)"))
      else
        ();
      v
    };
    def apply(n: _root_.scala.Int): N = Int(n);
    def apply(n: _root_.scala.Long): N = Long(n);
    def apply(n: _root_.org.sireum.Z): N = new N(check(n));
    def apply(s: _root_.org.sireum.String): _root_.org.sireum.Option[N] = try {
      _root_.org.sireum.Some(N.$String(s.value))
    } catch {
      case ((_): _root_.java.lang.Throwable) => _root_.org.sireum.None[N]()
    };
    def unapply(n: N): _root_.scala.Option[_root_.org.sireum.Z] = _root_.scala.Some(n.value);
    object Int extends _root_.org.sireum.$ZCompanionInt[N] {
      def apply(n: _root_.scala.Int): N = N(_root_.org.sireum.Z.MP(n));
      def unapply(n: N): _root_.scala.Option[_root_.scala.Int] = if (_root_.scala.Int.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Int.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toInt)
      else
        _root_.scala.None
    };
    object Long extends _root_.org.sireum.$ZCompanionLong[N] {
      def apply(n: _root_.scala.Long): N = N(_root_.org.sireum.Z.MP(n));
      def unapply(n: N): _root_.scala.Option[_root_.scala.Long] = if (_root_.scala.Long.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Long.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toLong)
      else
        _root_.scala.None
    };
    object $String extends _root_.org.sireum.$ZCompanionString[N] {
      def apply(s: _root_.java.lang.String): N = BigInt(_root_.org.sireum.Z.$String(s).toBigInt);
      def unapply(n: N): _root_.scala.Option[_root_.java.lang.String] = _root_.scala.Some(n.toBigInt.toString)
    };
    object BigInt extends _root_.org.sireum.$ZCompanionBigInt[N] {
      def apply(n: _root_.scala.BigInt): N = N(_root_.org.sireum.Z.MP(n));
      def unapply(n: N): _root_.scala.Option[_root_.scala.BigInt] = _root_.scala.Some(n.toBigInt)
    };
    implicit class N$Slang(val sc: _root_.scala.StringContext) {
      object n {
        def apply(args: _root_.scala.Any*): N = {
          assume(args.isEmpty.&&(sc.parts.length.==(1)));
          $String(sc.parts.head)
        };
        def unapply(n: N): _root_.scala.Boolean = {
          assume(sc.parts.length.==(1));
          n.==($String(sc.parts.head))
        }
      }
    };
    implicit val $NCompanion: _root_.org.sireum.$ZCompanion[N] = this
  }

  final class N(val value: _root_.org.sireum.Z) extends _root_.scala.AnyVal with _root_.org.sireum.Z.Range[N] {
    @inline def Name: _root_.java.lang.String = N.Name;
    @inline def Min: N = N.Min;
    @inline def Max: N = N.Max;
    @inline def Index: N = N.Index;
    @inline def isZeroIndex: _root_.scala.Boolean = N.isZeroIndex;
    @inline def isSigned: _root_.scala.Boolean = N.isSigned;
    @inline def hasMin: _root_.scala.Boolean = N.hasMin;
    @inline def hasMax: _root_.scala.Boolean = N.hasMax;
    def make(v: _root_.org.sireum.Z): N = N(v);
    def boxer = _root_.org.sireum.Z.Boxer.Z
  }

  object N8 extends _root_.org.sireum.$ZCompanion[N8] {
    val Name: _root_.java.lang.String = "N8";
    lazy val Min: N8 = if (hasMin)
      new N8(_root_.org.sireum.Z.MP("0"))
    else
      halt("Unsupported Vector(N8) operation \'Min\'");
    lazy val Max: N8 = if (hasMax)
      new N8(_root_.org.sireum.Z.MP("255"))
    else
      halt("Unsupported Vector(N8) operation \'Max\'");
    val Index: N8 = N8(_root_.org.sireum.Z.MP("0"));
    val isZeroIndex: _root_.scala.Boolean = true;
    val isSigned: _root_.scala.Boolean = false;
    val isBitVector: _root_.scala.Boolean = false;
    val hasMin: _root_.scala.Boolean = true;
    val hasMax: _root_.scala.Boolean = true;
    def BitWidth: _root_.scala.Int = halt(StringContext("Unsupported ", " operation \'BitWidth\'").s(Name));
    def random: N8 = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.random.%(d);
        N8(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.random;
          N8(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.random;
          N8(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    def randomSeed(seed: _root_.org.sireum.Z): N8 = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.randomSeed(seed).%(d);
        N8(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          N8(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          N8(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    private def check(v: _root_.org.sireum.Z): _root_.org.sireum.Z = {
      if (hasMin)
        assert(Min.value.<=(v), v.+(" is less than N8.Min (0)"))
      else
        ();
      if (hasMax)
        assert(v.<=(Max.value), v.+(" is greater than N8.Max (255)"))
      else
        ();
      v
    };
    def apply(n: _root_.scala.Int): N8 = Int(n);
    def apply(n: _root_.scala.Long): N8 = Long(n);
    def apply(n: _root_.org.sireum.Z): N8 = new N8(check(n));
    def apply(s: _root_.org.sireum.String): _root_.org.sireum.Option[N8] = try {
      _root_.org.sireum.Some(N8.$String(s.value))
    } catch {
      case ((_): _root_.java.lang.Throwable) => _root_.org.sireum.None[N8]()
    };
    def unapply(n: N8): _root_.scala.Option[_root_.org.sireum.Z] = _root_.scala.Some(n.value);
    object Int extends _root_.org.sireum.$ZCompanionInt[N8] {
      def apply(n: _root_.scala.Int): N8 = N8(_root_.org.sireum.Z.MP(n));
      def unapply(n: N8): _root_.scala.Option[_root_.scala.Int] = if (_root_.scala.Int.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Int.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toInt)
      else
        _root_.scala.None
    };
    object Long extends _root_.org.sireum.$ZCompanionLong[N8] {
      def apply(n: _root_.scala.Long): N8 = N8(_root_.org.sireum.Z.MP(n));
      def unapply(n: N8): _root_.scala.Option[_root_.scala.Long] = if (_root_.scala.Long.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Long.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toLong)
      else
        _root_.scala.None
    };
    object $String extends _root_.org.sireum.$ZCompanionString[N8] {
      def apply(s: _root_.java.lang.String): N8 = BigInt(_root_.org.sireum.Z.$String(s).toBigInt);
      def unapply(n: N8): _root_.scala.Option[_root_.java.lang.String] = _root_.scala.Some(n.toBigInt.toString)
    };
    object BigInt extends _root_.org.sireum.$ZCompanionBigInt[N8] {
      def apply(n: _root_.scala.BigInt): N8 = N8(_root_.org.sireum.Z.MP(n));
      def unapply(n: N8): _root_.scala.Option[_root_.scala.BigInt] = _root_.scala.Some(n.toBigInt)
    };
    implicit class N8$Slang(val sc: _root_.scala.StringContext) {
      object n8 {
        def apply(args: _root_.scala.Any*): N8 = {
          assume(args.isEmpty.&&(sc.parts.length.==(1)));
          $String(sc.parts.head)
        };
        def unapply(n: N8): _root_.scala.Boolean = {
          assume(sc.parts.length.==(1));
          n.==($String(sc.parts.head))
        }
      }
    };
    implicit val $N8Companion: _root_.org.sireum.$ZCompanion[N8] = this;
    object Boxer extends _root_.org.sireum.Z.Boxer.Short {
      def make(o: _root_.scala.Short): N8 = N8(_root_.org.sireum.Z.MP(o))
    }
  }

  final class N8(val value: _root_.org.sireum.Z) extends _root_.scala.AnyVal with _root_.org.sireum.Z.Range[N8] {
    @inline def Name: _root_.java.lang.String = N8.Name;
    @inline def Min: N8 = N8.Min;
    @inline def Max: N8 = N8.Max;
    @inline def Index: N8 = N8.Index;
    @inline def isZeroIndex: _root_.scala.Boolean = N8.isZeroIndex;
    @inline def isSigned: _root_.scala.Boolean = N8.isSigned;
    @inline def hasMin: _root_.scala.Boolean = N8.hasMin;
    @inline def hasMax: _root_.scala.Boolean = N8.hasMax;
    def make(v: _root_.org.sireum.Z): N8 = N8(v);
    def boxer = N8.Boxer
  }

  object N16 extends _root_.org.sireum.$ZCompanion[N16] {
    val Name: _root_.java.lang.String = "N16";
    lazy val Min: N16 = if (hasMin)
      new N16(_root_.org.sireum.Z.MP("0"))
    else
      halt("Unsupported Vector(N16) operation \'Min\'");
    lazy val Max: N16 = if (hasMax)
      new N16(_root_.org.sireum.Z.MP("65535"))
    else
      halt("Unsupported Vector(N16) operation \'Max\'");
    val Index: N16 = N16(_root_.org.sireum.Z.MP("0"));
    val isZeroIndex: _root_.scala.Boolean = true;
    val isSigned: _root_.scala.Boolean = false;
    val isBitVector: _root_.scala.Boolean = false;
    val hasMin: _root_.scala.Boolean = true;
    val hasMax: _root_.scala.Boolean = true;
    def BitWidth: _root_.scala.Int = halt(StringContext("Unsupported ", " operation \'BitWidth\'").s(Name));
    def random: N16 = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.random.%(d);
        N16(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.random;
          N16(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.random;
          N16(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    def randomSeed(seed: _root_.org.sireum.Z): N16 = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.randomSeed(seed).%(d);
        N16(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          N16(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          N16(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    private def check(v: _root_.org.sireum.Z): _root_.org.sireum.Z = {
      if (hasMin)
        assert(Min.value.<=(v), v.+(" is less than N16.Min (0)"))
      else
        ();
      if (hasMax)
        assert(v.<=(Max.value), v.+(" is greater than N16.Max (65535)"))
      else
        ();
      v
    };
    def apply(n: _root_.scala.Int): N16 = Int(n);
    def apply(n: _root_.scala.Long): N16 = Long(n);
    def apply(n: _root_.org.sireum.Z): N16 = new N16(check(n));
    def apply(s: _root_.org.sireum.String): _root_.org.sireum.Option[N16] = try {
      _root_.org.sireum.Some(N16.$String(s.value))
    } catch {
      case ((_): _root_.java.lang.Throwable) => _root_.org.sireum.None[N16]()
    };
    def unapply(n: N16): _root_.scala.Option[_root_.org.sireum.Z] = _root_.scala.Some(n.value);
    object Int extends _root_.org.sireum.$ZCompanionInt[N16] {
      def apply(n: _root_.scala.Int): N16 = N16(_root_.org.sireum.Z.MP(n));
      def unapply(n: N16): _root_.scala.Option[_root_.scala.Int] = if (_root_.scala.Int.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Int.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toInt)
      else
        _root_.scala.None
    };
    object Long extends _root_.org.sireum.$ZCompanionLong[N16] {
      def apply(n: _root_.scala.Long): N16 = N16(_root_.org.sireum.Z.MP(n));
      def unapply(n: N16): _root_.scala.Option[_root_.scala.Long] = if (_root_.scala.Long.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Long.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toLong)
      else
        _root_.scala.None
    };
    object $String extends _root_.org.sireum.$ZCompanionString[N16] {
      def apply(s: _root_.java.lang.String): N16 = BigInt(_root_.org.sireum.Z.$String(s).toBigInt);
      def unapply(n: N16): _root_.scala.Option[_root_.java.lang.String] = _root_.scala.Some(n.toBigInt.toString)
    };
    object BigInt extends _root_.org.sireum.$ZCompanionBigInt[N16] {
      def apply(n: _root_.scala.BigInt): N16 = N16(_root_.org.sireum.Z.MP(n));
      def unapply(n: N16): _root_.scala.Option[_root_.scala.BigInt] = _root_.scala.Some(n.toBigInt)
    };
    implicit class N16$Slang(val sc: _root_.scala.StringContext) {
      object n16 {
        def apply(args: _root_.scala.Any*): N16 = {
          assume(args.isEmpty.&&(sc.parts.length.==(1)));
          $String(sc.parts.head)
        };
        def unapply(n: N16): _root_.scala.Boolean = {
          assume(sc.parts.length.==(1));
          n.==($String(sc.parts.head))
        }
      }
    };
    implicit val $N16Companion: _root_.org.sireum.$ZCompanion[N16] = this;
    object Boxer extends _root_.org.sireum.Z.Boxer.Int {
      def make(o: _root_.scala.Int): N16 = N16(_root_.org.sireum.Z.MP(o))
    }
  }

  final class N16(val value: _root_.org.sireum.Z) extends _root_.scala.AnyVal with _root_.org.sireum.Z.Range[N16] {
    @inline def Name: _root_.java.lang.String = N16.Name;
    @inline def Min: N16 = N16.Min;
    @inline def Max: N16 = N16.Max;
    @inline def Index: N16 = N16.Index;
    @inline def isZeroIndex: _root_.scala.Boolean = N16.isZeroIndex;
    @inline def isSigned: _root_.scala.Boolean = N16.isSigned;
    @inline def hasMin: _root_.scala.Boolean = N16.hasMin;
    @inline def hasMax: _root_.scala.Boolean = N16.hasMax;
    def make(v: _root_.org.sireum.Z): N16 = N16(v);
    def boxer = N16.Boxer
  }

  object N32 extends _root_.org.sireum.$ZCompanion[N32] {
    val Name: _root_.java.lang.String = "N32";
    lazy val Min: N32 = if (hasMin)
      new N32(_root_.org.sireum.Z.MP("0"))
    else
      halt("Unsupported Vector(N32) operation \'Min\'");
    lazy val Max: N32 = if (hasMax)
      new N32(_root_.org.sireum.Z.MP("4294967295"))
    else
      halt("Unsupported Vector(N32) operation \'Max\'");
    val Index: N32 = N32(_root_.org.sireum.Z.MP("0"));
    val isZeroIndex: _root_.scala.Boolean = true;
    val isSigned: _root_.scala.Boolean = false;
    val isBitVector: _root_.scala.Boolean = false;
    val hasMin: _root_.scala.Boolean = true;
    val hasMax: _root_.scala.Boolean = true;
    def BitWidth: _root_.scala.Int = halt(StringContext("Unsupported ", " operation \'BitWidth\'").s(Name));
    def random: N32 = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.random.%(d);
        N32(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.random;
          N32(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.random;
          N32(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    def randomSeed(seed: _root_.org.sireum.Z): N32 = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.randomSeed(seed).%(d);
        N32(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          N32(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          N32(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    private def check(v: _root_.org.sireum.Z): _root_.org.sireum.Z = {
      if (hasMin)
        assert(Min.value.<=(v), v.+(" is less than N32.Min (0)"))
      else
        ();
      if (hasMax)
        assert(v.<=(Max.value), v.+(" is greater than N32.Max (4294967295)"))
      else
        ();
      v
    };
    def apply(n: _root_.scala.Int): N32 = Int(n);
    def apply(n: _root_.scala.Long): N32 = Long(n);
    def apply(n: _root_.org.sireum.Z): N32 = new N32(check(n));
    def apply(s: _root_.org.sireum.String): _root_.org.sireum.Option[N32] = try {
      _root_.org.sireum.Some(N32.$String(s.value))
    } catch {
      case ((_): _root_.java.lang.Throwable) => _root_.org.sireum.None[N32]()
    };
    def unapply(n: N32): _root_.scala.Option[_root_.org.sireum.Z] = _root_.scala.Some(n.value);
    object Int extends _root_.org.sireum.$ZCompanionInt[N32] {
      def apply(n: _root_.scala.Int): N32 = N32(_root_.org.sireum.Z.MP(n));
      def unapply(n: N32): _root_.scala.Option[_root_.scala.Int] = if (_root_.scala.Int.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Int.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toInt)
      else
        _root_.scala.None
    };
    object Long extends _root_.org.sireum.$ZCompanionLong[N32] {
      def apply(n: _root_.scala.Long): N32 = N32(_root_.org.sireum.Z.MP(n));
      def unapply(n: N32): _root_.scala.Option[_root_.scala.Long] = if (_root_.scala.Long.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Long.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toLong)
      else
        _root_.scala.None
    };
    object $String extends _root_.org.sireum.$ZCompanionString[N32] {
      def apply(s: _root_.java.lang.String): N32 = BigInt(_root_.org.sireum.Z.$String(s).toBigInt);
      def unapply(n: N32): _root_.scala.Option[_root_.java.lang.String] = _root_.scala.Some(n.toBigInt.toString)
    };
    object BigInt extends _root_.org.sireum.$ZCompanionBigInt[N32] {
      def apply(n: _root_.scala.BigInt): N32 = N32(_root_.org.sireum.Z.MP(n));
      def unapply(n: N32): _root_.scala.Option[_root_.scala.BigInt] = _root_.scala.Some(n.toBigInt)
    };
    implicit class N32$Slang(val sc: _root_.scala.StringContext) {
      object n32 {
        def apply(args: _root_.scala.Any*): N32 = {
          assume(args.isEmpty.&&(sc.parts.length.==(1)));
          $String(sc.parts.head)
        };
        def unapply(n: N32): _root_.scala.Boolean = {
          assume(sc.parts.length.==(1));
          n.==($String(sc.parts.head))
        }
      }
    };
    implicit val $N32Companion: _root_.org.sireum.$ZCompanion[N32] = this;
    object Boxer extends _root_.org.sireum.Z.Boxer.Byte {
      def make(o: _root_.scala.Byte): N32 = N32(_root_.org.sireum.Z.MP(o))
    }
  }

  final class N32(val value: _root_.org.sireum.Z) extends _root_.scala.AnyVal with _root_.org.sireum.Z.Range[N32] {
    @inline def Name: _root_.java.lang.String = N32.Name;
    @inline def Min: N32 = N32.Min;
    @inline def Max: N32 = N32.Max;
    @inline def Index: N32 = N32.Index;
    @inline def isZeroIndex: _root_.scala.Boolean = N32.isZeroIndex;
    @inline def isSigned: _root_.scala.Boolean = N32.isSigned;
    @inline def hasMin: _root_.scala.Boolean = N32.hasMin;
    @inline def hasMax: _root_.scala.Boolean = N32.hasMax;
    def make(v: _root_.org.sireum.Z): N32 = N32(v);
    def boxer = N32.Boxer
  }

  object N64 extends _root_.org.sireum.$ZCompanion[N64] {
    val Name: _root_.java.lang.String = "N64";
    lazy val Min: N64 = if (hasMin)
      new N64(_root_.org.sireum.Z.MP("0"))
    else
      halt("Unsupported Vector(N64) operation \'Min\'");
    lazy val Max: N64 = if (hasMax)
      new N64(_root_.org.sireum.Z.MP("18446744073709551617"))
    else
      halt("Unsupported Vector(N64) operation \'Max\'");
    val Index: N64 = N64(_root_.org.sireum.Z.MP("0"));
    val isZeroIndex: _root_.scala.Boolean = true;
    val isSigned: _root_.scala.Boolean = false;
    val isBitVector: _root_.scala.Boolean = false;
    val hasMin: _root_.scala.Boolean = true;
    val hasMax: _root_.scala.Boolean = true;
    def BitWidth: _root_.scala.Int = halt(StringContext("Unsupported ", " operation \'BitWidth\'").s(Name));
    def random: N64 = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.random.%(d);
        N64(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.random;
          N64(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.random;
          N64(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    def randomSeed(seed: _root_.org.sireum.Z): N64 = if (hasMax.&&(hasMin))
      {
        val d = Max.value.-(Min.value).+(_root_.org.sireum.Z.MP.one);
        val n = _root_.org.sireum.Z.randomSeed(seed).%(d);
        N64(n.+(Min.value))
      }
    else
      if (hasMax)
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          N64(if (n.>(Max.value))
            Max.value.-(n)
          else
            n)
        }
      else
        {
          val n = _root_.org.sireum.Z.randomSeed(seed);
          N64(if (n.<(Min.value))
            Min.value.+(n)
          else
            n)
        };
    private def check(v: _root_.org.sireum.Z): _root_.org.sireum.Z = {
      if (hasMin)
        assert(Min.value.<=(v), v.+(" is less than N64.Min (0)"))
      else
        ();
      if (hasMax)
        assert(v.<=(Max.value), v.+(" is greater than N64.Max (18446744073709551617)"))
      else
        ();
      v
    };
    def apply(n: _root_.scala.Int): N64 = Int(n);
    def apply(n: _root_.scala.Long): N64 = Long(n);
    def apply(n: _root_.org.sireum.Z): N64 = new N64(check(n));
    def apply(s: _root_.org.sireum.String): _root_.org.sireum.Option[N64] = try {
      _root_.org.sireum.Some(N64.$String(s.value))
    } catch {
      case ((_): _root_.java.lang.Throwable) => _root_.org.sireum.None[N64]()
    };
    def unapply(n: N64): _root_.scala.Option[_root_.org.sireum.Z] = _root_.scala.Some(n.value);
    object Int extends _root_.org.sireum.$ZCompanionInt[N64] {
      def apply(n: _root_.scala.Int): N64 = N64(_root_.org.sireum.Z.MP(n));
      def unapply(n: N64): _root_.scala.Option[_root_.scala.Int] = if (_root_.scala.Int.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Int.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toInt)
      else
        _root_.scala.None
    };
    object Long extends _root_.org.sireum.$ZCompanionLong[N64] {
      def apply(n: _root_.scala.Long): N64 = N64(_root_.org.sireum.Z.MP(n));
      def unapply(n: N64): _root_.scala.Option[_root_.scala.Long] = if (_root_.scala.Long.MinValue.<=(n.value).&&(n.value.<=(_root_.scala.Long.MaxValue)))
        _root_.scala.Some(n.value.toBigInt.toLong)
      else
        _root_.scala.None
    };
    object $String extends _root_.org.sireum.$ZCompanionString[N64] {
      def apply(s: _root_.java.lang.String): N64 = BigInt(_root_.org.sireum.Z.$String(s).toBigInt);
      def unapply(n: N64): _root_.scala.Option[_root_.java.lang.String] = _root_.scala.Some(n.toBigInt.toString)
    };
    object BigInt extends _root_.org.sireum.$ZCompanionBigInt[N64] {
      def apply(n: _root_.scala.BigInt): N64 = N64(_root_.org.sireum.Z.MP(n));
      def unapply(n: N64): _root_.scala.Option[_root_.scala.BigInt] = _root_.scala.Some(n.toBigInt)
    };
    implicit class N64$Slang(val sc: _root_.scala.StringContext) {
      object n64 {
        def apply(args: _root_.scala.Any*): N64 = {
          assume(args.isEmpty.&&(sc.parts.length.==(1)));
          $String(sc.parts.head)
        };
        def unapply(n: N64): _root_.scala.Boolean = {
          assume(sc.parts.length.==(1));
          n.==($String(sc.parts.head))
        }
      }
    };
    implicit val $N64Companion: _root_.org.sireum.$ZCompanion[N64] = this;
    object Boxer extends _root_.org.sireum.Z.Boxer.Byte {
      def make(o: _root_.scala.Byte): N64 = N64(_root_.org.sireum.Z.MP(o))
    }
  }

  final class N64(val value: _root_.org.sireum.Z) extends _root_.scala.AnyVal with _root_.org.sireum.Z.Range[N64] {
    @inline def Name: _root_.java.lang.String = N64.Name;
    @inline def Min: N64 = N64.Min;
    @inline def Max: N64 = N64.Max;
    @inline def Index: N64 = N64.Index;
    @inline def isZeroIndex: _root_.scala.Boolean = N64.isZeroIndex;
    @inline def isSigned: _root_.scala.Boolean = N64.isSigned;
    @inline def hasMin: _root_.scala.Boolean = N64.hasMin;
    @inline def hasMax: _root_.scala.Boolean = N64.hasMax;
    def make(v: _root_.org.sireum.Z): N64 = N64(v);
    def boxer = N64.Boxer
  }

  object S8 extends _root_.org.sireum.$ZCompanion[S8] {
    object Boxer extends _root_.org.sireum.Z.Boxer.Byte {
      def make(o: _root_.scala.Byte): S8 = new S8(o)
    };
    val Name: _root_.java.lang.String = "S8";
    val BitWidth: _root_.scala.Int = 8;
    val Min: S8 = new S8(-128.toByte);
    val Max: S8 = new S8(127.toByte);
    val Index: S8 = new S8(0.toByte);
    val isZeroIndex: _root_.scala.Boolean = true;
    val isSigned: _root_.scala.Boolean = true;
    val isWrapped: _root_.scala.Boolean = true;
    val isBitVector: _root_.scala.Boolean = true;
    val hasMin: _root_.scala.Boolean = true;
    val hasMax: _root_.scala.Boolean = true;
    def random: S8 = {
      val zMin = _root_.org.sireum.Z(Min.toBigInt);
      val d = _root_.org.sireum.Z(Max.toBigInt).-(zMin).+(_root_.org.sireum.Z.MP.one);
      val n = _root_.org.sireum.Z.random.%(d);
      new S8(n.+(zMin).toBigInt.toByte)
    };
    def randomSeed(seed: _root_.org.sireum.Z): S8 = {
      val zMin = _root_.org.sireum.Z(Min.toBigInt);
      val d = _root_.org.sireum.Z(Max.toBigInt).-(zMin).+(_root_.org.sireum.Z.MP.one);
      val n = _root_.org.sireum.Z.randomSeed(seed).%(d);
      new S8(n.+(zMin).toBigInt.toByte)
    };
    def apply(n: _root_.scala.Int): S8 = Int(n);
    def apply(n: _root_.scala.Long): S8 = Long(n);
    def apply(n: _root_.org.sireum.Z): S8 = n match {
      case (n @ ((_): _root_.org.sireum.Z.MP.Long)) => {
        if (isWrapped.`unary_!`)
          {
            assert(Min.toMP.<=(n), n.+(" is less than S8.Min (-128)"));
            assert(n.<=(Max.toMP), n.+(" is greater than S8.Max (127)"))
          }
        else
          ();
        new S8(n.value.toByte)
      }
      case (n @ ((_): _root_.org.sireum.Z.MP.BigInt)) => {
        if (isWrapped.`unary_!`)
          {
            assert(Min.toMP.<=(n), n.+(" is less than S8.Min (-128)"));
            assert(n.<=(Max.toMP), n.+(" is greater than S8.Max (127)"))
          }
        else
          ();
        new S8(n.value.toByte)
      }
      case _ => halt(StringContext("Unsupported ", " creation from ", ".").s(Name, n.Name))
    };
    def apply(s: _root_.org.sireum.String): _root_.org.sireum.Option[S8] = try {
      _root_.org.sireum.Some(S8.$String(s.value))
    } catch {
      case ((_): _root_.java.lang.Throwable) => _root_.org.sireum.None[S8]()
    };
    def unapply(n: S8): _root_.scala.Option[_root_.org.sireum.Z] = _root_.scala.Some(n.toMP);
    object Int extends _root_.org.sireum.$ZCompanionInt[S8] {
      def apply(n: _root_.scala.Int): S8 = if (isWrapped)
        new S8(n.toByte)
      else
        S8(_root_.org.sireum.Z.MP(n));
      def unapply(n: S8): _root_.scala.Option[_root_.scala.Int] = _root_.scala.Some(n.toMP.toInt)
    };
    object Long extends org.sireum.$ZCompanionLong[S8] {
      def apply(n: _root_.scala.Long): S8 = if (isWrapped)
        new S8(n.toByte)
      else
        S8(_root_.org.sireum.Z.MP(n));
      def unapply(n: S8): _root_.scala.Option[_root_.scala.Long] = _root_.scala.Some(n.toMP.toLong)
    };
    object $String extends _root_.org.sireum.$ZCompanionString[S8] {
      def apply(s: _root_.java.lang.String): S8 = BigInt(_root_.org.sireum.Z.$String(s).toBigInt);
      def unapply(n: S8): _root_.scala.Option[_root_.java.lang.String] = _root_.scala.Some(n.toBigInt.toString)
    };
    object BigInt extends org.sireum.$ZCompanionBigInt[S8] {
      def apply(n: _root_.scala.BigInt): S8 = if (isWrapped)
        new S8(n.toByte)
      else
        S8(_root_.org.sireum.Z.MP(n));
      def unapply(n: S8): _root_.scala.Option[_root_.scala.BigInt] = _root_.scala.Some(n.toBigInt)
    };
    implicit class S8$Slang(val sc: _root_.scala.StringContext) {
      object s8 {
        def apply(args: _root_.scala.Any*): S8 = {
          assume(args.isEmpty.&&(sc.parts.length.==(1)));
          $String(sc.parts.head)
        };
        def unapply(n: S8): _root_.scala.Boolean = {
          assume(sc.parts.length.==(1));
          n.==($String(sc.parts.head))
        }
      }
    };
    implicit val $S8Companion: org.sireum.$ZCompanion[S8] = this
  }

  final class S8(val value: _root_.scala.Byte) extends _root_.scala.AnyVal with _root_.org.sireum.Z.BV.Byte[S8] {
    @inline def Name: _root_.java.lang.String = S8.Name;
    @inline def BitWidth: _root_.scala.Int = S8.BitWidth;
    @inline def Min: S8 = S8.Min;
    @inline def Max: S8 = S8.Max;
    @inline def Index: S8 = S8.Index;
    @inline def isZeroIndex: _root_.scala.Boolean = S8.isZeroIndex;
    @inline def isSigned: _root_.scala.Boolean = S8.isSigned;
    @inline def isWrapped: _root_.scala.Boolean = S8.isWrapped;
    def make(v: _root_.scala.Byte): S8 = S8(v);
    def boxer = S8.Boxer
  }

  object U8 extends _root_.org.sireum.$ZCompanion[U8] {
    object Boxer extends _root_.org.sireum.Z.Boxer.Byte {
      def make(o: _root_.scala.Byte): U8 = new U8(o)
    };
    val Name: _root_.java.lang.String = "U8";
    val BitWidth: _root_.scala.Int = 8;
    val Min: U8 = new U8(0.toByte);
    val Max: U8 = new U8(255.toByte);
    val Index: U8 = new U8(0.toByte);
    val isZeroIndex: _root_.scala.Boolean = true;
    val isSigned: _root_.scala.Boolean = false;
    val isWrapped: _root_.scala.Boolean = true;
    val isBitVector: _root_.scala.Boolean = true;
    val hasMin: _root_.scala.Boolean = true;
    val hasMax: _root_.scala.Boolean = true;
    def random: U8 = {
      val zMin = _root_.org.sireum.Z(Min.toBigInt);
      val d = _root_.org.sireum.Z(Max.toBigInt).-(zMin).+(_root_.org.sireum.Z.MP.one);
      val n = _root_.org.sireum.Z.random.%(d);
      new U8(n.+(zMin).toBigInt.toByte)
    };
    def randomSeed(seed: _root_.org.sireum.Z): U8 = {
      val zMin = _root_.org.sireum.Z(Min.toBigInt);
      val d = _root_.org.sireum.Z(Max.toBigInt).-(zMin).+(_root_.org.sireum.Z.MP.one);
      val n = _root_.org.sireum.Z.randomSeed(seed).%(d);
      new U8(n.+(zMin).toBigInt.toByte)
    };
    def apply(n: _root_.scala.Int): U8 = Int(n);
    def apply(n: _root_.scala.Long): U8 = Long(n);
    def apply(n: _root_.org.sireum.Z): U8 = n match {
      case (n @ ((_): _root_.org.sireum.Z.MP.Long)) => {
        if (isWrapped.`unary_!`)
          {
            assert(Min.toMP.<=(n), n.+(" is less than U8.Min (0)"));
            assert(n.<=(Max.toMP), n.+(" is greater than U8.Max (255)"))
          }
        else
          ();
        new U8(n.value.toByte)
      }
      case (n @ ((_): _root_.org.sireum.Z.MP.BigInt)) => {
        if (isWrapped.`unary_!`)
          {
            assert(Min.toMP.<=(n), n.+(" is less than U8.Min (0)"));
            assert(n.<=(Max.toMP), n.+(" is greater than U8.Max (255)"))
          }
        else
          ();
        new U8(n.value.toByte)
      }
      case _ => halt(StringContext("Unsupported ", " creation from ", ".").s(Name, n.Name))
    };
    def apply(s: _root_.org.sireum.String): _root_.org.sireum.Option[U8] = try {
      _root_.org.sireum.Some(U8.$String(s.value))
    } catch {
      case ((_): _root_.java.lang.Throwable) => _root_.org.sireum.None[U8]()
    };
    def unapply(n: U8): _root_.scala.Option[_root_.org.sireum.Z] = _root_.scala.Some(n.toMP);
    object Int extends _root_.org.sireum.$ZCompanionInt[U8] {
      def apply(n: _root_.scala.Int): U8 = if (isWrapped)
        new U8(n.toByte)
      else
        U8(_root_.org.sireum.Z.MP(n));
      def unapply(n: U8): _root_.scala.Option[_root_.scala.Int] = _root_.scala.Some(n.toMP.toInt)
    };
    object Long extends org.sireum.$ZCompanionLong[U8] {
      def apply(n: _root_.scala.Long): U8 = if (isWrapped)
        new U8(n.toByte)
      else
        U8(_root_.org.sireum.Z.MP(n));
      def unapply(n: U8): _root_.scala.Option[_root_.scala.Long] = _root_.scala.Some(n.toMP.toLong)
    };
    object $String extends _root_.org.sireum.$ZCompanionString[U8] {
      def apply(s: _root_.java.lang.String): U8 = BigInt(_root_.org.sireum.Z.$String(s).toBigInt);
      def unapply(n: U8): _root_.scala.Option[_root_.java.lang.String] = _root_.scala.Some(n.toBigInt.toString)
    };
    object BigInt extends org.sireum.$ZCompanionBigInt[U8] {
      def apply(n: _root_.scala.BigInt): U8 = if (isWrapped)
        new U8(n.toByte)
      else
        U8(_root_.org.sireum.Z.MP(n));
      def unapply(n: U8): _root_.scala.Option[_root_.scala.BigInt] = _root_.scala.Some(n.toBigInt)
    };
    implicit class U8$Slang(val sc: _root_.scala.StringContext) {
      object u8 {
        def apply(args: _root_.scala.Any*): U8 = {
          assume(args.isEmpty.&&(sc.parts.length.==(1)));
          $String(sc.parts.head)
        };
        def unapply(n: U8): _root_.scala.Boolean = {
          assume(sc.parts.length.==(1));
          n.==($String(sc.parts.head))
        }
      }
    };
    implicit val $U8Companion: org.sireum.$ZCompanion[U8] = this
  }

  final class U8(val value: _root_.scala.Byte) extends _root_.scala.AnyVal with _root_.org.sireum.Z.BV.Byte[U8] {
    @inline def Name: _root_.java.lang.String = U8.Name;
    @inline def BitWidth: _root_.scala.Int = U8.BitWidth;
    @inline def Min: U8 = U8.Min;
    @inline def Max: U8 = U8.Max;
    @inline def Index: U8 = U8.Index;
    @inline def isZeroIndex: _root_.scala.Boolean = U8.isZeroIndex;
    @inline def isSigned: _root_.scala.Boolean = U8.isSigned;
    @inline def isWrapped: _root_.scala.Boolean = U8.isWrapped;
    def make(v: _root_.scala.Byte): U8 = U8(v);
    def boxer = U8.Boxer
  }

  object S16 extends _root_.org.sireum.$ZCompanion[S16] {
    object Boxer extends _root_.org.sireum.Z.Boxer.Short {
      def make(o: _root_.scala.Short): S16 = new S16(o)
    };
    val Name: _root_.java.lang.String = "S16";
    val BitWidth: _root_.scala.Int = 16;
    val Min: S16 = new S16(-32768.toShort);
    val Max: S16 = new S16(32767.toShort);
    val Index: S16 = new S16(0.toShort);
    val isZeroIndex: _root_.scala.Boolean = true;
    val isSigned: _root_.scala.Boolean = true;
    val isWrapped: _root_.scala.Boolean = true;
    val isBitVector: _root_.scala.Boolean = true;
    val hasMin: _root_.scala.Boolean = true;
    val hasMax: _root_.scala.Boolean = true;
    def random: S16 = {
      val zMin = _root_.org.sireum.Z(Min.toBigInt);
      val d = _root_.org.sireum.Z(Max.toBigInt).-(zMin).+(_root_.org.sireum.Z.MP.one);
      val n = _root_.org.sireum.Z.random.%(d);
      new S16(n.+(zMin).toBigInt.toShort)
    };
    def randomSeed(seed: _root_.org.sireum.Z): S16 = {
      val zMin = _root_.org.sireum.Z(Min.toBigInt);
      val d = _root_.org.sireum.Z(Max.toBigInt).-(zMin).+(_root_.org.sireum.Z.MP.one);
      val n = _root_.org.sireum.Z.randomSeed(seed).%(d);
      new S16(n.+(zMin).toBigInt.toShort)
    };
    def apply(n: _root_.scala.Int): S16 = Int(n);
    def apply(n: _root_.scala.Long): S16 = Long(n);
    def apply(n: _root_.org.sireum.Z): S16 = n match {
      case (n @ ((_): _root_.org.sireum.Z.MP.Long)) => {
        if (isWrapped.`unary_!`)
          {
            assert(Min.toMP.<=(n), n.+(" is less than S16.Min (-32768)"));
            assert(n.<=(Max.toMP), n.+(" is greater than S16.Max (32767)"))
          }
        else
          ();
        new S16(n.value.toShort)
      }
      case (n @ ((_): _root_.org.sireum.Z.MP.BigInt)) => {
        if (isWrapped.`unary_!`)
          {
            assert(Min.toMP.<=(n), n.+(" is less than S16.Min (-32768)"));
            assert(n.<=(Max.toMP), n.+(" is greater than S16.Max (32767)"))
          }
        else
          ();
        new S16(n.value.toShort)
      }
      case _ => halt(StringContext("Unsupported ", " creation from ", ".").s(Name, n.Name))
    };
    def apply(s: _root_.org.sireum.String): _root_.org.sireum.Option[S16] = try {
      _root_.org.sireum.Some(S16.$String(s.value))
    } catch {
      case ((_): _root_.java.lang.Throwable) => _root_.org.sireum.None[S16]()
    };
    def unapply(n: S16): _root_.scala.Option[_root_.org.sireum.Z] = _root_.scala.Some(n.toMP);
    object Int extends org.sireum.$ZCompanionInt[S16] {
      def apply(n: _root_.scala.Int): S16 = if (isWrapped)
        new S16(n.toShort)
      else
        S16(_root_.org.sireum.Z.MP(n));
      def unapply(n: S16): _root_.scala.Option[_root_.scala.Int] = _root_.scala.Some(n.toMP.toInt)
    };
    object Long extends org.sireum.$ZCompanionLong[S16] {
      def apply(n: _root_.scala.Long): S16 = if (isWrapped)
        new S16(n.toShort)
      else
        S16(_root_.org.sireum.Z.MP(n));
      def unapply(n: S16): _root_.scala.Option[_root_.scala.Long] = _root_.scala.Some(n.toMP.toLong)
    };
    object $String extends _root_.org.sireum.$ZCompanionString[S16] {
      def apply(s: _root_.java.lang.String): S16 = BigInt(_root_.org.sireum.Z.$String(s).toBigInt);
      def unapply(n: S16): _root_.scala.Option[_root_.java.lang.String] = _root_.scala.Some(n.toBigInt.toString)
    };
    object BigInt extends org.sireum.$ZCompanionBigInt[S16] {
      def apply(n: _root_.scala.BigInt): S16 = if (isWrapped)
        new S16(n.toShort)
      else
        S16(_root_.org.sireum.Z.MP(n));
      def unapply(n: S16): _root_.scala.Option[_root_.scala.BigInt] = _root_.scala.Some(n.toBigInt)
    };
    implicit class S16$Slang(val sc: _root_.scala.StringContext) {
      object s16 {
        def apply(args: _root_.scala.Any*): S16 = {
          assume(args.isEmpty.&&(sc.parts.length.==(1)));
          $String(sc.parts.head)
        };
        def unapply(n: S16): _root_.scala.Boolean = {
          assume(sc.parts.length.==(1));
          n.==($String(sc.parts.head))
        }
      }
    };
    implicit val $S16Companion: org.sireum.$ZCompanion[S16] = this
  }

  final class S16(val value: _root_.scala.Short) extends _root_.scala.AnyVal with _root_.org.sireum.Z.BV.Short[S16] {
    @inline def Name: _root_.java.lang.String = S16.Name;
    @inline def BitWidth: _root_.scala.Int = S16.BitWidth;
    @inline def Min: S16 = S16.Min;
    @inline def Max: S16 = S16.Max;
    @inline def Index: S16 = S16.Index;
    @inline def isZeroIndex: _root_.scala.Boolean = S16.isZeroIndex;
    @inline def isSigned: _root_.scala.Boolean = S16.isSigned;
    @inline def isWrapped: _root_.scala.Boolean = S16.isWrapped;
    def make(v: _root_.scala.Short): S16 = S16(v);
    def boxer = S16.Boxer
  }

  object U16 extends _root_.org.sireum.$ZCompanion[U16] {
    object Boxer extends _root_.org.sireum.Z.Boxer.Short {
      def make(o: _root_.scala.Short): U16 = new U16(o)
    };
    val Name: _root_.java.lang.String = "U16";
    val BitWidth: _root_.scala.Int = 16;
    val Min: U16 = new U16(0.toShort);
    val Max: U16 = new U16(65535.toShort);
    val Index: U16 = new U16(0.toShort);
    val isZeroIndex: _root_.scala.Boolean = true;
    val isSigned: _root_.scala.Boolean = false;
    val isWrapped: _root_.scala.Boolean = true;
    val isBitVector: _root_.scala.Boolean = true;
    val hasMin: _root_.scala.Boolean = true;
    val hasMax: _root_.scala.Boolean = true;
    def random: U16 = {
      val zMin = _root_.org.sireum.Z(Min.toBigInt);
      val d = _root_.org.sireum.Z(Max.toBigInt).-(zMin).+(_root_.org.sireum.Z.MP.one);
      val n = _root_.org.sireum.Z.random.%(d);
      new U16(n.+(zMin).toBigInt.toShort)
    };
    def randomSeed(seed: _root_.org.sireum.Z): U16 = {
      val zMin = _root_.org.sireum.Z(Min.toBigInt);
      val d = _root_.org.sireum.Z(Max.toBigInt).-(zMin).+(_root_.org.sireum.Z.MP.one);
      val n = _root_.org.sireum.Z.randomSeed(seed).%(d);
      new U16(n.+(zMin).toBigInt.toShort)
    };
    def apply(n: _root_.scala.Int): U16 = Int(n);
    def apply(n: _root_.scala.Long): U16 = Long(n);
    def apply(n: _root_.org.sireum.Z): U16 = n match {
      case (n @ ((_): _root_.org.sireum.Z.MP.Long)) => {
        if (isWrapped.`unary_!`)
          {
            assert(Min.toMP.<=(n), n.+(" is less than U16.Min (0)"));
            assert(n.<=(Max.toMP), n.+(" is greater than U16.Max (65535)"))
          }
        else
          ();
        new U16(n.value.toShort)
      }
      case (n @ ((_): _root_.org.sireum.Z.MP.BigInt)) => {
        if (isWrapped.`unary_!`)
          {
            assert(Min.toMP.<=(n), n.+(" is less than U16.Min (0)"));
            assert(n.<=(Max.toMP), n.+(" is greater than U16.Max (65535)"))
          }
        else
          ();
        new U16(n.value.toShort)
      }
      case _ => halt(StringContext("Unsupported ", " creation from ", ".").s(Name, n.Name))
    };
    def apply(s: _root_.org.sireum.String): _root_.org.sireum.Option[U16] = try {
      _root_.org.sireum.Some(U16.$String(s.value))
    } catch {
      case ((_): _root_.java.lang.Throwable) => _root_.org.sireum.None[U16]()
    };
    def unapply(n: U16): _root_.scala.Option[_root_.org.sireum.Z] = _root_.scala.Some(n.toMP);
    object Int extends org.sireum.$ZCompanionInt[U16] {
      def apply(n: _root_.scala.Int): U16 = if (isWrapped)
        new U16(n.toShort)
      else
        U16(_root_.org.sireum.Z.MP(n));
      def unapply(n: U16): _root_.scala.Option[_root_.scala.Int] = _root_.scala.Some(n.toMP.toInt)
    };
    object Long extends org.sireum.$ZCompanionLong[U16] {
      def apply(n: _root_.scala.Long): U16 = if (isWrapped)
        new U16(n.toShort)
      else
        U16(_root_.org.sireum.Z.MP(n));
      def unapply(n: U16): _root_.scala.Option[_root_.scala.Long] = _root_.scala.Some(n.toMP.toLong)
    };
    object $String extends _root_.org.sireum.$ZCompanionString[U16] {
      def apply(s: _root_.java.lang.String): U16 = BigInt(_root_.org.sireum.Z.$String(s).toBigInt);
      def unapply(n: U16): _root_.scala.Option[_root_.java.lang.String] = _root_.scala.Some(n.toBigInt.toString)
    };
    object BigInt extends org.sireum.$ZCompanionBigInt[U16] {
      def apply(n: _root_.scala.BigInt): U16 = if (isWrapped)
        new U16(n.toShort)
      else
        U16(_root_.org.sireum.Z.MP(n));
      def unapply(n: U16): _root_.scala.Option[_root_.scala.BigInt] = _root_.scala.Some(n.toBigInt)
    };
    implicit class U16$Slang(val sc: _root_.scala.StringContext) {
      object u16 {
        def apply(args: _root_.scala.Any*): U16 = {
          assume(args.isEmpty.&&(sc.parts.length.==(1)));
          $String(sc.parts.head)
        };
        def unapply(n: U16): _root_.scala.Boolean = {
          assume(sc.parts.length.==(1));
          n.==($String(sc.parts.head))
        }
      }
    };
    implicit val $U16Companion: org.sireum.$ZCompanion[U16] = this
  }

  final class U16(val value: _root_.scala.Short) extends _root_.scala.AnyVal with _root_.org.sireum.Z.BV.Short[U16] {
    @inline def Name: _root_.java.lang.String = U16.Name;
    @inline def BitWidth: _root_.scala.Int = U16.BitWidth;
    @inline def Min: U16 = U16.Min;
    @inline def Max: U16 = U16.Max;
    @inline def Index: U16 = U16.Index;
    @inline def isZeroIndex: _root_.scala.Boolean = U16.isZeroIndex;
    @inline def isSigned: _root_.scala.Boolean = U16.isSigned;
    @inline def isWrapped: _root_.scala.Boolean = U16.isWrapped;
    def make(v: _root_.scala.Short): U16 = U16(v);
    def boxer = U16.Boxer
  }

  object S32 extends _root_.org.sireum.$ZCompanion[S32] {
    object Boxer extends _root_.org.sireum.Z.Boxer.Int {
      def make(o: _root_.scala.Int): S32 = new S32(o)
    };
    val Name: _root_.java.lang.String = "S32";
    val BitWidth: _root_.scala.Int = 32;
    val Min: S32 = new S32(-2147483648);
    val Max: S32 = new S32(2147483647);
    val Index: S32 = new S32(0);
    val isZeroIndex: _root_.scala.Boolean = true;
    val isSigned: _root_.scala.Boolean = true;
    val isWrapped: _root_.scala.Boolean = true;
    val isBitVector: _root_.scala.Boolean = true;
    val hasMin: _root_.scala.Boolean = true;
    val hasMax: _root_.scala.Boolean = true;
    def random: S32 = {
      val zMin = _root_.org.sireum.Z(Min.toBigInt);
      val d = _root_.org.sireum.Z(Max.toBigInt).-(zMin).+(_root_.org.sireum.Z.MP.one);
      val n = _root_.org.sireum.Z.random.%(d);
      new S32(n.+(zMin).toBigInt.toInt)
    };
    def randomSeed(seed: _root_.org.sireum.Z): S32 = {
      val zMin = _root_.org.sireum.Z(Min.toBigInt);
      val d = _root_.org.sireum.Z(Max.toBigInt).-(zMin).+(_root_.org.sireum.Z.MP.one);
      val n = _root_.org.sireum.Z.randomSeed(seed).%(d);
      new S32(n.+(zMin).toBigInt.toInt)
    };
    def apply(n: _root_.scala.Int): S32 = Int(n);
    def apply(n: _root_.scala.Long): S32 = Long(n);
    def apply(n: _root_.org.sireum.Z): S32 = n match {
      case (n @ ((_): _root_.org.sireum.Z.MP.Long)) => {
        if (isWrapped.`unary_!`)
          {
            assert(Min.toMP.<=(n), n.+(" is less than S32.Min (-2147483648)"));
            assert(n.<=(Max.toMP), n.+(" is greater than S32.Max (2147483647)"))
          }
        else
          ();
        new S32(n.value.toInt)
      }
      case (n @ ((_): _root_.org.sireum.Z.MP.BigInt)) => {
        if (isWrapped.`unary_!`)
          {
            assert(Min.toMP.<=(n), n.+(" is less than S32.Min (-2147483648)"));
            assert(n.<=(Max.toMP), n.+(" is greater than S32.Max (2147483647)"))
          }
        else
          ();
        new S32(n.value.toInt)
      }
      case _ => halt(StringContext("Unsupported ", " creation from ", ".").s(Name, n.Name))
    };
    def apply(s: _root_.org.sireum.String): _root_.org.sireum.Option[S32] = try {
      _root_.org.sireum.Some(S32.$String(s.value))
    } catch {
      case ((_): _root_.java.lang.Throwable) => _root_.org.sireum.None[S32]()
    };
    def unapply(n: S32): _root_.scala.Option[_root_.org.sireum.Z] = _root_.scala.Some(n.toMP);
    object Int extends _root_.org.sireum.$ZCompanionInt[S32] {
      def apply(n: _root_.scala.Int): S32 = if (isWrapped)
        new S32(n)
      else
        S32(_root_.org.sireum.Z.MP(n));
      def unapply(n: S32): _root_.scala.Option[_root_.scala.Int] = {
        val v = n.toMP;
        if (_root_.scala.Int.MinValue.<=(v).&&(v.<=(_root_.scala.Int.MaxValue)))
          _root_.scala.Some(v.toInt)
        else
          _root_.scala.None
      }
    };
    object Long extends _root_.org.sireum.$ZCompanionLong[S32] {
      def apply(n: _root_.scala.Long): S32 = if (isWrapped)
        new S32(n.toInt)
      else
        S32(_root_.org.sireum.Z.MP(n));
      def unapply(n: S32): _root_.scala.Option[_root_.scala.Long] = _root_.scala.Some(n.toMP.toLong)
    };
    object $String extends _root_.org.sireum.$ZCompanionString[S32] {
      def apply(s: _root_.java.lang.String): S32 = BigInt(_root_.org.sireum.Z.$String(s).toBigInt);
      def unapply(n: S32): _root_.scala.Option[_root_.java.lang.String] = _root_.scala.Some(n.toBigInt.toString)
    };
    object BigInt extends _root_.org.sireum.$ZCompanionBigInt[S32] {
      def apply(n: _root_.scala.BigInt): S32 = if (isWrapped)
        new S32(n.toInt)
      else
        S32(_root_.org.sireum.Z.MP(n));
      def unapply(n: S32): _root_.scala.Option[_root_.scala.BigInt] = _root_.scala.Some(n.toBigInt)
    };
    implicit class S32$Slang(val sc: _root_.scala.StringContext) {
      object s32 {
        def apply(args: _root_.scala.Any*): S32 = {
          assume(args.isEmpty.&&(sc.parts.length.==(1)));
          $String(sc.parts.head)
        };
        def unapply(n: S32): _root_.scala.Boolean = {
          assume(sc.parts.length.==(1));
          n.==($String(sc.parts.head))
        }
      }
    };
    implicit val $S32Companion: org.sireum.$ZCompanion[S32] = this
  }

  final class S32(val value: _root_.scala.Int) extends _root_.scala.AnyVal with _root_.org.sireum.Z.BV.Int[S32] {
    @inline def Name: _root_.java.lang.String = S32.Name;
    @inline def BitWidth: _root_.scala.Int = S32.BitWidth;
    @inline def Min: S32 = S32.Min;
    @inline def Max: S32 = S32.Max;
    @inline def Index: S32 = S32.Index;
    @inline def isZeroIndex: _root_.scala.Boolean = S32.isZeroIndex;
    @inline def isSigned: _root_.scala.Boolean = S32.isSigned;
    @inline def isWrapped: _root_.scala.Boolean = S32.isWrapped;
    def make(v: _root_.scala.Int): S32 = S32(v);
    def boxer = S32.Boxer
  }

  object U32 extends _root_.org.sireum.$ZCompanion[U32] {
    object Boxer extends _root_.org.sireum.Z.Boxer.Int {
      def make(o: _root_.scala.Int): U32 = new U32(o)
    };
    val Name: _root_.java.lang.String = "U32";
    val BitWidth: _root_.scala.Int = 32;
    val Min: U32 = new U32(0);
    val Max: U32 = new U32(-1);
    val Index: U32 = new U32(0);
    val isZeroIndex: _root_.scala.Boolean = true;
    val isSigned: _root_.scala.Boolean = false;
    val isWrapped: _root_.scala.Boolean = true;
    val isBitVector: _root_.scala.Boolean = true;
    val hasMin: _root_.scala.Boolean = true;
    val hasMax: _root_.scala.Boolean = true;
    def random: U32 = {
      val zMin = _root_.org.sireum.Z(Min.toBigInt);
      val d = _root_.org.sireum.Z(Max.toBigInt).-(zMin).+(_root_.org.sireum.Z.MP.one);
      val n = _root_.org.sireum.Z.random.%(d);
      new U32(n.+(zMin).toBigInt.toInt)
    };
    def randomSeed(seed: _root_.org.sireum.Z): U32 = {
      val zMin = _root_.org.sireum.Z(Min.toBigInt);
      val d = _root_.org.sireum.Z(Max.toBigInt).-(zMin).+(_root_.org.sireum.Z.MP.one);
      val n = _root_.org.sireum.Z.randomSeed(seed).%(d);
      new U32(n.+(zMin).toBigInt.toInt)
    };
    def apply(n: _root_.scala.Int): U32 = Int(n);
    def apply(n: _root_.scala.Long): U32 = Long(n);
    def apply(n: _root_.org.sireum.Z): U32 = n match {
      case (n @ ((_): _root_.org.sireum.Z.MP.Long)) => {
        if (isWrapped.`unary_!`)
          {
            assert(Min.toMP.<=(n), n.+(" is less than U32.Min (0)"));
            assert(n.<=(Max.toMP), n.+(" is greater than U32.Max (4294967295)"))
          }
        else
          ();
        new U32(n.value.toInt)
      }
      case (n @ ((_): _root_.org.sireum.Z.MP.BigInt)) => {
        if (isWrapped.`unary_!`)
          {
            assert(Min.toMP.<=(n), n.+(" is less than U32.Min (0)"));
            assert(n.<=(Max.toMP), n.+(" is greater than U32.Max (4294967295)"))
          }
        else
          ();
        new U32(n.value.toInt)
      }
      case _ => halt(StringContext("Unsupported ", " creation from ", ".").s(Name, n.Name))
    };
    def apply(s: _root_.org.sireum.String): _root_.org.sireum.Option[U32] = try {
      _root_.org.sireum.Some(U32.$String(s.value))
    } catch {
      case ((_): _root_.java.lang.Throwable) => _root_.org.sireum.None[U32]()
    };
    def unapply(n: U32): _root_.scala.Option[_root_.org.sireum.Z] = _root_.scala.Some(n.toMP);
    object Int extends _root_.org.sireum.$ZCompanionInt[U32] {
      def apply(n: _root_.scala.Int): U32 = if (isWrapped)
        new U32(n)
      else
        U32(_root_.org.sireum.Z.MP(n));
      def unapply(n: U32): _root_.scala.Option[_root_.scala.Int] = {
        val v = n.toMP;
        if (_root_.scala.Int.MinValue.<=(v).&&(v.<=(_root_.scala.Int.MaxValue)))
          _root_.scala.Some(v.toInt)
        else
          _root_.scala.None
      }
    };
    object Long extends _root_.org.sireum.$ZCompanionLong[U32] {
      def apply(n: _root_.scala.Long): U32 = if (isWrapped)
        new U32(n.toInt)
      else
        U32(_root_.org.sireum.Z.MP(n));
      def unapply(n: U32): _root_.scala.Option[_root_.scala.Long] = _root_.scala.Some(n.toMP.toLong)
    };
    object $String extends _root_.org.sireum.$ZCompanionString[U32] {
      def apply(s: _root_.java.lang.String): U32 = BigInt(_root_.org.sireum.Z.$String(s).toBigInt);
      def unapply(n: U32): _root_.scala.Option[_root_.java.lang.String] = _root_.scala.Some(n.toBigInt.toString)
    };
    object BigInt extends _root_.org.sireum.$ZCompanionBigInt[U32] {
      def apply(n: _root_.scala.BigInt): U32 = if (isWrapped)
        new U32(n.toInt)
      else
        U32(_root_.org.sireum.Z.MP(n));
      def unapply(n: U32): _root_.scala.Option[_root_.scala.BigInt] = _root_.scala.Some(n.toBigInt)
    };
    implicit class U32$Slang(val sc: _root_.scala.StringContext) {
      object u32 {
        def apply(args: _root_.scala.Any*): U32 = {
          assume(args.isEmpty.&&(sc.parts.length.==(1)));
          $String(sc.parts.head)
        };
        def unapply(n: U32): _root_.scala.Boolean = {
          assume(sc.parts.length.==(1));
          n.==($String(sc.parts.head))
        }
      }
    };
    implicit val $U32Companion: org.sireum.$ZCompanion[U32] = this
  }

  final class U32(val value: _root_.scala.Int) extends _root_.scala.AnyVal with _root_.org.sireum.Z.BV.Int[U32] {
    @inline def Name: _root_.java.lang.String = U32.Name;
    @inline def BitWidth: _root_.scala.Int = U32.BitWidth;
    @inline def Min: U32 = U32.Min;
    @inline def Max: U32 = U32.Max;
    @inline def Index: U32 = U32.Index;
    @inline def isZeroIndex: _root_.scala.Boolean = U32.isZeroIndex;
    @inline def isSigned: _root_.scala.Boolean = U32.isSigned;
    @inline def isWrapped: _root_.scala.Boolean = U32.isWrapped;
    def make(v: _root_.scala.Int): U32 = U32(v);
    def boxer = U32.Boxer
  }

  object S64 extends _root_.org.sireum.$ZCompanion[S64] {
    object Boxer extends _root_.org.sireum.Z.Boxer.Long {
      def make(o: _root_.scala.Long): S64 = new S64(o)
    };
    val Name: _root_.java.lang.String = "S64";
    val BitWidth: _root_.scala.Int = 64;
    val Min: S64 = new S64(-9223372036854775808L);
    val Max: S64 = new S64(9223372036854775807L);
    val Index: S64 = new S64(0L);
    val isZeroIndex: _root_.scala.Boolean = true;
    val isSigned: _root_.scala.Boolean = true;
    val isWrapped: _root_.scala.Boolean = true;
    val isBitVector: _root_.scala.Boolean = true;
    val hasMin: _root_.scala.Boolean = true;
    val hasMax: _root_.scala.Boolean = true;
    def random: S64 = {
      val zMin = _root_.org.sireum.Z(Min.toBigInt);
      val d = _root_.org.sireum.Z(Max.toBigInt).-(zMin).+(_root_.org.sireum.Z.MP.one);
      val n = _root_.org.sireum.Z.random.%(d);
      new S64(n.+(zMin).toBigInt.toLong)
    };
    def randomSeed(seed: _root_.org.sireum.Z): S64 = {
      val zMin = _root_.org.sireum.Z(Min.toBigInt);
      val d = _root_.org.sireum.Z(Max.toBigInt).-(zMin).+(_root_.org.sireum.Z.MP.one);
      val n = _root_.org.sireum.Z.randomSeed(seed).%(d);
      new S64(n.+(zMin).toBigInt.toLong)
    };
    def apply(n: _root_.scala.Int): S64 = Int(n);
    def apply(n: _root_.scala.Long): S64 = Long(n);
    def apply(n: _root_.org.sireum.Z): S64 = n match {
      case (n @ ((_): _root_.org.sireum.Z.MP.Long)) => {
        if (isWrapped.`unary_!`)
          {
            assert(Min.toMP.<=(n), n.+(" is less than S64.Min (-9223372036854775808)"));
            assert(n.<=(Max.toMP), n.+(" is greater than S64.Max (9223372036854775807)"))
          }
        else
          ();
        new S64(n.value)
      }
      case (n @ ((_): _root_.org.sireum.Z.MP.BigInt)) => {
        if (isWrapped.`unary_!`)
          {
            assert(Min.toMP.<=(n), n.+(" is less than S64.Min (-9223372036854775808)"));
            assert(n.<=(Max.toMP), n.+(" is greater than S64.Max (9223372036854775807)"))
          }
        else
          ();
        new S64(n.value.toLong)
      }
      case _ => halt(StringContext("Unsupported ", " creation from ", ".").s(Name, n.Name))
    };
    def apply(s: _root_.org.sireum.String): _root_.org.sireum.Option[S64] = try {
      _root_.org.sireum.Some(S64.$String(s.value))
    } catch {
      case ((_): _root_.java.lang.Throwable) => _root_.org.sireum.None[S64]()
    };
    def unapply(n: S64): _root_.scala.Option[_root_.org.sireum.Z] = _root_.scala.Some(n.toMP);
    object Int extends org.sireum.$ZCompanionInt[S64] {
      def apply(n: _root_.scala.Int): S64 = if (isWrapped)
        new S64(n)
      else
        S64(_root_.org.sireum.Z.MP(n));
      def unapply(n: S64): _root_.scala.Option[_root_.scala.Int] = {
        val v = n.toMP;
        if (_root_.scala.Int.MinValue.<=(v).&&(v.<=(_root_.scala.Int.MaxValue)))
          _root_.scala.Some(v.toInt)
        else
          _root_.scala.None
      }
    };
    object Long extends _root_.org.sireum.$ZCompanionLong[S64] {
      def apply(n: _root_.scala.Long): S64 = if (isWrapped)
        new S64(n)
      else
        S64(_root_.org.sireum.Z.MP(n));
      def unapply(n: S64): _root_.scala.Option[_root_.scala.Long] = {
        val v = n.toMP;
        if (_root_.scala.Long.MinValue.<=(v).&&(v.<=(_root_.scala.Long.MaxValue)))
          _root_.scala.Some(v.toLongOpt.get)
        else
          _root_.scala.None
      }
    };
    object $String extends _root_.org.sireum.$ZCompanionString[S64] {
      def apply(s: _root_.java.lang.String): S64 = BigInt(_root_.org.sireum.Z.$String(s).toBigInt);
      def unapply(n: S64): _root_.scala.Option[_root_.java.lang.String] = _root_.scala.Some(n.toBigInt.toString)
    };
    object BigInt extends _root_.org.sireum.$ZCompanionBigInt[S64] {
      def apply(n: _root_.scala.BigInt): S64 = if (isWrapped)
        new S64(n.toLong)
      else
        S64(_root_.org.sireum.Z.MP(n));
      def unapply(n: S64): _root_.scala.Option[_root_.scala.BigInt] = _root_.scala.Some(n.toBigInt)
    };
    implicit class S64$Slang(val sc: _root_.scala.StringContext) {
      object s64 {
        def apply(args: _root_.scala.Any*): S64 = {
          assume(args.isEmpty.&&(sc.parts.length.==(1)));
          $String(sc.parts.head)
        };
        def unapply(n: S64): _root_.scala.Boolean = {
          assume(sc.parts.length.==(1));
          n.==($String(sc.parts.head))
        }
      }
    };
    implicit val $S64Companion: org.sireum.$ZCompanion[S64] = this
  }

  final class S64(val value: _root_.scala.Long) extends _root_.scala.AnyVal with _root_.org.sireum.Z.BV.Long[S64] {
    @inline def Name: _root_.java.lang.String = S64.Name;
    @inline def BitWidth: _root_.scala.Int = S64.BitWidth;
    @inline def Min: S64 = S64.Min;
    @inline def Max: S64 = S64.Max;
    @inline def Index: S64 = S64.Index;
    @inline def isZeroIndex: _root_.scala.Boolean = S64.isZeroIndex;
    @inline def isSigned: _root_.scala.Boolean = S64.isSigned;
    @inline def isWrapped: _root_.scala.Boolean = S64.isWrapped;
    def make(v: _root_.scala.Long): S64 = S64(v);
    def boxer = S64.Boxer
  }

  object U64 extends _root_.org.sireum.$ZCompanion[U64] {
    object Boxer extends _root_.org.sireum.Z.Boxer.Long {
      def make(o: _root_.scala.Long): U64 = new U64(o)
    };
    val Name: _root_.java.lang.String = "U64";
    val BitWidth: _root_.scala.Int = 64;
    val Min: U64 = new U64(0L);
    val Max: U64 = new U64(-1L);
    val Index: U64 = new U64(0L);
    val isZeroIndex: _root_.scala.Boolean = true;
    val isSigned: _root_.scala.Boolean = false;
    val isWrapped: _root_.scala.Boolean = true;
    val isBitVector: _root_.scala.Boolean = true;
    val hasMin: _root_.scala.Boolean = true;
    val hasMax: _root_.scala.Boolean = true;
    def random: U64 = {
      val zMin = _root_.org.sireum.Z(Min.toBigInt);
      val d = _root_.org.sireum.Z(Max.toBigInt).-(zMin).+(_root_.org.sireum.Z.MP.one);
      val n = _root_.org.sireum.Z.random.%(d);
      new U64(n.+(zMin).toBigInt.toLong)
    };
    def randomSeed(seed: _root_.org.sireum.Z): U64 = {
      val zMin = _root_.org.sireum.Z(Min.toBigInt);
      val d = _root_.org.sireum.Z(Max.toBigInt).-(zMin).+(_root_.org.sireum.Z.MP.one);
      val n = _root_.org.sireum.Z.randomSeed(seed).%(d);
      new U64(n.+(zMin).toBigInt.toLong)
    };
    def apply(n: _root_.scala.Int): U64 = Int(n);
    def apply(n: _root_.scala.Long): U64 = Long(n);
    def apply(n: _root_.org.sireum.Z): U64 = n match {
      case (n @ ((_): _root_.org.sireum.Z.MP.Long)) => {
        if (isWrapped.`unary_!`)
          {
            assert(Min.toMP.<=(n), n.+(" is less than U64.Min (0)"));
            assert(n.<=(Max.toMP), n.+(" is greater than U64.Max (18446744073709551615)"))
          }
        else
          ();
        new U64(n.value)
      }
      case (n @ ((_): _root_.org.sireum.Z.MP.BigInt)) => {
        if (isWrapped.`unary_!`)
          {
            assert(Min.toMP.<=(n), n.+(" is less than U64.Min (0)"));
            assert(n.<=(Max.toMP), n.+(" is greater than U64.Max (18446744073709551615)"))
          }
        else
          ();
        new U64(n.value.toLong)
      }
      case _ => halt(StringContext("Unsupported ", " creation from ", ".").s(Name, n.Name))
    };
    def apply(s: _root_.org.sireum.String): _root_.org.sireum.Option[U64] = try {
      _root_.org.sireum.Some(U64.$String(s.value))
    } catch {
      case ((_): _root_.java.lang.Throwable) => _root_.org.sireum.None[U64]()
    };
    def unapply(n: U64): _root_.scala.Option[_root_.org.sireum.Z] = _root_.scala.Some(n.toMP);
    object Int extends org.sireum.$ZCompanionInt[U64] {
      def apply(n: _root_.scala.Int): U64 = if (isWrapped)
        new U64(n)
      else
        U64(_root_.org.sireum.Z.MP(n));
      def unapply(n: U64): _root_.scala.Option[_root_.scala.Int] = {
        val v = n.toMP;
        if (_root_.scala.Int.MinValue.<=(v).&&(v.<=(_root_.scala.Int.MaxValue)))
          _root_.scala.Some(v.toInt)
        else
          _root_.scala.None
      }
    };
    object Long extends _root_.org.sireum.$ZCompanionLong[U64] {
      def apply(n: _root_.scala.Long): U64 = if (isWrapped)
        new U64(n)
      else
        U64(_root_.org.sireum.Z.MP(n));
      def unapply(n: U64): _root_.scala.Option[_root_.scala.Long] = {
        val v = n.toMP;
        if (_root_.scala.Long.MinValue.<=(v).&&(v.<=(_root_.scala.Long.MaxValue)))
          _root_.scala.Some(v.toLongOpt.get)
        else
          _root_.scala.None
      }
    };
    object $String extends _root_.org.sireum.$ZCompanionString[U64] {
      def apply(s: _root_.java.lang.String): U64 = BigInt(_root_.org.sireum.Z.$String(s).toBigInt);
      def unapply(n: U64): _root_.scala.Option[_root_.java.lang.String] = _root_.scala.Some(n.toBigInt.toString)
    };
    object BigInt extends _root_.org.sireum.$ZCompanionBigInt[U64] {
      def apply(n: _root_.scala.BigInt): U64 = if (isWrapped)
        new U64(n.toLong)
      else
        U64(_root_.org.sireum.Z.MP(n));
      def unapply(n: U64): _root_.scala.Option[_root_.scala.BigInt] = _root_.scala.Some(n.toBigInt)
    };
    implicit class U64$Slang(val sc: _root_.scala.StringContext) {
      object u64 {
        def apply(args: _root_.scala.Any*): U64 = {
          assume(args.isEmpty.&&(sc.parts.length.==(1)));
          $String(sc.parts.head)
        };
        def unapply(n: U64): _root_.scala.Boolean = {
          assume(sc.parts.length.==(1));
          n.==($String(sc.parts.head))
        }
      }
    };
    implicit val $U64Companion: org.sireum.$ZCompanion[U64] = this
  }

  final class U64(val value: _root_.scala.Long) extends _root_.scala.AnyVal with _root_.org.sireum.Z.BV.Long[U64] {
    @inline def Name: _root_.java.lang.String = U64.Name;
    @inline def BitWidth: _root_.scala.Int = U64.BitWidth;
    @inline def Min: U64 = U64.Min;
    @inline def Max: U64 = U64.Max;
    @inline def Index: U64 = U64.Index;
    @inline def isZeroIndex: _root_.scala.Boolean = U64.isZeroIndex;
    @inline def isSigned: _root_.scala.Boolean = U64.isSigned;
    @inline def isWrapped: _root_.scala.Boolean = U64.isWrapped;
    def make(v: _root_.scala.Long): U64 = U64(v);
    def boxer = U64.Boxer
  }
}